/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reliquary.Reliquary;
import reliquary.util.LanguageHelper;

public class ItemBase
extends Item {
    private final Supplier<Boolean> isDisabled;

    public ItemBase() {
        this(new Item.Properties(), () -> false);
    }

    public ItemBase(Supplier<Boolean> isDisabled) {
        this(new Item.Properties(), isDisabled);
    }

    public ItemBase(Item.Properties properties) {
        this(properties, () -> false);
    }

    public ItemBase(Item.Properties properties, Supplier<Boolean> isDisabled) {
        super(properties.m_41491_(Reliquary.ITEM_GROUP));
        this.isDisabled = isDisabled;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (Boolean.TRUE.equals(this.isDisabled.get())) {
            return;
        }
        super.m_6787_(group, items);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (LanguageHelper.localizationExists(this.m_5524_() + ".tooltip")) {
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip")).m_130940_(ChatFormatting.GRAY));
        }
        if (this.hasMoreInformation(stack)) {
            if (Screen.m_96638_()) {
                ArrayList detailTooltip = Lists.newArrayList();
                this.addMoreInformation(stack, world, detailTooltip);
                if (!detailTooltip.isEmpty()) {
                    tooltip.add((Component)Component.m_237113_((String)""));
                    tooltip.addAll(detailTooltip);
                }
            } else {
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.reliquary.hold_for_more_info", (Object[])new Object[]{Component.m_237115_((String)"tooltip.reliquary.shift").m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    protected boolean hasMoreInformation(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack stack, @Nullable Level world, List<Component> tooltip) {
    }

    public Component m_7626_(ItemStack stack) {
        return Component.m_237113_((String)LanguageHelper.getLocalization(this.m_5671_(stack), new Object[0]));
    }
}

