/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import reliquary.handler.CommonEventHandler;
import reliquary.handler.HandlerPriority;
import reliquary.handler.IPlayerHurtHandler;
import reliquary.init.ModItems;
import reliquary.items.ToggleableItem;
import reliquary.items.util.fluid.FluidHandlerInfernalChalice;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;
import reliquary.util.LanguageHelper;
import reliquary.util.NBTHelper;

public class InfernalChaliceItem
extends ToggleableItem {
    public InfernalChaliceItem() {
        super(new Item.Properties().m_41487_(1).setNoRepair());
        CommonEventHandler.registerPlayerHurtHandler(new IPlayerHurtHandler(){

            @Override
            public boolean canApply(Player player, LivingAttackEvent event) {
                return (event.getSource() == DamageSource.f_19308_ || event.getSource() == DamageSource.f_19307_ || event.getSource() == DamageSource.f_19305_) && player.m_36324_().m_38702_() > 0 && InventoryHelper.playerHasItem(player, (Item)ModItems.INFERNAL_CHALICE.get());
            }

            @Override
            public boolean apply(Player player, LivingAttackEvent event) {
                player.m_36399_(event.getAmount() * ((float)((Integer)Settings.COMMON.items.infernalChalice.hungerCostPercent.get()).intValue() / 100.0f));
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.HIGH;
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack chalice, @Nullable Level world, List<Component> tooltip) {
        LanguageHelper.formatTooltip(this.m_5524_() + ".tooltip2", Map.of("amount", String.valueOf(NBTHelper.getInt("fluidStacks", chalice))), tooltip);
        if (this.isEnabled(chalice)) {
            LanguageHelper.formatTooltip("tooltip.place", tooltip);
        } else {
            LanguageHelper.formatTooltip("tooltip.drain", tooltip);
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            return super.m_7203_(world, player, hand);
        }
        BlockHitResult result = InfernalChaliceItem.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)(this.isEnabled(stack) ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        BlockPos pos = result.m_82425_();
        if (!world.m_7966_(player, pos)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        Direction face = result.m_82434_();
        if (!player.m_36204_(pos, face, stack)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        return this.getFluidHandler(stack).map(fluidHandler -> this.interactWithFluidHandler(world, player, stack, pos, face, (IFluidHandlerItem)fluidHandler)).orElse(new InteractionResultHolder(InteractionResult.FAIL, (Object)stack));
    }

    private InteractionResultHolder<ItemStack> interactWithFluidHandler(Level world, Player player, ItemStack stack, BlockPos pos, Direction face, IFluidHandlerItem fluidHandler) {
        BlockState blockState = world.m_8055_(pos);
        if (this.isEnabled(stack)) {
            if (blockState.m_60734_() == Blocks.f_49991_ && (Integer)blockState.m_61143_((Property)LiquidBlock.f_54688_) == 0 && fluidHandler.fill(new FluidStack((Fluid)Fluids.f_76195_, 1000), IFluidHandler.FluidAction.SIMULATE) == 1000) {
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                fluidHandler.fill(new FluidStack((Fluid)Fluids.f_76195_, 1000), IFluidHandler.FluidAction.EXECUTE);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
        } else {
            BlockPos adjustedPos;
            FluidStack fluidDrained = fluidHandler.drain(new FluidStack((Fluid)Fluids.f_76195_, 1000), IFluidHandler.FluidAction.SIMULATE);
            if ((player.m_7500_() || fluidDrained.getAmount() == 1000) && this.tryPlaceContainedLiquid(world, adjustedPos = pos.m_121945_(face)) && !player.m_7500_()) {
                fluidHandler.drain(new FluidStack((Fluid)Fluids.f_76195_, 1000), IFluidHandler.FluidAction.EXECUTE);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    private LazyOptional<IFluidHandlerItem> getFluidHandler(ItemStack stack) {
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    private boolean tryPlaceContainedLiquid(Level world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        Material material = blockState.m_60767_();
        if (!world.m_46859_(pos) && material.m_76333_()) {
            return false;
        }
        world.m_7731_(pos, Blocks.f_49991_.m_49966_(), 3);
        return true;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidHandlerInfernalChalice(stack);
    }
}

