/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItem;
import reliquary.blocks.tile.PedestalBlockEntity;
import reliquary.init.ModFluids;
import reliquary.init.ModItems;
import reliquary.items.ItemBase;
import reliquary.items.VoidTearItem;
import reliquary.items.util.ICuriosItem;
import reliquary.pedestal.PedestalRegistry;
import reliquary.reference.Settings;
import reliquary.util.LanguageHelper;
import reliquary.util.NBTHelper;
import reliquary.util.RandHelper;
import reliquary.util.XpHelper;

public class FortuneCoinItem
extends ItemBase
implements IPedestalActionItem,
ICuriosItem {
    private static final String PREVENT_REMOTE_MOVEMENT = "PreventRemoteMovement";
    private static final String ALLOW_MACHINE_MOVEMENT = "AllowMachineRemoteMovement";
    private static final Set<IFortuneCoinPickupChecker> pickupCheckers = new HashSet<IFortuneCoinPickupChecker>();

    public static void addFortuneCoinPickupChecker(IFortuneCoinPickupChecker checker) {
        pickupCheckers.add(checker);
    }

    public FortuneCoinItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Override
    public void onEquipped(String identifier, LivingEntity player) {
        if (player.f_19853_.f_46443_) {
            player.m_5496_(SoundEvents.f_11871_, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.f_19853_.f_46441_) * 0.7f + 2.2f));
        }
    }

    @Override
    public ICuriosItem.Type getCuriosType() {
        return ICuriosItem.Type.NECKLACE;
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity player) {
        this.m_6883_(stack, player.f_19853_, (Entity)player, 0, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack stack, @Nullable Level world, List<Component> tooltip) {
        LanguageHelper.formatTooltip(this.m_5524_() + ".tooltip2", tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return FortuneCoinItem.isEnabled(stack);
    }

    public static boolean isEnabled(ItemStack stack) {
        return NBTHelper.getBoolean("enabled", stack);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (world.f_46443_ || world.m_46467_() % 2L != 0L) {
            return;
        }
        if (!FortuneCoinItem.isEnabled(stack)) {
            return;
        }
        if (!(entity instanceof Player) || (player = (Player)entity).m_5833_()) {
            return;
        }
        this.scanForEntitiesInRange(world, player, this.getStandardPullDistance());
    }

    private void scanForEntitiesInRange(Level world, Player player, double d) {
        List<BlockPos> disablePositions = this.getDisablePositions(world, player.m_20183_());
        List items = world.m_45976_(ItemEntity.class, player.m_20191_().m_82400_(d));
        for (ItemEntity item : items) {
            if (!this.canPickupItem(item, disablePositions, false) || !this.checkForRoom(item.m_32055_(), player)) continue;
            item.m_32010_(0);
            if (!((double)player.m_20270_((Entity)item) >= 1.5)) continue;
            this.teleportEntityToPlayer((Entity)item, player);
            break;
        }
        List xpOrbs = world.m_45976_(ExperienceOrb.class, player.m_20191_().m_82400_(d));
        for (ExperienceOrb xpOrb : xpOrbs) {
            if (player.f_36101_ > 0) {
                player.f_36101_ = 0;
            }
            if (!((double)player.m_20270_((Entity)xpOrb) >= 1.5)) continue;
            this.teleportEntityToPlayer((Entity)xpOrb, player);
            break;
        }
    }

    private boolean canPickupItem(ItemEntity item, List<BlockPos> disablePositions, boolean isInPedestal) {
        CompoundTag data = item.getPersistentData();
        if (!(!data.m_128471_(PREVENT_REMOTE_MOVEMENT) || isInPedestal && data.m_128471_(ALLOW_MACHINE_MOVEMENT))) {
            return false;
        }
        if (this.isInDisabledRange(item, disablePositions)) {
            return false;
        }
        for (IFortuneCoinPickupChecker pickupChecker : pickupCheckers) {
            if (pickupChecker.canPickup(item)) continue;
            return false;
        }
        return true;
    }

    private boolean isInDisabledRange(ItemEntity item, List<BlockPos> disablePositions) {
        for (BlockPos disablePos : disablePositions) {
            if (Math.abs(item.m_20183_().m_123341_() - disablePos.m_123341_()) >= 5 || Math.abs(item.m_20183_().m_123342_() - disablePos.m_123342_()) >= 5 || Math.abs(item.m_20183_().m_123343_() - disablePos.m_123343_()) >= 5) continue;
            return true;
        }
        return false;
    }

    private List<BlockPos> getDisablePositions(Level world, BlockPos coinPos) {
        ArrayList<BlockPos> disablePositions = new ArrayList<BlockPos>();
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(world.m_46472_().m_211136_(), coinPos, 10);
        for (BlockPos pos : pedestalPositions) {
            ItemStack stack;
            PedestalBlockEntity pedestal;
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof PedestalBlockEntity) || !(pedestal = (PedestalBlockEntity)te).switchedOn() || (stack = pedestal.m_8020_(0)).m_41619_() || stack.m_41720_() != this || FortuneCoinItem.isEnabled(stack)) continue;
            disablePositions.add(pos);
        }
        return disablePositions;
    }

    private void teleportEntityToPlayer(Entity item, Player player) {
        player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, item.m_20185_() + 0.5 + player.f_19853_.f_46441_.m_188583_() / 8.0, item.m_20186_() + 0.2, item.m_20189_() + 0.5 + player.f_19853_.f_46441_.m_188583_() / 8.0, 0.9, 0.9, 0.0);
        player.m_20154_();
        double x = player.m_20185_() + player.m_20154_().f_82479_ * 0.2;
        double y = player.m_20186_();
        double z = player.m_20189_() + player.m_20154_().f_82481_ * 0.2;
        item.m_6034_(x, y, z);
    }

    private boolean checkForRoom(ItemStack stackToPickup, Player player) {
        int remaining = stackToPickup.m_41613_();
        for (ItemStack inventoryStack : player.m_150109_().f_35974_) {
            if (inventoryStack.m_41619_()) {
                return true;
            }
            if (inventoryStack.m_41720_() == stackToPickup.m_41720_() && inventoryStack.m_41773_() == stackToPickup.m_41773_()) {
                if (inventoryStack.m_41613_() + remaining <= inventoryStack.m_41741_()) {
                    return true;
                }
                remaining -= inventoryStack.m_41741_() - inventoryStack.m_41613_();
                continue;
            }
            if (inventoryStack.m_41720_() != ModItems.VOID_TEAR.get() || !((VoidTearItem)ModItems.VOID_TEAR.get()).isEnabled(inventoryStack) || !((VoidTearItem)ModItems.VOID_TEAR.get()).canAbsorbStack(stackToPickup, inventoryStack)) continue;
            return true;
        }
        return false;
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        this.scanForEntitiesInRange(player.f_19853_, player, this.getLongRangePullDistance());
    }

    private double getLongRangePullDistance() {
        return ((Integer)Settings.COMMON.items.fortuneCoin.longRangePullDistance.get()).intValue();
    }

    private double getStandardPullDistance() {
        return ((Integer)Settings.COMMON.items.fortuneCoin.standardPullDistance.get()).intValue();
    }

    public int m_8105_(ItemStack stack) {
        return 64;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            this.toggle(stack);
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.f_19853_.f_46441_) * 0.7f + 1.8f));
        } else {
            player.m_6672_(hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    public void update(ItemStack stack, Level level, IPedestal pedestal) {
        if (level.f_46443_) {
            return;
        }
        if (FortuneCoinItem.isEnabled(stack)) {
            BlockPos pos = pedestal.getBlockPosition();
            this.pickupItems(pedestal, level, pos);
            this.pickupXp(pedestal, level, pos);
        }
    }

    private void pickupItems(IPedestal pedestal, Level level, BlockPos pos) {
        List<BlockPos> disablePositions = this.getDisablePositions(level, pos);
        List entities = level.m_45976_(ItemEntity.class, new AABB(pos).m_82400_(this.getStandardPullDistance()));
        for (ItemEntity entityItem : entities) {
            if (!this.canPickupItem(entityItem, disablePositions, true)) continue;
            int numberAdded = pedestal.addToConnectedInventory(level, entityItem.m_32055_().m_41777_());
            if (numberAdded > 0) {
                entityItem.m_32055_().m_41764_(entityItem.m_32055_().m_41613_() - numberAdded);
                if (entityItem.m_32055_().m_41613_() > 0) continue;
                entityItem.m_146870_();
                continue;
            }
            pedestal.setActionCoolDown(20);
        }
    }

    private void pickupXp(IPedestal pedestal, Level world, BlockPos pos) {
        List xpOrbs = world.m_45976_(ExperienceOrb.class, new AABB(pos).m_82400_(this.getStandardPullDistance()));
        for (ExperienceOrb xpOrb : xpOrbs) {
            int amountToTransfer = XpHelper.experienceToLiquid(xpOrb.f_20770_);
            int amountAdded = pedestal.fillConnectedTank(new FluidStack((Fluid)ModFluids.XP_JUICE_STILL.get(), amountToTransfer));
            if (amountAdded > 0) {
                xpOrb.m_146870_();
                if (amountToTransfer <= amountAdded) continue;
                world.m_7967_((Entity)new ExperienceOrb(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), XpHelper.liquidToExperience(amountToTransfer - amountAdded)));
                continue;
            }
            pedestal.setActionCoolDown(20);
        }
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, Level level, IPedestal pedestal) {
    }

    public void toggle(ItemStack stack) {
        NBTHelper.putBoolean("enabled", stack, !FortuneCoinItem.isEnabled(stack));
    }

    public static interface IFortuneCoinPickupChecker {
        public boolean canPickup(ItemEntity var1);
    }
}

