/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reliquary.items.ItemBase;
import reliquary.items.util.IPotionItem;
import reliquary.reference.Settings;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionMap;
import reliquary.util.potions.XRPotionHelper;

public class BulletItem
extends ItemBase
implements IPotionItem {
    private final boolean hasTooltip;
    private final boolean addPotionBulletsInItemGroup;
    private final int color;

    public BulletItem(boolean hasTooltip, boolean addPotionBulletsInItemGroup, int color) {
        super(new Item.Properties().setNoRepair());
        this.hasTooltip = hasTooltip;
        this.addPotionBulletsInItemGroup = addPotionBulletsInItemGroup;
        this.color = color;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (this.hasTooltip) {
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip")).m_130940_(ChatFormatting.GRAY));
        }
        XRPotionHelper.addPotionTooltip(stack, tooltip);
    }

    @Override
    public void m_6787_(CreativeModeTab itemGroup, NonNullList<ItemStack> items) {
        if (!this.m_220152_(itemGroup) || Boolean.TRUE.equals(Settings.COMMON.disable.disableHandgun.get())) {
            return;
        }
        items.add((Object)new ItemStack((ItemLike)this));
        if (!this.addPotionBulletsInItemGroup || Boolean.TRUE.equals(Settings.COMMON.disable.disablePotions.get())) {
            return;
        }
        for (PotionEssence essence : PotionMap.uniquePotionEssences) {
            ItemStack bullet = new ItemStack((ItemLike)this);
            XRPotionHelper.addPotionEffectsToStack(bullet, XRPotionHelper.changePotionEffectsDuration(essence.getEffects(), 0.2f));
            items.add((Object)bullet);
        }
    }

    @Override
    public List<MobEffectInstance> getEffects(ItemStack stack) {
        return XRPotionHelper.getPotionEffectsFromStack(stack);
    }

    public int getColor() {
        return this.color;
    }
}

