/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import reliquary.handler.CommonEventHandler;
import reliquary.handler.HandlerPriority;
import reliquary.handler.IPlayerHurtHandler;
import reliquary.init.ModItems;
import reliquary.items.ItemBase;
import reliquary.items.PhoenixDownItem;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;

public class AngelicFeatherItem
extends ItemBase {
    public AngelicFeatherItem() {
        super(new Item.Properties().m_41487_(1).setNoRepair().m_41497_(Rarity.EPIC));
        CommonEventHandler.registerPlayerHurtHandler(new IPlayerHurtHandler(){

            @Override
            public boolean canApply(Player player, LivingAttackEvent event) {
                return event.getSource() == DamageSource.f_19315_ && player.m_36324_().m_38702_() > 0 && InventoryHelper.playerHasItem(player, (Item)ModItems.ANGELIC_FEATHER.get()) && player.f_19789_ > 0.0f;
            }

            @Override
            public boolean apply(Player player, LivingAttackEvent event) {
                float hungerDamage = event.getAmount() * ((float)((Integer)Settings.COMMON.items.angelicFeather.hungerCostPercent.get()).intValue() / 100.0f);
                player.m_36399_(hungerDamage);
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.HIGH;
            }
        });
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        int potency = this instanceof PhoenixDownItem ? (Integer)Settings.COMMON.items.phoenixDown.leapingPotency.get() : (Integer)Settings.COMMON.items.angelicFeather.leapingPotency.get();
        if (potency == 0) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 2, potency, true, false));
        }
    }
}

