/*
 * Decompiled with CFR 0.152.
 */
package reliquary.handler;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import reliquary.client.gui.components.Box;
import reliquary.client.gui.components.Component;
import reliquary.client.gui.components.ItemStackPane;
import reliquary.client.gui.components.TextPane;
import reliquary.client.gui.hud.ChargePane;
import reliquary.client.gui.hud.ChargeableItemInfoPane;
import reliquary.client.gui.hud.CharmPane;
import reliquary.client.gui.hud.DynamicChargePane;
import reliquary.client.gui.hud.HUDPosition;
import reliquary.client.gui.hud.HUDRenderrer;
import reliquary.client.gui.hud.HandgunPane;
import reliquary.client.gui.hud.HeroMedallionPane;
import reliquary.client.init.ItemModels;
import reliquary.client.init.ModBlockColors;
import reliquary.client.init.ModItemColors;
import reliquary.client.init.ModParticles;
import reliquary.client.model.MobCharmBeltModel;
import reliquary.client.model.WitchHatModel;
import reliquary.client.registry.PedestalClientRegistry;
import reliquary.client.render.ApothecaryMortarRenderer;
import reliquary.client.render.LyssaHookRenderer;
import reliquary.client.render.PassivePedestalRenderer;
import reliquary.client.render.PedestalFishHookRenderer;
import reliquary.client.render.PedestalRenderer;
import reliquary.client.render.ShotRenderer;
import reliquary.client.render.XRTippedArrowRenderer;
import reliquary.init.ModBlocks;
import reliquary.init.ModEntities;
import reliquary.init.ModItems;
import reliquary.items.EnderStaffItem;
import reliquary.items.FortuneCoinToggler;
import reliquary.items.HandgunItem;
import reliquary.items.HarvestRodItem;
import reliquary.items.InfernalTearItem;
import reliquary.items.PyromancerStaffItem;
import reliquary.items.RendingGaleItem;
import reliquary.items.RodOfLyssaItem;
import reliquary.items.SojournerStaffItem;
import reliquary.items.VoidTearItem;
import reliquary.items.util.IScrollableItem;
import reliquary.network.PacketHandler;
import reliquary.network.ScrolledItemPacket;
import reliquary.reference.Colors;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;
import reliquary.util.LanguageHelper;
import reliquary.util.NBTHelper;
import reliquary.util.potions.XRPotionHelper;

public class ClientEventHandler {
    private static final int KEY_UNKNOWN = -1;
    public static final KeyMapping FORTUNE_COIN_TOGGLE_KEYBIND = new KeyMapping("keybind.reliquary.fortune_coin", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM.m_84895_(-1), "keybind.reliquary.category");
    private static final String VOID_TEAR_MODE_TRANSLATION = "item.reliquary.void_tear.mode.";
    public static final ModelLayerLocation WITCH_HAT_LAYER = new ModelLayerLocation(new ResourceLocation("reliquary", "witch_hat"), "main");
    public static final ModelLayerLocation MOB_CHARM_BELT_LAYER = new ModelLayerLocation(new ResourceLocation("reliquary", "mob_charm_belt"), "main");
    private static final List<Tuple<Component, HUDPosition>> hudComponents = Lists.newArrayList();

    private ClientEventHandler() {
    }

    public static void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ClientEventHandler::clientSetup);
        modBus.addListener(ClientEventHandler::registerKeyMappings);
        modBus.addListener(ClientEventHandler::loadComplete);
        modBus.addListener(ModParticles.ProviderHandler::registerProviders);
        modBus.addListener(ClientEventHandler::registerEntityRenderers);
        modBus.addListener(ItemModels::onModelBake);
        modBus.addListener(ClientEventHandler::registerLayer);
        modBus.addListener(ModBlockColors::registerBlockColors);
        modBus.addListener(ModItemColors::registerItemColors);
        modBus.addListener(ClientEventHandler::registerOverlay);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(ClientEventHandler::onRenderLiving);
        eventBus.addListener(ClientEventHandler::onMouseScrolled);
    }

    private static void onRenderLiving(RenderLivingEvent.Pre<Player, PlayerModel<Player>> event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            boolean handgunInMain;
            Player player = (Player)livingEntity;
            boolean handgunInOff = player.m_21120_(InteractionHand.OFF_HAND).m_41720_() == ModItems.HANDGUN.get();
            boolean bl = handgunInMain = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == ModItems.HANDGUN.get();
            if (handgunInOff || handgunInMain) {
                ClientEventHandler.setHandgunArmPoses(event, player, handgunInOff, handgunInMain);
            }
        }
    }

    private static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(WITCH_HAT_LAYER, WitchHatModel::createBodyLayer);
        event.registerLayerDefinition(MOB_CHARM_BELT_LAYER, MobCharmBeltModel::createBodyLayer);
    }

    private static void setHandgunArmPoses(RenderLivingEvent.Pre<Player, PlayerModel<Player>> event, Player player, boolean handgunInOff, boolean handgunInMain) {
        PlayerModel model = (PlayerModel)event.getRenderer().m_7200_();
        if (ClientEventHandler.isHandgunActive(player, handgunInMain, handgunInOff)) {
            InteractionHand hand = ClientEventHandler.getActiveHandgunHand(player, handgunInMain, handgunInOff);
            HumanoidArm primaryHand = player.m_5737_();
            if ((hand == InteractionHand.MAIN_HAND && primaryHand == HumanoidArm.RIGHT || hand == InteractionHand.OFF_HAND && primaryHand == HumanoidArm.LEFT) && model.f_102816_ != HumanoidModel.ArmPose.BOW_AND_ARROW) {
                model.f_102816_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else if ((hand == InteractionHand.OFF_HAND && primaryHand == HumanoidArm.RIGHT || hand == InteractionHand.MAIN_HAND && primaryHand == HumanoidArm.LEFT) && model.f_102815_ != HumanoidModel.ArmPose.BOW_AND_ARROW) {
                model.f_102815_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        } else {
            if (model.f_102816_ == HumanoidModel.ArmPose.BOW_AND_ARROW) {
                model.f_102816_ = HumanoidModel.ArmPose.ITEM;
            }
            if (model.f_102815_ == HumanoidModel.ArmPose.BOW_AND_ARROW) {
                model.f_102815_ = HumanoidModel.ArmPose.ITEM;
            }
        }
    }

    private static InteractionHand getActiveHandgunHand(Player player, boolean handgunInMain, boolean handgunInOff) {
        boolean offValid;
        if (handgunInMain != handgunInOff) {
            return handgunInMain ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        }
        boolean mainValid = ClientEventHandler.isValidTimeFrame(player.f_19853_, player.m_21205_());
        if (mainValid != (offValid = ClientEventHandler.isValidTimeFrame(player.f_19853_, player.m_21206_()))) {
            return mainValid ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        }
        return ((HandgunItem)((Object)ModItems.HANDGUN.get())).getCooldown(player.m_21205_()) < ((HandgunItem)((Object)ModItems.HANDGUN.get())).getCooldown(player.m_21206_()) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    private static boolean isHandgunActive(Player player, boolean handgunInMain, boolean handgunInOff) {
        return handgunInMain && ClientEventHandler.isValidTimeFrame(player.f_19853_, player.m_21205_()) || handgunInOff && ClientEventHandler.isValidTimeFrame(player.f_19853_, player.m_21206_());
    }

    private static boolean isValidTimeFrame(Level world, ItemStack handgun) {
        long cooldownTime = ((HandgunItem)((Object)ModItems.HANDGUN.get())).getCooldown(handgun) + 5L;
        return cooldownTime - world.m_46467_() <= (long)((HandgunItem)((Object)ModItems.HANDGUN.get())).m_8105_(handgun) && cooldownTime >= world.m_46467_();
    }

    private static void registerOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "reliquary_hud", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
            if (hudComponents.isEmpty()) {
                ClientEventHandler.initHUDComponents();
            }
            ClientEventHandler.renderHUDComponents(poseStack);
        });
    }

    private static void onMouseScrolled(InputEvent.MouseScrollingEvent evt) {
        IScrollableItem scrollableItem;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null || !Screen.m_96638_()) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        double scrollDelta = evt.getScrollDelta();
        Item item = stack.m_41720_();
        if (item instanceof IScrollableItem && (scrollableItem = (IScrollableItem)item).onMouseScrolled(stack, (Player)player, scrollDelta) == InteractionResult.PASS) {
            PacketHandler.sendToServer(new ScrolledItemPacket(scrollDelta));
            evt.setCanceled(true);
        }
    }

    private static void renderHUDComponents(PoseStack matrixStack) {
        for (Tuple<Component, HUDPosition> component : hudComponents) {
            HUDRenderrer.render(matrixStack, (Component)component.m_14418_(), (HUDPosition)((Object)component.m_14419_()));
        }
    }

    private static void initHUDComponents() {
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.ALKAHESTRY_TOME.get(), (HUDPosition)((Object)Settings.CLIENT.hudPositions.alkahestryTome.get()), new ItemStack((ItemLike)Items.f_42451_), is -> NBTHelper.getInt("charge", is)), (Object)((HUDPosition)((Object)Settings.CLIENT.hudPositions.alkahestryTome.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.DESTRUCTION_CATALYST.get(), (HUDPosition)((Object)Settings.CLIENT.hudPositions.destructionCatalyst.get()), new ItemStack((ItemLike)Items.f_42403_), is -> NBTHelper.getInt("gunpowder", is)), (Object)((HUDPosition)((Object)Settings.CLIENT.hudPositions.destructionCatalyst.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.MIDAS_TOUCHSTONE.get(), (HUDPosition)((Object)Settings.CLIENT.hudPositions.midasTouchstone.get()), new ItemStack((ItemLike)Items.f_42525_), is -> NBTHelper.getInt("glowstone", is)), (Object)((HUDPosition)((Object)Settings.CLIENT.hudPositions.midasTouchstone.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.INFERNAL_CHALICE.get(), (HUDPosition)((Object)Settings.CLIENT.hudPositions.infernalChalice.get()), new ItemStack((ItemLike)Items.f_42448_), is -> NBTHelper.getInt("fluidStacks", is) / 1000, Colors.get("CC3024")), (Object)((HUDPosition)((Object)Settings.CLIENT.hudPositions.infernalChalice.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.ICE_MAGUS_ROD.get(), (HUDPosition)((Object)Settings.CLIENT.hudPositions.iceMagusRod.get()), new ItemStack((ItemLike)Items.f_42452_), is -> NBTHelper.getInt("snowballs", is)), (Object)((HUDPosition)((Object)Settings.CLIENT.hudPositions.iceMagusRod.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.GLACIAL_STAFF.get(), (HUDPosition)((Object)Settings.CLIENT.hudPositions.glacialStaff.get()), new ItemStack((ItemLike)Items.f_42452_), is -> NBTHelper.getInt("snowballs", is)), (Object)((HUDPosition)((Object)Settings.CLIENT.hudPositions.glacialStaff.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.ENDER_STAFF.get(), (HUDPosition)((Object)Settings.CLIENT.hudPositions.enderStaff.get()), is -> ((EnderStaffItem)ModItems.ENDER_STAFF.get()).getMode((ItemStack)is).m_7912_(), Map.of(EnderStaffItem.Mode.CAST.m_7912_(), new ChargePane((Item)ModItems.ENDER_STAFF.get(), new ItemStack((ItemLike)Items.f_42584_), is -> ((EnderStaffItem)ModItems.ENDER_STAFF.get()).getPearlCount((ItemStack)is, true)), EnderStaffItem.Mode.NODE_WARP.m_7912_(), new ChargePane((Item)ModItems.ENDER_STAFF.get(), new ItemStack((ItemLike)ModBlocks.WRAITH_NODE.get()), is -> ((EnderStaffItem)ModItems.ENDER_STAFF.get()).getPearlCount((ItemStack)is, true)), EnderStaffItem.Mode.LONG_CAST.m_7912_(), new ChargePane((Item)ModItems.ENDER_STAFF.get(), new ItemStack((ItemLike)Items.f_42545_), is -> ((EnderStaffItem)ModItems.ENDER_STAFF.get()).getPearlCount((ItemStack)is, true)))), (Object)((HUDPosition)((Object)Settings.CLIENT.hudPositions.enderStaff.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.PYROMANCER_STAFF.get(), (HUDPosition)((Object)Settings.CLIENT.hudPositions.pyromancerStaff.get()), is -> ((PyromancerStaffItem)ModItems.PYROMANCER_STAFF.get()).getMode((ItemStack)is).m_7912_(), Map.of(PyromancerStaffItem.Mode.BLAZE.m_7912_(), new ChargePane((Item)ModItems.PYROMANCER_STAFF.get(), new ItemStack((ItemLike)Items.f_42593_), is -> ((PyromancerStaffItem)ModItems.PYROMANCER_STAFF.get()).getInternalStorageItemCount((ItemStack)is, Items.f_42593_)), PyromancerStaffItem.Mode.FIRE_CHARGE.m_7912_(), new ChargePane((Item)ModItems.PYROMANCER_STAFF.get(), new ItemStack((ItemLike)Items.f_42613_), is -> ((PyromancerStaffItem)ModItems.PYROMANCER_STAFF.get()).getInternalStorageItemCount((ItemStack)is, Items.f_42613_)), PyromancerStaffItem.Mode.ERUPTION.m_7912_(), Box.createVertical(Box.Alignment.RIGHT, new TextPane("ERUPT"), new ChargePane((Item)ModItems.PYROMANCER_STAFF.get(), new ItemStack((ItemLike)Items.f_42593_), is -> ((PyromancerStaffItem)ModItems.PYROMANCER_STAFF.get()).getInternalStorageItemCount((ItemStack)is, Items.f_42593_))), PyromancerStaffItem.Mode.FLINT_AND_STEEL.m_7912_(), new ItemStackPane(Items.f_42409_))), (Object)((HUDPosition)((Object)Settings.CLIENT.hudPositions.pyromancerStaff.get()))));
        ChargePane rendingGaleFeatherPane = new ChargePane((Item)ModItems.RENDING_GALE.get(), new ItemStack((ItemLike)Items.f_42402_), is -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            return player == null ? 0 : ((RendingGaleItem)ModItems.RENDING_GALE.get()).getFeatherCountClient((ItemStack)is, (Player)player) / 100;
        });
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.RENDING_GALE.get(), (HUDPosition)((Object)Settings.CLIENT.hudPositions.rendingGale.get()), is -> ((RendingGaleItem)ModItems.RENDING_GALE.get()).getMode((ItemStack)is).m_7912_(), Map.of(RendingGaleItem.Mode.PUSH.m_7912_(), Box.createVertical(Box.Alignment.RIGHT, new TextPane("PUSH"), rendingGaleFeatherPane), RendingGaleItem.Mode.PULL.m_7912_(), Box.createVertical(Box.Alignment.RIGHT, new TextPane("PULL"), rendingGaleFeatherPane), RendingGaleItem.Mode.BOLT.m_7912_(), Box.createVertical(Box.Alignment.RIGHT, new TextPane("BOLT"), rendingGaleFeatherPane), RendingGaleItem.Mode.FLIGHT.m_7912_(), Box.createVertical(Box.Alignment.RIGHT, new TextPane("FLIGHT"), rendingGaleFeatherPane))), (Object)((HUDPosition)((Object)Settings.CLIENT.hudPositions.rendingGale.get()))));
        DynamicChargePane contentsPane = new DynamicChargePane((Item)ModItems.VOID_TEAR.get(), is -> VoidTearItem.getTearContents(is, true), is -> VoidTearItem.getTearContents(is, true).m_41613_());
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.VOID_TEAR.get(), (HUDPosition)((Object)Settings.CLIENT.hudPositions.voidTear.get()), is -> ((VoidTearItem)ModItems.VOID_TEAR.get()).getMode((ItemStack)is).m_7912_(), Map.of(VoidTearItem.Mode.FULL_INVENTORY.m_7912_(), Box.createVertical(Box.Alignment.RIGHT, new TextPane(LanguageHelper.getLocalization(VOID_TEAR_MODE_TRANSLATION + VoidTearItem.Mode.FULL_INVENTORY.m_7912_().toLowerCase(), new Object[0])), contentsPane), VoidTearItem.Mode.NO_REFILL.m_7912_(), Box.createVertical(Box.Alignment.RIGHT, new TextPane(LanguageHelper.getLocalization(VOID_TEAR_MODE_TRANSLATION + VoidTearItem.Mode.NO_REFILL.m_7912_().toLowerCase(), new Object[0])), contentsPane), VoidTearItem.Mode.ONE_STACK.m_7912_(), Box.createVertical(Box.Alignment.RIGHT, new TextPane(LanguageHelper.getLocalization(VOID_TEAR_MODE_TRANSLATION + VoidTearItem.Mode.ONE_STACK.m_7912_().toLowerCase(), new Object[0])), contentsPane))){

            @Override
            public boolean shouldRender() {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                return player != null && !VoidTearItem.isEmpty(InventoryHelper.getCorrectItemFromEitherHand((Player)player, (Item)ModItems.VOID_TEAR.get()), true);
            }
        }, (Object)((HUDPosition)((Object)Settings.CLIENT.hudPositions.voidTear.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.HARVEST_ROD.get(), (HUDPosition)((Object)Settings.CLIENT.hudPositions.harvestRod.get()), is -> ((HarvestRodItem)ModItems.HARVEST_ROD.get()).getMode((ItemStack)is).m_7912_(), Map.of(HarvestRodItem.Mode.BONE_MEAL.m_7912_(), new ChargePane((Item)ModItems.HARVEST_ROD.get(), new ItemStack((ItemLike)Items.f_42499_), is -> ((HarvestRodItem)ModItems.HARVEST_ROD.get()).getBoneMealCount((ItemStack)is, true)), HarvestRodItem.Mode.HOE.m_7912_(), new ItemStackPane(Items.f_42424_), "dynamic", new DynamicChargePane((Item)ModItems.HARVEST_ROD.get(), is -> ((HarvestRodItem)ModItems.HARVEST_ROD.get()).getCurrentPlantable((ItemStack)is, true), is -> ((HarvestRodItem)ModItems.HARVEST_ROD.get()).getPlantableQuantity((ItemStack)is, ((HarvestRodItem)ModItems.HARVEST_ROD.get()).getCurrentPlantableSlot((ItemStack)is), true)))), (Object)((HUDPosition)((Object)Settings.CLIENT.hudPositions.harvestRod.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.SOJOURNER_STAFF.get(), (HUDPosition)((Object)Settings.CLIENT.hudPositions.sojournerStaff.get()), is -> "dynamic", Map.of("dynamic", new DynamicChargePane((Item)ModItems.SOJOURNER_STAFF.get(), ((SojournerStaffItem)ModItems.SOJOURNER_STAFF.get())::getCurrentTorch, ((SojournerStaffItem)ModItems.SOJOURNER_STAFF.get())::getTorchCount))), (Object)((HUDPosition)((Object)Settings.CLIENT.hudPositions.sojournerStaff.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new HeroMedallionPane(), (Object)((HUDPosition)((Object)Settings.CLIENT.hudPositions.heroMedallion.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)Box.createVertical(Box.Alignment.RIGHT, new HandgunPane(InteractionHand.OFF_HAND), new HandgunPane(InteractionHand.MAIN_HAND)), (Object)((HUDPosition)((Object)Settings.CLIENT.hudPositions.handgun.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new CharmPane(), (Object)((HUDPosition)((Object)Settings.CLIENT.hudPositions.mobCharm.get()))));
    }

    private static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.APOTHECARY_MORTAR_TILE_TYPE.get(), context1 -> new ApothecaryMortarRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.PEDESTAL_TILE_TYPE.get(), context -> new PedestalRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.PASSIVE_PEDESTAL_TILE_TYPE.get(), context -> new PassivePedestalRenderer());
        event.registerEntityRenderer((EntityType)ModEntities.LYSSA_HOOK.get(), LyssaHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BLAZE_SHOT.get(), ShotRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BUSTER_SHOT.get(), ShotRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.CONCUSSIVE_SHOT.get(), ShotRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ENDER_SHOT.get(), ShotRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.EXORCISM_SHOT.get(), ShotRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.NEUTRAL_SHOT.get(), ShotRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SEEKER_SHOT.get(), ShotRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SAND_SHOT.get(), ShotRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.STORM_SHOT.get(), ShotRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.TIPPED_ARROW.get(), XRTippedArrowRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.GLOWING_WATER.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.APHRODITE_POTION.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.FERTILE_POTION.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.HOLY_HAND_GRENADE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.KRAKEN_SLIME.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SPECIAL_SNOWBALL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ENDER_STAFF_PROJECTILE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.THROWN_POTION.get(), ThrownItemRenderer::new);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ClientEventHandler::registerLyssaRodItemProperties);
        event.enqueueWork(ClientEventHandler::registerInfernalTearItemProperties);
        event.enqueueWork(ClientEventHandler::registerVoidTearItemProperties);
        event.enqueueWork(ClientEventHandler::registerBulletAndMagazineItemProperties);
    }

    private static void registerBulletAndMagazineItemProperties() {
        ClientEventHandler.registerPropertyToItems(new ResourceLocation("reliquary", "potion"), (stack, world, livingEntity, seed) -> ClientEventHandler.isPotionAttached(stack) ? 1.0f : 0.0f, (Item)ModItems.BLAZE_BULLET.get(), (Item)ModItems.BUSTER_BULLET.get(), (Item)ModItems.CONCUSSIVE_BULLET.get(), (Item)ModItems.ENDER_BULLET.get(), (Item)ModItems.EXORCISM_BULLET.get(), (Item)ModItems.NEUTRAL_BULLET.get(), (Item)ModItems.SAND_BULLET.get(), (Item)ModItems.SEEKER_BULLET.get(), (Item)ModItems.STORM_BULLET.get(), (Item)ModItems.BLAZE_MAGAZINE.get(), (Item)ModItems.BUSTER_MAGAZINE.get(), (Item)ModItems.CONCUSSIVE_MAGAZINE.get(), (Item)ModItems.ENDER_MAGAZINE.get(), (Item)ModItems.EXORCISM_MAGAZINE.get(), (Item)ModItems.NEUTRAL_MAGAZINE.get(), (Item)ModItems.SAND_MAGAZINE.get(), (Item)ModItems.SEEKER_MAGAZINE.get(), (Item)ModItems.STORM_MAGAZINE.get());
    }

    private static void registerVoidTearItemProperties() {
        ItemProperties.register((Item)((Item)ModItems.VOID_TEAR.get()), (ResourceLocation)new ResourceLocation("empty"), (stack, level, entity, seed) -> VoidTearItem.isEmpty(stack, true) ? 1.0f : 0.0f);
    }

    private static void registerInfernalTearItemProperties() {
        ItemProperties.register((Item)((Item)ModItems.INFERNAL_TEAR.get()), (ResourceLocation)new ResourceLocation("empty"), (stack, level, entity, seed) -> InfernalTearItem.getStackFromTear(stack).m_41619_() ? 1.0f : 0.0f);
    }

    private static void registerLyssaRodItemProperties() {
        ItemProperties.register((Item)((Item)ModItems.ROD_OF_LYSSA.get()), (ResourceLocation)new ResourceLocation("cast"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            if (world == null) {
                return 0.0f;
            }
            int entityId = RodOfLyssaItem.getHookEntityId(stack);
            return (entity.m_21205_() == stack || entity.m_21206_() == stack) && entityId > 0 && world.m_6815_(entityId) != null ? 1.0f : 0.0f;
        });
    }

    private static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(FORTUNE_COIN_TOGGLE_KEYBIND);
    }

    private static void registerPropertyToItems(ResourceLocation registryName, ItemPropertyFunction propertyGetter, Item ... items) {
        for (Item item : items) {
            ItemProperties.register((Item)item, (ResourceLocation)registryName, (ItemPropertyFunction)propertyGetter);
        }
    }

    private static boolean isPotionAttached(ItemStack stack) {
        return !XRPotionHelper.getPotionEffectsFromStack(stack).isEmpty();
    }

    private static void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            PedestalClientRegistry.registerItemRenderer(FishingRodItem.class, PedestalFishHookRenderer::new);
            MinecraftForge.EVENT_BUS.addListener(FortuneCoinToggler::handleKeyInputEvent);
        });
    }
}

