/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities.shot;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import reliquary.entities.ConcussiveExplosion;
import reliquary.entities.shot.ShotEntityBase;
import reliquary.init.ModEntities;
import reliquary.reference.ClientReference;

public class ConcussiveShotEntity
extends ShotEntityBase {
    public ConcussiveShotEntity(EntityType<ConcussiveShotEntity> entityType, Level world) {
        super(entityType, world);
    }

    public ConcussiveShotEntity(Level world, Player player, InteractionHand hand) {
        super((EntityType)ModEntities.CONCUSSIVE_SHOT.get(), world, player, hand);
    }

    @Override
    int getRicochetMax() {
        return 0;
    }

    @Override
    int getDamageOfShot(LivingEntity mop) {
        return 8 + this.d6();
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.f_123762_);
        }
    }

    @Override
    void spawnHitParticles(int i) {
    }

    @Override
    void doFiringEffects() {
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123770_, this.m_20185_() + this.smallGauss(0.1), this.m_20186_() + this.smallGauss(0.1), this.m_20189_() + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.f_123744_);
    }

    @Override
    protected void onImpact(LivingEntity entityLiving) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.getShooterPlayer().ifPresent(player -> ConcussiveExplosion.customConcussiveExplosion((Entity)this, player, this.m_20182_(), 1.5f, true));
        super.onImpact(entityLiving);
    }

    @Override
    void doBurstEffect(Direction sideHit) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.getShooterPlayer().ifPresent(player -> ConcussiveExplosion.customConcussiveExplosion((Entity)this, player, this.m_20182_(), 1.5f, true));
        this.m_146870_();
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.CONCUSSIVE;
    }
}

