/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import reliquary.crafting.FragmentRecipeHelper;
import reliquary.init.ModItems;
import reliquary.items.MobCharmItem;

public class MobCharmRecipe
extends ShapedRecipe {
    private final ShapedRecipe compose;

    public MobCharmRecipe(ShapedRecipe compose) {
        super(compose.m_6423_(), compose.m_6076_(), compose.getRecipeWidth(), compose.getRecipeHeight(), compose.m_7527_(), compose.m_8043_());
        this.compose = compose;
    }

    public boolean m_5818_(CraftingContainer inv, Level worldIn) {
        return super.m_5818_(inv, worldIn) && FragmentRecipeHelper.hasOnlyOneFragmentType(inv);
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        ItemStack ret = super.m_5874_(inv);
        FragmentRecipeHelper.getRegistryName(inv).ifPresent(regName -> MobCharmItem.setEntityRegistryName(ret, regName));
        return ret;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModItems.MOB_CHARM_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<MobCharmRecipe> {
        public MobCharmRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new MobCharmRecipe((ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(recipeId, json));
        }

        @Nullable
        public MobCharmRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new MobCharmRecipe((ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(recipeId, buffer));
        }

        public void toNetwork(FriendlyByteBuf buffer, MobCharmRecipe recipe) {
            RecipeSerializer.f_44076_.m_6178_(buffer, (Recipe)recipe.compose);
        }
    }
}

