/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jade.provider;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import reliquary.blocks.ApothecaryCauldronBlock;
import reliquary.blocks.tile.ApothecaryCauldronBlockEntity;
import reliquary.compat.jade.provider.CachedBodyDataProvider;
import reliquary.compat.jade.provider.JadeHelper;
import reliquary.util.potions.XRPotionHelper;
import snownee.jade.addon.vanilla.VanillaPlugin;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IBorderStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.IProgressStyle;

public class DataProviderCauldron
extends CachedBodyDataProvider {
    @Override
    public List<List<IElement>> getWailaBodyToCache(IElementHelper helper, BlockAccessor accessor, IPluginConfig config) {
        ItemStack stack;
        BlockEntity blockEntity;
        ArrayList<List<IElement>> lines = new ArrayList<List<IElement>>();
        if (!(accessor.getBlock() instanceof ApothecaryCauldronBlock) || !((blockEntity = accessor.getBlockEntity()) instanceof ApothecaryCauldronBlockEntity)) {
            return List.of();
        }
        ApothecaryCauldronBlockEntity cauldron = (ApothecaryCauldronBlockEntity)blockEntity;
        if (cauldron.getEffects().isEmpty()) {
            return List.of();
        }
        ArrayList<IElement> ingredientHints = new ArrayList<IElement>();
        if (!cauldron.hasNetherwart()) {
            ingredientHints.add(helper.item(Items.f_42588_.m_7968_(), JadeHelper.ITEM_ICON_SCALE, JadeHelper.MISSING));
        } else {
            ingredientHints.add(helper.item(Items.f_42588_.m_7968_(), JadeHelper.ITEM_ICON_SCALE, JadeHelper.SATISFIED));
        }
        if (cauldron.hasDragonBreath()) {
            if (!cauldron.hasGunpowder()) {
                ingredientHints.add(helper.item(Items.f_42403_.m_7968_(), JadeHelper.ITEM_ICON_SCALE, JadeHelper.MISSING));
            } else {
                ingredientHints.add(helper.item(Items.f_42403_.m_7968_(), JadeHelper.ITEM_ICON_SCALE, JadeHelper.SATISFIED));
            }
            ingredientHints.add(helper.item(Items.f_42735_.m_7968_(), JadeHelper.ITEM_ICON_SCALE, JadeHelper.SATISFIED));
        }
        lines.add(ingredientHints);
        ArrayList<IElement> ingredients1 = new ArrayList<IElement>();
        if (cauldron.getRedstoneCount() > 0) {
            stack = new ItemStack((ItemLike)Items.f_42451_, cauldron.getRedstoneCount());
            ingredients1.add(helper.item(stack));
        }
        if (cauldron.getGlowstoneCount() > 0) {
            stack = new ItemStack((ItemLike)Items.f_42525_, cauldron.getGlowstoneCount());
            ingredients1.add(helper.item(stack));
        }
        lines.add(ingredients1);
        FluidStack fluidPlaceHolder = new FluidStack((Fluid)Fluids.f_76193_, 1000 * cauldron.getLiquidLevel() / 3);
        MutableComponent potionType = cauldron.hasDragonBreath() ? Component.m_237115_((String)"waila.reliquary.cauldron.lingering") : (cauldron.hasGunpowder() ? Component.m_237115_((String)"waila.reliquary.cauldron.splash") : Component.m_237115_((String)"waila.reliquary.cauldron.potion"));
        lines.add(DataProviderCauldron.createTank(helper, fluidPlaceHolder, 1000, (Component)potionType));
        ArrayList<Component> components = new ArrayList<Component>();
        XRPotionHelper.addPotionTooltip(cauldron.getEffects(), components);
        lines.add(components.stream().map(arg_0 -> ((IElementHelper)helper).text(arg_0)).toList());
        return lines;
    }

    public static List<IElement> createTank(IElementHelper helper, FluidStack fluidStack, int capacity, Component displayName) {
        MutableComponent text;
        if (displayName == FormattedText.f_130760_) {
            displayName = fluidStack.getDisplayName();
        }
        if (capacity <= 0) {
            return List.of();
        }
        if (fluidStack.isEmpty()) {
            text = Component.m_237115_((String)"jade.fluid.empty");
        } else {
            String amountText = VanillaPlugin.getDisplayHelper().humanReadableNumber((double)fluidStack.getAmount(), "B", true);
            text = Component.m_237110_((String)"jade.fluid", (Object[])new Object[]{displayName, amountText});
        }
        IProgressStyle progressStyle = helper.progressStyle();
        progressStyle.overlay(helper.fluid(fluidStack));
        IBorderStyle borderStyle = helper.borderStyle();
        IElement tank = helper.progress((float)fluidStack.getAmount() / (float)capacity, (Component)text, progressStyle, borderStyle);
        return List.of(tank);
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("reliquary", "cauldron");
    }
}

