/*
 * Decompiled with CFR 0.152.
 */
package reliquary.blocks.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItem;
import reliquary.api.IPedestalRedstoneItem;
import reliquary.api.IPedestalRedstoneItemWrapper;
import reliquary.blocks.PedestalBlock;
import reliquary.blocks.tile.PassivePedestalBlockEntity;
import reliquary.blocks.tile.PedestalFluidHandler;
import reliquary.init.ModBlocks;
import reliquary.items.util.FilteredItemStackHandler;
import reliquary.pedestal.PedestalRegistry;
import reliquary.util.InventoryHelper;
import reliquary.util.WorldHelper;
import reliquary.util.XRFakePlayerFactory;

public class PedestalBlockEntity
extends PassivePedestalBlockEntity
implements IPedestal {
    private boolean tickable = false;
    private int actionCooldown = 0;
    @Nullable
    private IPedestalActionItem actionItem = null;
    @Nullable
    private IPedestalRedstoneItem redstoneItem = null;
    @Nullable
    private IItemHandler itemHandler = null;
    private ItemStack fluidContainer = ItemStack.f_41583_;
    private boolean switchedOn = false;
    private final List<Long> onSwitches = new ArrayList<Long>();
    private boolean enabledInitialized = false;
    private boolean powered = false;
    private PedestalFluidHandler pedestalFluidHandler = null;
    private Object itemData = null;

    public PedestalBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.PEDESTAL_TILE_TYPE.get(), pos, state);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.switchedOn = tag.m_128471_("SwitchedOn");
        this.powered = tag.m_128471_("Powered");
        ListTag onLocations = tag.m_128437_("OnSwitches", 4);
        this.onSwitches.clear();
        for (Tag onLocation : onLocations) {
            this.onSwitches.add(((LongTag)onLocation).m_7046_());
        }
        this.updateSpecialItems();
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("SwitchedOn", this.switchedOn);
        compound.m_128379_("Powered", this.powered);
        ListTag onLocations = new ListTag();
        for (Long onSwitch : this.onSwitches) {
            onLocations.add((Object)LongTag.m_128882_((long)onSwitch));
        }
        compound.m_128365_("OnSwitches", (Tag)onLocations);
    }

    public void m_6596_() {
        IItemHandler iItemHandler = this.itemHandler;
        if (iItemHandler instanceof FilteredItemStackHandler) {
            FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)iItemHandler;
            filteredHandler.markDirty();
        }
        super.m_6596_();
    }

    public void onChunkUnloaded() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            PedestalRegistry.unregisterPosition(this.f_58857_.m_46472_().m_211136_(), this.f_58858_);
        }
        super.onChunkUnloaded();
    }

    public void onLoad() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            PedestalRegistry.registerPosition(this.f_58857_.m_46472_().m_211136_(), this.f_58858_);
        }
        super.onLoad();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.pedestalFluidHandler == null) {
                this.pedestalFluidHandler = new PedestalFluidHandler(this);
            }
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.pedestalFluidHandler));
        }
        return super.getCapability(cap, side);
    }

    private void executeOnActionItem(Consumer<IPedestalActionItem> execute) {
        if (this.actionItem == null) {
            return;
        }
        execute.accept(this.actionItem);
    }

    private void executeOnRedstoneItem(Consumer<IPedestalRedstoneItem> execute) {
        if (this.redstoneItem == null) {
            return;
        }
        execute.accept(this.redstoneItem);
    }

    private void updateSpecialItems() {
        this.resetSpecialItems();
        if (this.item.m_41619_()) {
            return;
        }
        this.item.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(ih -> {
            this.itemHandler = ih;
        });
        Item item = this.item.m_41720_();
        if (item instanceof IPedestalActionItem) {
            IPedestalActionItem pedestalActionItem = (IPedestalActionItem)item;
            this.tickable = true;
            this.actionItem = pedestalActionItem;
        } else {
            item = this.item.m_41720_();
            if (item instanceof IPedestalRedstoneItem) {
                IPedestalRedstoneItem pedestalRedstoneItem;
                this.redstoneItem = pedestalRedstoneItem = (IPedestalRedstoneItem)item;
            } else {
                PedestalRegistry.getItemWrapper(this.item).ifPresent(wrapper -> {
                    if (wrapper instanceof IPedestalActionItem) {
                        IPedestalActionItem pedestalActionItem = (IPedestalActionItem)((Object)wrapper);
                        this.tickable = true;
                        this.actionItem = pedestalActionItem;
                    }
                    if (wrapper instanceof IPedestalRedstoneItemWrapper) {
                        this.redstoneItem = (IPedestalRedstoneItem)((Object)wrapper);
                    }
                });
            }
        }
        this.item.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).ifPresent(fh -> {
            this.fluidContainer = this.item;
        });
        this.item.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(fh -> {
            this.fluidContainer = this.item;
        });
        this.actionCooldown = 0;
    }

    private void resetSpecialItems() {
        this.tickable = false;
        this.fluidContainer = ItemStack.f_41583_;
        this.actionItem = null;
        this.redstoneItem = null;
        this.itemHandler = null;
    }

    public void serverTick(Level level) {
        if (level.f_46443_) {
            return;
        }
        if (!this.enabledInitialized) {
            this.enabledInitialized = true;
            this.neighborUpdate(level);
        }
        if (this.tickable && this.isEnabled()) {
            if (this.actionCooldown > 0) {
                --this.actionCooldown;
            } else {
                this.executeOnActionItem(ai -> ai.update(this.item, level, this));
            }
        }
    }

    public void neighborUpdate(Level level) {
        if (this.powered != level.m_46753_(this.f_58858_)) {
            this.powered = level.m_46753_(this.f_58858_);
            if (this.powered) {
                this.switchOn(level, BlockPos.f_121853_);
            } else {
                this.switchOff(level, BlockPos.f_121853_);
            }
        }
        this.updateRedstone(level);
    }

    public void updateRedstone(Level level) {
        this.executeOnRedstoneItem(ri -> ri.updateRedstone(this.item, level, this));
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.m_58899_();
    }

    @Override
    public int addToConnectedInventory(Level level, ItemStack stack) {
        int finalNumberAdded;
        Direction side;
        LazyOptional<IItemHandler> inventory;
        int numberAdded = 0;
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; i < n && (numberAdded += (inventory = InventoryHelper.getInventoryAtPos(level, this.f_58858_.m_121955_((side = directionArray[i]).m_122436_()), side.m_122424_())).map(arg_0 -> PedestalBlockEntity.lambda$addToConnectedInventory$7(stack, finalNumberAdded = numberAdded, arg_0)).orElse(0).intValue()) < stack.m_41613_(); ++i) {
        }
        return numberAdded;
    }

    @Override
    public int fillConnectedTank(FluidStack fluidStack, IFluidHandler.FluidAction action) {
        List<IFluidHandler> adjacentTanks = this.getAdjacentTanks();
        int fluidFilled = 0;
        FluidStack copy = fluidStack.copy();
        for (IFluidHandler tank : adjacentTanks) {
            if (tank.fill(copy, IFluidHandler.FluidAction.SIMULATE) != copy.getAmount()) continue;
            if ((fluidFilled += tank.fill(copy, action)) >= fluidStack.getAmount()) break;
            copy.setAmount(fluidStack.getAmount() - fluidFilled);
        }
        return fluidFilled;
    }

    @Override
    public int fillConnectedTank(FluidStack fluidStack) {
        return this.fillConnectedTank(fluidStack, IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public void setActionCoolDown(int coolDownTicks) {
        this.actionCooldown = coolDownTicks;
    }

    @Override
    public Optional<FakePlayer> getFakePlayer() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return Optional.empty();
        }
        ServerLevel world = (ServerLevel)this.f_58857_;
        return Optional.of(XRFakePlayerFactory.get(world));
    }

    @Override
    public void destroyItem() {
        this.setItem(ItemStack.f_41583_);
    }

    @Override
    public void setItem(ItemStack stack) {
        if (this.f_58857_ == null) {
            return;
        }
        this.removeSpecialItems(this.f_58857_);
        this.item = stack;
        this.updateItemsAndBlock();
    }

    @Override
    public List<BlockPos> getPedestalsInRange(Level level, int range) {
        return PedestalRegistry.getPositionsInRange(level.m_46472_().m_211136_(), this.f_58858_, range);
    }

    @Override
    public void switchOn(Level level, BlockPos switchedOnFrom) {
        if (switchedOnFrom != BlockPos.f_121853_ && !this.onSwitches.contains(switchedOnFrom.m_121878_())) {
            this.onSwitches.add(switchedOnFrom.m_121878_());
        }
        this.setEnabled(level, true);
        BlockState blockState = level.m_8055_(this.f_58858_);
        level.m_7260_(this.f_58858_, blockState, blockState, 3);
    }

    @Override
    public void switchOff(Level level, BlockPos switchedOffFrom) {
        if (switchedOffFrom != BlockPos.f_121853_) {
            this.onSwitches.remove(switchedOffFrom.m_121878_());
        }
        if (!this.switchedOn && !this.powered && this.onSwitches.isEmpty()) {
            this.setEnabled(level, false);
        }
        BlockState blockState = level.m_8055_(this.f_58858_);
        level.m_7260_(this.f_58858_, blockState, blockState, 3);
    }

    @Override
    public Optional<Object> getItemData() {
        return Optional.ofNullable(this.itemData);
    }

    @Override
    public void setItemData(@Nullable Object data) {
        this.itemData = data;
    }

    @Override
    public boolean switchedOn() {
        return this.switchedOn;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public List<Long> getOnSwitches() {
        return this.onSwitches;
    }

    private void setEnabled(Level level, boolean switchedOn) {
        if (level.m_8055_(this.f_58858_).m_60734_() instanceof PedestalBlock) {
            level.m_46597_(this.f_58858_, (BlockState)level.m_8055_(this.f_58858_).m_61124_((Property)PedestalBlock.ENABLED, (Comparable)Boolean.valueOf(switchedOn)));
            if (!switchedOn) {
                this.executeOnActionItem(ai -> ai.stop(this.item, level, this));
            }
        }
        this.m_6596_();
    }

    private List<IFluidHandler> getAdjacentTanks() {
        ArrayList<IFluidHandler> adjacentTanks = new ArrayList<IFluidHandler>();
        for (Direction side : Direction.values()) {
            BlockPos tankPos = this.m_58899_().m_121955_(side.m_122436_());
            Direction tankDirection = side.m_122424_();
            this.addIfTank(adjacentTanks, tankPos, tankDirection);
        }
        return adjacentTanks;
    }

    private void addIfTank(List<IFluidHandler> adjacentTanks, BlockPos tankPos, Direction tankDirection) {
        WorldHelper.getBlockEntity((BlockGetter)this.f_58857_, tankPos).ifPresent(te -> te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, tankDirection).ifPresent(adjacentTanks::add));
    }

    public void removeSpecialItems(Level level) {
        this.executeOnRedstoneItem(ri -> ri.onRemoved(this.item, level, this));
        this.executeOnActionItem(ai -> ai.onRemoved(this.item, level, this));
    }

    @Override
    public void removeAndSpawnItem(Level level) {
        this.removeSpecialItems(level);
        this.resetSpecialItems();
        super.removeAndSpawnItem(level);
    }

    @Override
    public int m_6643_() {
        return this.applyToItemHandler(IItemHandler::getSlots).orElse(0) + 1;
    }

    private <T> Optional<T> applyToItemHandler(Function<IItemHandler, T> function) {
        return this.itemHandler != null ? Optional.of(function.apply(this.itemHandler)) : Optional.empty();
    }

    private void runOnItemHandler(Consumer<IItemHandler> consumer) {
        if (this.itemHandler != null) {
            consumer.accept(this.itemHandler);
        }
    }

    @Override
    public ItemStack m_8020_(int slot) {
        if (slot == 0) {
            return this.item;
        }
        return this.applyToItemHandler(ih -> ih.getStackInSlot(this.getInternalItemHandlerSlot(slot))).orElse(ItemStack.f_41583_);
    }

    private int getInternalItemHandlerSlot(int slot) {
        return slot - 1;
    }

    @Override
    public ItemStack m_7407_(int slot, int count) {
        if (slot == 0) {
            return this.decrStack(count);
        }
        return this.applyToItemHandler(ih -> ih.extractItem(this.getInternalItemHandlerSlot(slot), count, false)).orElse(ItemStack.f_41583_);
    }

    private ItemStack decrStack(int count) {
        if (!this.item.m_41619_()) {
            ItemStack stack;
            if (this.item.m_41613_() > count) {
                stack = this.item.m_41620_(count);
            } else {
                stack = this.item;
                if (this.f_58857_ != null) {
                    this.removeSpecialItems(this.f_58857_);
                }
                this.item = ItemStack.f_41583_;
                this.updateItemsAndBlock();
            }
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private void updateItemsAndBlock() {
        this.updateSpecialItems();
        if (this.f_58857_ == null) {
            return;
        }
        this.updateRedstone(this.f_58857_);
        BlockState blockState = this.f_58857_.m_8055_(this.m_58899_());
        this.f_58857_.m_7260_(this.m_58899_(), blockState, blockState, 3);
    }

    @Override
    public ItemStack m_8016_(int slot) {
        if (slot == 0) {
            ItemStack stack = this.item;
            if (this.f_58857_ != null) {
                this.removeSpecialItems(this.f_58857_);
            }
            this.item = ItemStack.f_41583_;
            this.updateItemsAndBlock();
            return stack;
        }
        return this.applyToItemHandler(ih -> {
            int s = this.getInternalItemHandlerSlot(slot);
            ItemStack stack = ih.getStackInSlot(s);
            return ih.extractItem(s, stack.m_41613_(), false);
        }).orElse(ItemStack.f_41583_);
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        if (slot == 0) {
            this.setItem(stack);
            return;
        }
        this.runOnItemHandler(ih -> this.setItemHandlerSlotContents(slot, stack, (IItemHandler)ih));
    }

    private void setItemHandlerSlotContents(int slot, ItemStack stack, IItemHandler ih) {
        int adjustedSlot = this.getInternalItemHandlerSlot(slot);
        ItemStack stackInSlot = ih.getStackInSlot(adjustedSlot);
        if (!(stackInSlot.m_41619_() || stack.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot))) {
            return;
        }
        if (!stackInSlot.m_41619_() && (stack.m_41619_() || stack.m_41613_() < stackInSlot.m_41613_())) {
            int amount = stackInSlot.m_41613_() - (stack.m_41619_() ? 0 : stack.m_41613_());
            ih.extractItem(adjustedSlot, amount, false);
        } else if (!stack.m_41619_() && (stackInSlot.m_41619_() || stack.m_41613_() > stackInSlot.m_41613_())) {
            stack.m_41774_(stackInSlot.m_41619_() ? 0 : stackInSlot.m_41613_());
            ih.insertItem(adjustedSlot, stack, false);
        }
    }

    @Override
    public boolean m_7013_(int index, ItemStack stack) {
        if (super.m_7013_(index, stack)) {
            return true;
        }
        return this.applyToItemHandler(ih -> {
            ItemStack returnedStack = ih.insertItem(this.getInternalItemHandlerSlot(index), stack, true);
            return returnedStack.m_41619_() || returnedStack.m_41613_() != stack.m_41613_();
        }).orElse(false);
    }

    public void toggleSwitch(Level level) {
        boolean bl = this.switchedOn = !this.switchedOn;
        if (this.switchedOn) {
            this.switchOn(level, BlockPos.f_121853_);
        } else {
            this.switchOff(level, BlockPos.f_121853_);
        }
        this.updateRedstone(level);
    }

    ItemStack getFluidContainer() {
        return this.fluidContainer;
    }

    public boolean isEnabled() {
        return (Boolean)this.m_58900_().m_61143_((Property)PedestalBlock.ENABLED);
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        AABB aabb = new AABB(pos.m_7918_(-1, 0, -1), pos.m_7918_(1, 1, 1));
        this.executeOnActionItem(ai -> ai.getRenderBoundingBoxOuterPosition().ifPresent(arg_0 -> ((AABB)aabb).m_82369_(arg_0)));
        return aabb;
    }

    private static /* synthetic */ Integer lambda$addToConnectedInventory$7(ItemStack stack, int finalNumberAdded, IItemHandler handler) {
        return InventoryHelper.tryToAddToInventory(stack, handler, stack.m_41613_() - finalNumberAdded);
    }
}

