/*
 * Decompiled with CFR 0.152.
 */
package reliquary.blocks.tile;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import reliquary.blocks.ApothecaryCauldronBlock;
import reliquary.blocks.tile.BlockEntityBase;
import reliquary.client.particle.BubbleColorParticleData;
import reliquary.client.particle.SteamColorParticleData;
import reliquary.compat.jade.provider.IJadeDataChangeIndicator;
import reliquary.init.ModBlocks;
import reliquary.init.ModItems;
import reliquary.items.PotionEssenceItem;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;
import reliquary.util.potions.XRPotionHelper;

public class ApothecaryCauldronBlockEntity
extends BlockEntityBase
implements IJadeDataChangeIndicator {
    private int redstoneCount = 0;
    private List<MobEffectInstance> effects = Lists.newArrayList();
    private int glowstoneCount = 0;
    private boolean hasGunpowder = false;
    private boolean hasNetherwart = false;
    private boolean hasDragonBreath = false;
    private int cookTime = 0;
    private int liquidLevel = 0;
    private boolean dataChanged = true;

    public ApothecaryCauldronBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.APOTHECARY_CAULDRON_TILE_TYPE.get(), pos, state);
    }

    public void serverTick(Level level, BlockPos pos) {
        if (this.getHeatSources().contains(level.m_8055_(pos.m_7918_(0, -1, 0)).m_60734_()) && this.getLiquidLevel() > 0) {
            if (!this.effects.isEmpty() && this.hasNetherwart && this.cookTime < this.getTotalCookTime()) {
                ++this.cookTime;
            }
            if (level.f_46443_) {
                this.spawnParticles(level, pos);
            }
        }
    }

    private void spawnParticles(Level level, BlockPos pos) {
        for (int particleCount = 0; particleCount <= 2; ++particleCount) {
            this.spawnBoilingParticles(level, pos);
        }
        if (this.hasDragonBreath) {
            this.spawnDragonBreathParticles(level, pos);
        } else if (this.hasGunpowder) {
            this.spawnGunpowderParticles(level, pos);
        }
        if (this.glowstoneCount > 0) {
            this.spawnGlowstoneParticles(level, pos);
        }
        if (this.hasNetherwart) {
            this.spawnNetherwartParticles(level, pos);
            if (this.finishedCooking()) {
                this.spawnFinishedParticles(level, pos);
            }
        }
        if (this.redstoneCount > 0) {
            this.spawnRedstoneParticles(level, pos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnBoilingParticles(Level level, BlockPos pos) {
        if (level.f_46441_.m_188503_(this.getTotalCookTime() * this.getTotalCookTime()) > this.cookTime * this.cookTime) {
            return;
        }
        float xOffset = (level.f_46441_.m_188501_() - 0.5f) / 1.33f;
        float zOffset = (level.f_46441_.m_188501_() - 0.5f) / 1.33f;
        int color = PotionUtils.m_43564_(this.effects);
        float red = (float)(color >> 16 & 0xFF) / 256.0f;
        float green = (float)(color >> 8 & 0xFF) / 256.0f;
        float blue = (float)(color & 0xFF) / 256.0f;
        level.m_7106_((ParticleOptions)new BubbleColorParticleData(red, green, blue), (double)pos.m_123341_() + 0.5 + (double)xOffset, (double)pos.m_123342_() + 0.01 + (double)this.getRenderLiquidLevel(), (double)pos.m_123343_() + 0.5 + (double)zOffset, 0.0, 0.0, 0.0);
        if (level.f_46441_.m_188503_(6) == 0) {
            level.m_7106_((ParticleOptions)new SteamColorParticleData(red, green, blue), (double)pos.m_123341_() + 0.5 + (double)xOffset, (double)pos.m_123342_() + 0.01 + (double)this.getRenderLiquidLevel(), (double)pos.m_123343_() + 0.5 + (double)zOffset, 0.0, 0.05 + (double)(0.02f * this.getRenderLiquidLevel()), 0.0);
        }
    }

    private float getRenderLiquidLevel() {
        int j = Mth.m_14045_((int)this.getLiquidLevel(), (int)0, (int)3);
        return (float)(6 + 3 * j) / 16.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnGunpowderParticles(Level level, BlockPos pos) {
        if (level.f_46441_.m_188503_(8) > 0) {
            return;
        }
        float xOffset = (level.f_46441_.m_188501_() - 0.5f) / 1.66f;
        float zOffset = (level.f_46441_.m_188501_() - 0.5f) / 1.66f;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5 + (double)xOffset, (double)((float)pos.m_123342_() + this.getRenderLiquidLevel()), (double)pos.m_123343_() + 0.5 + (double)zOffset, 0.0, 0.1, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnDragonBreathParticles(Level level, BlockPos pos) {
        if (level.f_46441_.m_188503_(8) > 0) {
            return;
        }
        float xOffset = (level.f_46441_.m_188501_() - 0.5f) / 1.66f;
        float zOffset = (level.f_46441_.m_188501_() - 0.5f) / 1.66f;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123799_, (double)pos.m_123341_() + 0.5 + (double)xOffset, (double)((float)pos.m_123342_() + this.getRenderLiquidLevel()), (double)pos.m_123343_() + 0.5 + (double)zOffset, 0.0, 0.1, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnGlowstoneParticles(Level level, BlockPos pos) {
        if (level.f_46441_.m_188503_(8) > 0) {
            return;
        }
        double gauss = 0.5 + (double)(level.f_46441_.m_188501_() / 2.0f);
        float xOffset = (level.f_46441_.m_188501_() - 0.5f) / 1.66f;
        float zOffset = (level.f_46441_.m_188501_() - 0.5f) / 1.66f;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)pos.m_123341_() + 0.5 + (double)xOffset, (double)((float)pos.m_123342_() + this.getRenderLiquidLevel()), (double)pos.m_123343_() + 0.5 + (double)zOffset, gauss, gauss, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnNetherwartParticles(Level level, BlockPos pos) {
        if (level.f_46441_.m_188503_(8) > 0) {
            return;
        }
        double gauss = 0.5 + (double)(level.f_46441_.m_188501_() / 2.0f);
        float xOffset = (level.f_46441_.m_188501_() - 0.5f) / 1.66f;
        float zOffset = (level.f_46441_.m_188501_() - 0.5f) / 1.66f;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)pos.m_123341_() + 0.5 + (double)xOffset, (double)((float)pos.m_123342_() + this.getRenderLiquidLevel()), (double)pos.m_123343_() + 0.5 + (double)zOffset, gauss, 0.0, gauss);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnRedstoneParticles(Level level, BlockPos pos) {
        if (level.f_46441_.m_188503_(10) / this.redstoneCount > 0) {
            return;
        }
        float xOffset = (level.f_46441_.m_188501_() - 0.5f) / 1.66f;
        float zOffset = (level.f_46441_.m_188501_() - 0.5f) / 1.66f;
        level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + 0.5 + (double)xOffset, (double)((float)pos.m_123342_() + this.getRenderLiquidLevel()), (double)pos.m_123343_() + 0.5 + (double)zOffset, 1.0, 0.0, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnFinishedParticles(Level level, BlockPos pos) {
        if (level.f_46441_.m_188503_(8) > 0) {
            return;
        }
        float xOffset = (level.f_46441_.m_188501_() - 0.5f) / 1.66f;
        float zOffset = (level.f_46441_.m_188501_() - 0.5f) / 1.66f;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123771_, (double)pos.m_123341_() + 0.5 + (double)xOffset, (double)((float)pos.m_123342_() + this.getRenderLiquidLevel()), (double)pos.m_123343_() + 0.5 + (double)zOffset, 0.0, 0.0, 0.0);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setLiquidLevel(tag.m_128448_("liquidLevel"));
        this.glowstoneCount = tag.m_128451_("glowstoneCount");
        this.hasNetherwart = tag.m_128471_("hasNetherwart");
        this.hasGunpowder = tag.m_128471_("hasGunpowder");
        this.hasDragonBreath = tag.m_128471_("hasDragonBreath");
        this.redstoneCount = tag.m_128451_("redstoneCount");
        this.cookTime = tag.m_128451_("cookTime");
        this.effects = XRPotionHelper.getPotionEffectsFromCompoundTag(tag);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("liquidLevel", this.getLiquidLevel());
        compound.m_128405_("cookTime", this.cookTime);
        compound.m_128405_("redstoneCount", this.redstoneCount);
        compound.m_128405_("glowstoneCount", this.glowstoneCount);
        compound.m_128379_("hasGunpowder", this.hasGunpowder);
        compound.m_128379_("hasDragonBreath", this.hasDragonBreath);
        compound.m_128379_("hasNetherwart", this.hasNetherwart);
        XRPotionHelper.addPotionEffectsToCompoundTag(compound, this.effects);
    }

    private boolean finishedCooking() {
        return this.hasNetherwart && !this.effects.isEmpty() && this.cookTime >= this.getTotalCookTime() && (!this.hasDragonBreath || this.hasGunpowder);
    }

    private ItemStack removeContainedPotion(Level level, BlockPos pos) {
        ItemStack potion = this.hasDragonBreath ? new ItemStack((ItemLike)ModItems.LINGERING_POTION.get()) : (this.hasGunpowder ? new ItemStack((ItemLike)ModItems.SPLASH_POTION.get()) : new ItemStack((ItemLike)ModItems.POTION.get()));
        XRPotionHelper.addPotionEffectsToStack(potion, XRPotionHelper.augmentPotionEffects(this.effects, this.redstoneCount, this.glowstoneCount));
        this.setLiquidLevel(this.getLiquidLevel() - 1);
        if (this.getLiquidLevel() <= 0) {
            this.clearAllFields(level, pos);
        }
        return potion;
    }

    private void clearAllFields(Level level, BlockPos pos) {
        this.cookTime = 0;
        this.glowstoneCount = 0;
        this.hasGunpowder = false;
        this.hasNetherwart = false;
        this.redstoneCount = 0;
        this.effects.clear();
        this.dataChanged = true;
        this.hasDragonBreath = false;
        level.m_7260_(pos, this.m_58900_(), this.m_58900_(), 3);
    }

    private boolean isItemValidForInput(ItemStack stack) {
        if (stack.m_41720_() instanceof PotionEssenceItem && this.effects.isEmpty()) {
            return true;
        }
        if (this.effects.isEmpty()) {
            return false;
        }
        if (stack.m_41720_() == Items.f_42403_ && !this.hasGunpowder) {
            return true;
        }
        if (stack.m_41720_() == Items.f_42525_ && this.glowstoneCount < this.getGlowstoneAmpLimit()) {
            return true;
        }
        if (stack.m_41720_() == Items.f_42451_ && this.redstoneCount < this.getRedstoneAmpLimit()) {
            return true;
        }
        if (stack.m_41720_() == Items.f_42588_ && !this.hasNetherwart) {
            return true;
        }
        return stack.m_41720_() == Items.f_42735_ && !this.hasDragonBreath;
    }

    private void addItem(ItemStack stack, Level level, BlockPos pos) {
        if (stack.m_41720_() instanceof PotionEssenceItem) {
            this.effects = XRPotionHelper.getPotionEffectsFromStack(stack);
        } else if (stack.m_41720_() == Items.f_42403_) {
            this.hasGunpowder = true;
        } else if (stack.m_41720_() == Items.f_42525_) {
            ++this.glowstoneCount;
        } else if (stack.m_41720_() == Items.f_42451_) {
            ++this.redstoneCount;
        } else if (stack.m_41720_() == Items.f_42588_) {
            this.hasNetherwart = true;
        } else if (stack.m_41720_() == Items.f_42735_) {
            this.hasDragonBreath = true;
        }
        level.m_7260_(pos, this.m_58900_(), this.m_58900_(), 3);
    }

    private int getGlowstoneAmpLimit() {
        return (Integer)Settings.COMMON.blocks.apothecaryCauldron.glowstoneLimit.get();
    }

    private int getRedstoneAmpLimit() {
        return (Integer)Settings.COMMON.blocks.apothecaryCauldron.redstoneLimit.get();
    }

    private Set<Block> getHeatSources() {
        HashSet<Block> heatSources = new HashSet<Block>();
        List heatSourceBlockNames = (List)Settings.COMMON.blocks.apothecaryCauldron.heatSources.get();
        heatSourceBlockNames.forEach(blockName -> heatSources.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName))));
        heatSources.add(Blocks.f_49991_);
        heatSources.add(Blocks.f_50083_);
        return heatSources;
    }

    private int getTotalCookTime() {
        return (Integer)Settings.COMMON.blocks.apothecaryCauldron.cookTime.get();
    }

    public List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    public boolean hasNetherwart() {
        return this.hasNetherwart;
    }

    public boolean hasGunpowder() {
        return this.hasGunpowder;
    }

    public boolean hasDragonBreath() {
        return this.hasDragonBreath;
    }

    public int getRedstoneCount() {
        return this.redstoneCount;
    }

    public int getGlowstoneCount() {
        return this.glowstoneCount;
    }

    public void handleCollidingEntity(Level level, BlockPos pos, Entity collidingEntity) {
        int l = this.getLiquidLevel();
        float f = (float)pos.m_123342_() + (6.0f + (float)(3 * l)) / 16.0f;
        if (collidingEntity.m_20191_().f_82289_ <= (double)f) {
            LivingEntity livingEntity;
            if (collidingEntity.m_6060_() && l > 0) {
                collidingEntity.m_20095_();
            }
            if (collidingEntity instanceof LivingEntity && !this.addEffectsToEntity(level, collidingEntity, livingEntity = (LivingEntity)collidingEntity)) {
                return;
            }
            if (collidingEntity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)collidingEntity;
                this.pickupItem(level, pos, itemEntity);
            }
        }
    }

    private void pickupItem(Level level, BlockPos pos, ItemEntity itemEntity) {
        ItemStack item = itemEntity.m_32055_();
        while (this.isItemValidForInput(item)) {
            this.addItem(item, level, pos);
            item.m_41774_(1);
        }
    }

    private boolean addEffectsToEntity(Level level, Entity collidingEntity, LivingEntity livingEntity) {
        if (this.effects.isEmpty()) {
            return false;
        }
        if (this.finishedCooking()) {
            for (MobEffectInstance effect : this.effects) {
                MobEffect potion = effect.m_19544_();
                if (potion.m_8093_() && level.m_46467_() % 20L != 0L) continue;
                MobEffectInstance reducedEffect = new MobEffectInstance(effect.m_19544_(), potion.m_8093_() ? 1 : effect.m_19557_() / 20, Math.max(0, effect.m_19564_() - 1));
                livingEntity.m_7292_(reducedEffect);
            }
        }
        if (this.cookTime > 0 && level.m_46467_() % 10L == 0L) {
            collidingEntity.m_6469_(DamageSource.f_19305_, 1.0f);
        }
        return true;
    }

    public int getColorMultiplier() {
        return PotionUtils.m_43564_(this.effects);
    }

    public int getLiquidLevel() {
        return this.liquidLevel;
    }

    public void fillWithRain() {
        if (this.getLiquidLevel() < 3 && !this.finishedCooking()) {
            this.setLiquidLevel(this.getLiquidLevel() + 1);
        }
    }

    public InteractionResult handleBlockActivation(Level level, Player player, InteractionHand hand, BlockPos pos) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41619_()) {
            return InteractionResult.CONSUME;
        }
        if (this.getLiquidLevel() < 3 && !this.finishedCooking()) {
            return this.fillWithWater(player, hand, itemStack);
        }
        if (itemStack.m_41720_() == ModItems.EMPTY_POTION_VIAL.get() && this.finishedCooking() && this.getLiquidLevel() > 0) {
            if (this.fillVial(level, player, hand, itemStack, pos)) {
                return InteractionResult.SUCCESS;
            }
        } else if (this.getLiquidLevel() == 3 && this.isItemValidForInput(itemStack)) {
            return this.addIngredient(level, player, itemStack, pos);
        }
        return InteractionResult.CONSUME;
    }

    private InteractionResult addIngredient(Level level, Player player, ItemStack itemStack, BlockPos pos) {
        this.addItem(itemStack, level, pos);
        if (itemStack.m_41720_() == Items.f_42735_ && InventoryHelper.getItemHandlerFrom(player).map(handler -> InventoryHelper.tryToAddToInventory(new ItemStack((ItemLike)Items.f_42590_), handler, 1)).orElse(0) != 1) {
            Containers.m_18992_((Level)level, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 1.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), (ItemStack)new ItemStack((ItemLike)Items.f_42590_));
        }
        itemStack.m_41774_(1);
        return InteractionResult.SUCCESS;
    }

    private boolean fillVial(Level level, Player player, InteractionHand hand, ItemStack itemStack, BlockPos pos) {
        if (this.finishedCooking() && this.hasNetherwart && !this.effects.isEmpty() && this.getLiquidLevel() > 0) {
            ItemStack potion = this.removeContainedPotion(level, pos);
            itemStack.m_41774_(1);
            if (itemStack.m_41613_() <= 0) {
                player.m_21008_(hand, potion);
            } else if (!player.m_150109_().m_36054_(potion)) {
                level.m_7967_((Entity)new ItemEntity(level, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, potion));
            }
            return true;
        }
        return false;
    }

    private InteractionResult fillWithWater(Player player, InteractionHand hand, ItemStack itemStack) {
        if (itemStack.m_41720_() == Items.f_42447_) {
            if (!player.m_7500_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
            }
        } else if (Boolean.FALSE.equals(itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).map(fh -> this.drainWater(player, (IFluidHandlerItem)fh)).orElse(false))) {
            return InteractionResult.CONSUME;
        }
        this.setLiquidLevel(3);
        this.cookTime = 0;
        return InteractionResult.SUCCESS;
    }

    private Boolean drainWater(Player player, IFluidHandlerItem fh) {
        FluidStack waterStack = new FluidStack((Fluid)Fluids.f_76193_, 1000);
        if (!waterStack.equals((Object)fh.drain(waterStack, IFluidHandler.FluidAction.SIMULATE))) {
            return false;
        }
        if (!player.m_7500_()) {
            fh.drain(waterStack, IFluidHandler.FluidAction.EXECUTE);
        }
        return true;
    }

    private void setLiquidLevel(int liquidLevel) {
        this.liquidLevel = liquidLevel;
        if (this.f_58857_ != null) {
            BlockState blockState = this.m_58900_();
            blockState = (BlockState)blockState.m_61124_((Property)ApothecaryCauldronBlock.LEVEL, (Comparable)Integer.valueOf(liquidLevel));
            this.f_58857_.m_46597_(this.m_58899_(), blockState);
            this.f_58857_.m_46717_(this.f_58858_, (Block)ModBlocks.APOTHECARY_CAULDRON.get());
        }
    }

    @Override
    public boolean getDataChanged() {
        boolean ret = this.dataChanged;
        this.dataChanged = false;
        return ret;
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        this.dataChanged = true;
    }
}

