/*
 * Decompiled with CFR 0.152.
 */
package reliquary.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import reliquary.entities.shot.ShotEntityBase;
import reliquary.reference.Settings;

public class InterdictionTorchBlock
extends TorchBlock {
    protected static final int TICK_RATE = 1;

    public InterdictionTorchBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.0f).m_60953_(value -> 15).m_60977_().m_60918_(SoundType.f_56736_).m_60910_(), (ParticleOptions)ParticleTypes.f_123744_);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        world.m_186460_(pos, (Block)this, 1);
        super.m_6807_(state, world, pos, oldState, isMoving);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        world.m_186460_(pos, (Block)this, 1);
        if (world.f_46443_) {
            return;
        }
        int radius = (Integer)Settings.COMMON.blocks.interdictionTorch.pushRadius.get();
        List entities = world.m_6443_(Entity.class, new AABB(pos).m_82400_((double)radius), e -> e instanceof Mob || e instanceof Projectile);
        for (Entity entity : entities) {
            double distance;
            if (entity instanceof Player || entity instanceof ShotEntityBase || entity instanceof FishingHook || this.isBlacklistedEntity(entity) || !((distance = Math.sqrt(entity.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))) < (double)radius) || distance == 0.0) continue;
            this.moveEntity(pos, entity, distance);
        }
    }

    private void moveEntity(BlockPos pos, Entity entity, double distance) {
        if (distance < 1.0) {
            distance = 1.0;
        }
        double knockbackMultiplier = 1.0 + 1.0 / distance;
        double reductionCoefficient = 0.04;
        Vec3 angleOfAttack = entity.m_20182_().m_82520_(-((double)pos.m_123341_() + 0.5), (double)(-pos.m_123342_()), -((double)pos.m_123343_() + 0.5));
        double xForce = angleOfAttack.f_82479_ * knockbackMultiplier * reductionCoefficient;
        double yForce = angleOfAttack.f_82480_ * knockbackMultiplier * reductionCoefficient;
        double zForce = angleOfAttack.f_82481_ * knockbackMultiplier * reductionCoefficient;
        entity.m_20256_(entity.m_20184_().m_82520_(xForce, yForce, zForce));
    }

    private boolean isBlacklistedEntity(Entity entity) {
        if (ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()) == null) {
            return false;
        }
        String entityName = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString();
        return this.isBlacklistedLivingEntity(entity, entityName) || (Boolean)Settings.COMMON.blocks.interdictionTorch.canPushProjectiles.get() != false && this.isBlacklistedProjectile(entity, entityName);
    }

    private boolean isBlacklistedProjectile(Entity entity, String entityName) {
        return entity instanceof Projectile && ((List)Settings.COMMON.blocks.interdictionTorch.pushableProjectilesBlacklist.get()).contains(entityName);
    }

    private boolean isBlacklistedLivingEntity(Entity entity, String entityName) {
        return entity instanceof Mob && ((List)Settings.COMMON.blocks.interdictionTorch.pushableEntitiesBlacklist.get()).contains(entityName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        double xOffset = (float)pos.m_123341_() + 0.5f;
        double yOffset = (float)pos.m_123342_() + 0.7f;
        double zOffset = (float)pos.m_123343_() + 0.5f;
        world.m_7106_((ParticleOptions)ParticleTypes.f_123811_, xOffset, yOffset, zOffset, 0.0, 0.0, 0.0);
        world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, xOffset, yOffset, zOffset, 0.0, 0.0, 0.0);
    }
}

