/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.util;

import com.mojang.authlib.GameProfile;
import com.refinedmods.refinedstorage.render.Styles;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public final class LevelUtils {
    private LevelUtils() {
    }

    public static void updateBlock(@Nullable Level level, BlockPos pos) {
        if (level != null && level.m_46749_(pos)) {
            BlockState state = level.m_8055_(pos);
            level.m_7260_(pos, state, state, 3);
        }
    }

    public static IItemHandler getItemHandler(@Nullable BlockEntity blockEntity, Direction side) {
        if (blockEntity == null) {
            return null;
        }
        IItemHandler handler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side).orElse(null);
        if (handler == null) {
            if (side != null && blockEntity instanceof WorldlyContainer) {
                handler = new SidedInvWrapper((WorldlyContainer)blockEntity, side);
            } else if (blockEntity instanceof Container) {
                handler = new InvWrapper((Container)blockEntity);
            }
        }
        return handler;
    }

    public static IFluidHandler getFluidHandler(@Nullable BlockEntity blockEntity, Direction side) {
        if (blockEntity != null) {
            return (IFluidHandler)blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, side).orElse(null);
        }
        return null;
    }

    public static FakePlayer getFakePlayer(ServerLevel level, @Nullable UUID owner) {
        GameProfileCache profileCache;
        Optional profile;
        if (owner != null && (profile = (profileCache = level.m_7654_().m_129927_()).m_11002_(owner)).isPresent()) {
            return FakePlayerFactory.get((ServerLevel)level, (GameProfile)((GameProfile)profile.get()));
        }
        return FakePlayerFactory.getMinecraft((ServerLevel)level);
    }

    public static void sendNoPermissionMessage(Player player) {
        player.m_213846_((Component)Component.m_237115_((String)"misc.refinedstorage.security.no_permission").m_6270_(Styles.RED));
    }

    public static HitResult rayTracePlayer(Level level, Player player) {
        double reachDistance = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        Vec3 base = player.m_20299_(1.0f);
        Vec3 look = player.m_20154_();
        Vec3 target = base.m_82520_(look.f_82479_ * reachDistance, look.f_82480_ * reachDistance, look.f_82481_ * reachDistance);
        return level.m_45547_(new ClipContext(base, target, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
    }
}

