/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.item;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemProvider;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.item.EnergyItem;
import com.refinedmods.refinedstorage.render.Styles;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public abstract class NetworkItem
extends EnergyItem
implements INetworkItemProvider {
    private static final String NBT_NODE_X = "NodeX";
    private static final String NBT_NODE_Y = "NodeY";
    private static final String NBT_NODE_Z = "NodeZ";
    private static final String NBT_DIMENSION = "Dimension";

    protected NetworkItem(Item.Properties item, boolean creative, Supplier<Integer> energyCapacity) {
        super(item, creative, energyCapacity);
    }

    @Nullable
    public static ResourceKey<Level> getDimension(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NBT_DIMENSION)) {
            ResourceLocation name = ResourceLocation.m_135820_((String)stack.m_41783_().m_128461_(NBT_DIMENSION));
            if (name == null) {
                return null;
            }
            return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)name);
        }
        return null;
    }

    public static int getX(ItemStack stack) {
        return stack.m_41783_().m_128451_(NBT_NODE_X);
    }

    public static int getY(ItemStack stack) {
        return stack.m_41783_().m_128451_(NBT_NODE_Y);
    }

    public static int getZ(ItemStack stack) {
        return stack.m_41783_().m_128451_(NBT_NODE_Z);
    }

    public static boolean isValid(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(NBT_NODE_X) && stack.m_41783_().m_128441_(NBT_NODE_Y) && stack.m_41783_().m_128441_(NBT_NODE_Z) && stack.m_41783_().m_128441_(NBT_DIMENSION);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            this.applyNetwork(level.m_7654_(), stack, n -> n.getNetworkItemManager().open(player, player.m_21120_(hand), PlayerSlot.getSlotForHand(player, hand)), arg_0 -> ((Player)player).m_213846_(arg_0));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void applyNetwork(MinecraftServer server, ItemStack stack, Consumer<INetwork> onNetwork, Consumer<Component> onError) {
        MutableComponent notFound = Component.m_237115_((String)"misc.refinedstorage.network_item.not_found");
        if (!NetworkItem.isValid(stack)) {
            onError.accept((Component)notFound);
            return;
        }
        ResourceKey<Level> dimension = NetworkItem.getDimension(stack);
        if (dimension == null) {
            onError.accept((Component)notFound);
            return;
        }
        ServerLevel nodeLevel = server.m_129880_(dimension);
        if (nodeLevel == null) {
            onError.accept((Component)notFound);
            return;
        }
        INetwork network = NetworkUtils.getNetworkFromNode(NetworkUtils.getNodeFromBlockEntity(nodeLevel.m_7702_(new BlockPos(NetworkItem.getX(stack), NetworkItem.getY(stack), NetworkItem.getZ(stack)))));
        if (network == null) {
            onError.accept((Component)notFound);
            return;
        }
        onNetwork.accept(network);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (NetworkItem.isValid(stack)) {
            tooltip.add((Component)Component.m_237110_((String)"misc.refinedstorage.network_item.tooltip", (Object[])new Object[]{NetworkItem.getX(stack), NetworkItem.getY(stack), NetworkItem.getZ(stack)}).m_6270_(Styles.GRAY));
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        return super.m_6880_(stack, playerIn, target, hand);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack stack = ctx.m_43723_().m_21120_(ctx.m_43724_());
        INetwork network = NetworkUtils.getNetworkFromNode(NetworkUtils.getNodeFromBlockEntity(ctx.m_43725_().m_7702_(ctx.m_8083_())));
        if (network != null) {
            CompoundTag tag = stack.m_41783_();
            if (tag == null) {
                tag = new CompoundTag();
            }
            tag.m_128405_(NBT_NODE_X, network.getPosition().m_123341_());
            tag.m_128405_(NBT_NODE_Y, network.getPosition().m_123342_());
            tag.m_128405_(NBT_NODE_Z, network.getPosition().m_123343_());
            tag.m_128359_(NBT_DIMENSION, ctx.m_43725_().m_46472_().m_135782_().toString());
            stack.m_41751_(tag);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

