/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.api.network.INetworkNodeVisitor;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.blockentity.NetworkReceiverBlockEntity;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.ItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.NetworkCardItem;
import com.refinedmods.refinedstorage.util.StackUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

public class NetworkTransmitterNetworkNode
extends NetworkNode {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "network_transmitter");
    private BlockPos receiver;
    private ResourceKey<Level> receiverDimension;
    private final BaseItemHandler networkCard = new BaseItemHandler(1).addValidator(new ItemValidator((Item)RSItems.NETWORK_CARD.get())).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
        ItemStack card = handler.getStackInSlot(slot);
        if (card.m_41619_()) {
            this.receiver = null;
            this.receiverDimension = null;
        } else {
            this.receiver = NetworkCardItem.getReceiver(card);
            this.receiverDimension = NetworkCardItem.getDimension(card);
        }
        if (this.network != null) {
            this.network.getNodeGraph().invalidate(Action.PERFORM, this.network.getLevel(), this.network.getPosition());
        }
    });

    public NetworkTransmitterNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.networkCard, 0, tag);
        return tag;
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
        StackUtils.readItems(this.networkCard, 0, tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getNetworkTransmitter().getUsage();
    }

    public BaseItemHandler getNetworkCard() {
        return this.networkCard;
    }

    @Override
    public IItemHandler getDrops() {
        return this.getNetworkCard();
    }

    @Nullable
    public ResourceKey<Level> getReceiverDimension() {
        return this.receiverDimension;
    }

    public int getDistance() {
        if (this.receiver == null || this.receiverDimension == null || !this.isSameDimension()) {
            return -1;
        }
        return (int)Math.sqrt(Math.pow(this.pos.m_123341_() - this.receiver.m_123341_(), 2.0) + Math.pow(this.pos.m_123342_() - this.receiver.m_123342_(), 2.0) + Math.pow(this.pos.m_123343_() - this.receiver.m_123343_(), 2.0));
    }

    public boolean isSameDimension() {
        return this.level.m_46472_() == this.receiverDimension;
    }

    private boolean canTransmit() {
        return this.canUpdate() && this.receiver != null && this.receiverDimension != null;
    }

    @Override
    public boolean shouldRebuildGraphOnChange() {
        return true;
    }

    @Override
    public void visit(INetworkNodeVisitor.Operator operator) {
        super.visit(operator);
        if (this.canTransmit()) {
            if (!this.isSameDimension()) {
                ServerLevel dimensionLevel = this.level.m_7654_().m_129880_(this.receiverDimension);
                if (dimensionLevel != null && dimensionLevel.m_7702_(this.receiver) instanceof NetworkReceiverBlockEntity) {
                    operator.apply((Level)dimensionLevel, this.receiver, null);
                }
            } else if (this.level.m_7702_(this.receiver) instanceof NetworkReceiverBlockEntity) {
                operator.apply(this.level, this.receiver, null);
            }
        }
    }
}

