/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node;

import com.google.common.primitives.Ints;
import com.refinedmods.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.SerializationUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class NodeRequirements {
    private static final String NBT_ITEMS_TO_USE = "ItemsToUse";
    private static final String NBT_FLUIDS_TO_USE = "FluidsToUse";
    private static final String NBT_ITEMS_NEEDED_PER_CRAFT = "ItemsNeededPerCraft";
    private static final String NBT_FLUIDS_NEEDED_PER_CRAFT = "FluidsNeededPerCraft";
    private final Map<Integer, IStackList<ItemStack>> itemRequirements = new LinkedHashMap<Integer, IStackList<ItemStack>>();
    private final Map<Integer, Integer> itemsNeededPerCraft = new LinkedHashMap<Integer, Integer>();
    private final Map<Integer, IStackList<FluidStack>> fluidRequirements = new LinkedHashMap<Integer, IStackList<FluidStack>>();
    private final Map<Integer, Integer> fluidsNeededPerCraft = new LinkedHashMap<Integer, Integer>();
    @Nullable
    private List<ItemStack> cachedSimulatedItemRequirementSet = null;
    @Nullable
    private List<FluidStack> cachedSimulatedFluidRequirementSet = null;

    public void addItemRequirement(int ingredientNumber, ItemStack stack, int size, int perCraft) {
        if (!this.itemsNeededPerCraft.containsKey(ingredientNumber)) {
            this.itemsNeededPerCraft.put(ingredientNumber, perCraft);
        }
        IStackList list = this.itemRequirements.computeIfAbsent(ingredientNumber, key -> API.instance().createItemStackList());
        list.add(stack, size);
        this.cachedSimulatedItemRequirementSet = null;
    }

    public void addFluidRequirement(int ingredientNumber, FluidStack stack, int size, int perCraft) {
        if (!this.fluidsNeededPerCraft.containsKey(ingredientNumber)) {
            this.fluidsNeededPerCraft.put(ingredientNumber, perCraft);
        }
        IStackList list = this.fluidRequirements.computeIfAbsent(ingredientNumber, key -> API.instance().createFluidStackList());
        list.add(stack, size);
        this.cachedSimulatedFluidRequirementSet = null;
    }

    public List<ItemStack> getSingleItemRequirementSet(boolean simulate) {
        List<ItemStack> cached = this.cachedSimulatedItemRequirementSet;
        if (simulate && cached != null) {
            return cached;
        }
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemRequirements.size(); ++i) {
            int needed = this.itemsNeededPerCraft.get(i);
            if (!this.itemRequirements.get(i).isEmpty()) {
                Iterator<StackListEntry<ItemStack>> it = this.itemRequirements.get(i).getStacks().iterator();
                while (needed > 0 && it.hasNext()) {
                    ItemStack toUse = it.next().getStack();
                    if (needed < toUse.m_41613_()) {
                        if (!simulate) {
                            this.itemRequirements.get(i).remove(toUse, needed);
                        }
                        toReturn.add(ItemHandlerHelper.copyStackWithSize((ItemStack)toUse, (int)needed));
                        needed = 0;
                        continue;
                    }
                    if (!simulate) {
                        it.remove();
                    }
                    toReturn.add(toUse);
                    needed -= toUse.m_41613_();
                }
                continue;
            }
            throw new IllegalStateException("Bad!");
        }
        this.cachedSimulatedItemRequirementSet = simulate ? toReturn : null;
        return toReturn;
    }

    public List<FluidStack> getSingleFluidRequirementSet(boolean simulate) {
        List<FluidStack> cached = this.cachedSimulatedFluidRequirementSet;
        if (simulate && cached != null) {
            return cached;
        }
        ArrayList<FluidStack> toReturn = new ArrayList<FluidStack>();
        for (int i = 0; i < this.fluidRequirements.size(); ++i) {
            int needed = this.fluidsNeededPerCraft.get(i);
            if (!this.fluidRequirements.get(i).isEmpty()) {
                Iterator<StackListEntry<FluidStack>> it = this.fluidRequirements.get(i).getStacks().iterator();
                while (needed > 0 && it.hasNext()) {
                    FluidStack toUse = it.next().getStack();
                    if (needed < toUse.getAmount()) {
                        if (!simulate) {
                            this.fluidRequirements.get(i).remove(toUse, needed);
                        }
                        FluidStack stack = toUse.copy();
                        stack.setAmount(needed);
                        toReturn.add(stack);
                        needed = 0;
                        continue;
                    }
                    if (!simulate) {
                        it.remove();
                    }
                    toReturn.add(toUse);
                    needed -= toUse.getAmount();
                }
                continue;
            }
            throw new IllegalStateException("Bad!");
        }
        this.cachedSimulatedFluidRequirementSet = simulate ? toReturn : null;
        return toReturn;
    }

    public void readFromNbt(CompoundTag tag) throws CraftingTaskReadException {
        ListTag itemRequirementsTag = tag.m_128437_(NBT_ITEMS_TO_USE, 9);
        for (int i = 0; i < itemRequirementsTag.size(); ++i) {
            this.itemRequirements.put(i, SerializationUtil.readItemStackList(itemRequirementsTag.m_128744_(i)));
        }
        List itemsNeededPerCraftTag = Ints.asList((int[])tag.m_128465_(NBT_ITEMS_NEEDED_PER_CRAFT));
        for (int i = 0; i < itemsNeededPerCraftTag.size(); ++i) {
            this.itemsNeededPerCraft.put(i, (Integer)itemsNeededPerCraftTag.get(i));
        }
        ListTag fluidRequirementsTag = tag.m_128437_(NBT_FLUIDS_TO_USE, 9);
        for (int i = 0; i < fluidRequirementsTag.size(); ++i) {
            this.fluidRequirements.put(i, SerializationUtil.readFluidStackList(fluidRequirementsTag.m_128744_(i)));
        }
        List fluidsNeededPerCraftTag = Ints.asList((int[])tag.m_128465_(NBT_FLUIDS_NEEDED_PER_CRAFT));
        for (int i = 0; i < fluidsNeededPerCraftTag.size(); ++i) {
            this.fluidsNeededPerCraft.put(i, (Integer)fluidsNeededPerCraftTag.get(i));
        }
    }

    public CompoundTag writeToNbt(CompoundTag tag) {
        ListTag itemRequirementsTag = new ListTag();
        for (IStackList<ItemStack> list : this.itemRequirements.values()) {
            itemRequirementsTag.add((Object)SerializationUtil.writeItemStackList(list));
        }
        tag.m_128365_(NBT_ITEMS_TO_USE, (Tag)itemRequirementsTag);
        tag.m_128385_(NBT_ITEMS_NEEDED_PER_CRAFT, Ints.toArray(this.itemsNeededPerCraft.values()));
        ListTag fluidRequirementsTag = new ListTag();
        for (IStackList<FluidStack> list : this.fluidRequirements.values()) {
            fluidRequirementsTag.add((Object)SerializationUtil.writeFluidStackList(list));
        }
        tag.m_128365_(NBT_FLUIDS_TO_USE, (Tag)fluidRequirementsTag);
        tag.m_128385_(NBT_FLUIDS_NEEDED_PER_CRAFT, Ints.toArray(this.fluidsNeededPerCraft.values()));
        return tag;
    }
}

