/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.biome;

import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import org.apache.commons.lang3.Validate;

public class BoxBlur {
    public static void blur(int[] data, int width, int height, int radius) {
        Validate.isTrue((data.length == width * height ? 1 : 0) != 0, (String)"data.length != (width * height)", (Object[])new Object[0]);
        int[] tmp = new int[width * height];
        BoxBlur.blur(data, tmp, width, height, radius);
        BoxBlur.blur(tmp, data, width, height, radius);
    }

    private static void blur(int[] src, int[] dst, int width, int height, int radius) {
        int windowSize = radius * 2 + 1;
        int edgeExtendAmount = radius + 1;
        int srcIndex = 0;
        for (int y = 0; y < height; ++y) {
            int dstIndex = y;
            int color = src[srcIndex];
            int alpha = ColorARGB.unpackAlpha(color);
            int red = ColorARGB.unpackRed(color);
            int green = ColorARGB.unpackGreen(color);
            int blue = ColorARGB.unpackBlue(color);
            alpha *= edgeExtendAmount;
            red *= edgeExtendAmount;
            green *= edgeExtendAmount;
            blue *= edgeExtendAmount;
            for (int i = 1; i <= radius; ++i) {
                int neighborColor = src[srcIndex + i];
                alpha += ColorARGB.unpackAlpha(neighborColor);
                red += ColorARGB.unpackRed(neighborColor);
                green += ColorARGB.unpackGreen(neighborColor);
                blue += ColorARGB.unpackBlue(neighborColor);
            }
            for (int x = 0; x < width; ++x) {
                dst[dstIndex] = ColorARGB.pack(red / windowSize, green / windowSize, blue / windowSize, alpha / windowSize);
                int previousPixelIndex = Math.max(x - radius, 0);
                int previousPixel = src[srcIndex + previousPixelIndex];
                alpha -= ColorARGB.unpackAlpha(previousPixel);
                red -= ColorARGB.unpackRed(previousPixel);
                green -= ColorARGB.unpackGreen(previousPixel);
                blue -= ColorARGB.unpackBlue(previousPixel);
                int nextPixelIndex = Math.min(x + edgeExtendAmount, width - 1);
                int nextPixel = src[srcIndex + nextPixelIndex];
                alpha += ColorARGB.unpackAlpha(nextPixel);
                red += ColorARGB.unpackRed(nextPixel);
                green += ColorARGB.unpackGreen(nextPixel);
                blue += ColorARGB.unpackBlue(nextPixel);
                dstIndex += width;
            }
            srcIndex += width;
        }
    }
}

