/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.world;

import codechicken.chunkloader.api.IChunkLoader;
import codechicken.chunkloader.api.IChunkLoaderHandler;
import codechicken.chunkloader.handler.ChickenChunksConfig;
import codechicken.chunkloader.world.ChunkTicket;
import codechicken.chunkloader.world.Organiser;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkLoaderHandler
implements IChunkLoaderHandler,
INBTSerializable<CompoundTag> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation KEY = new ResourceLocation("chickenchunks", "chunk_loaders");
    private static final boolean DEBUG = Boolean.getBoolean("chickenchunks.loading.debug");
    public static final Capability<IChunkLoaderHandler> HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IChunkLoaderHandler>(){});
    private final MinecraftServer server;
    private final Table<UUID, ResourceLocation, Organiser> playerOrganisers = HashBasedTable.create();
    private final Table<ResourceLocation, ChunkPos, ChunkTicket> activeTickets = HashBasedTable.create();
    private final List<Organiser> deviveList = new LinkedList<Organiser>();
    private final List<Organiser> reviveList = new LinkedList<Organiser>();
    private final Object2LongMap<UUID> loginTimes = new Object2LongOpenHashMap();

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ChunkLoaderHandler::onRegisterCaps);
        MinecraftForge.EVENT_BUS.addListener(ChunkLoaderHandler::onPlayerLogin);
        MinecraftForge.EVENT_BUS.addListener(ChunkLoaderHandler::onPlayerLoggedOut);
        MinecraftForge.EVENT_BUS.addListener(ChunkLoaderHandler::onWorldLoad);
        MinecraftForge.EVENT_BUS.addListener(ChunkLoaderHandler::onWorldTick);
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, ChunkLoaderHandler::attachCapabilities);
        ForgeChunkManager.setForcedChunkLoadingCallback((String)"chickenchunks", (world, ticketHelper) -> {
            ticketHelper.getBlockTickets().keySet().forEach(arg_0 -> ((ForgeChunkManager.TicketHelper)ticketHelper).removeAllTickets(arg_0));
            ticketHelper.getEntityTickets().keySet().forEach(arg_0 -> ((ForgeChunkManager.TicketHelper)ticketHelper).removeAllTickets(arg_0));
        });
    }

    private static void onRegisterCaps(RegisterCapabilitiesEvent event) {
        event.register(IChunkLoaderHandler.class);
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player.f_19853_ instanceof ServerLevel) {
            ChunkLoaderHandler handler = ChunkLoaderHandler.getHandler((LevelAccessor)player.f_19853_);
            handler.login(event);
        }
    }

    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player.f_19853_ instanceof ServerLevel) {
            ChunkLoaderHandler handler = ChunkLoaderHandler.getHandler((LevelAccessor)player.f_19853_);
            handler.logout(event);
        }
    }

    private static void onWorldLoad(LevelEvent.Load event) {
        ServerLevel world;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (world = (ServerLevel)levelAccessor).m_46472_() == Level.f_46428_) {
            ChunkLoaderHandler handler = ChunkLoaderHandler.getHandler((LevelAccessor)world);
            handler.onOverWorldLoad();
        }
    }

    private static void onWorldTick(TickEvent.LevelTickEvent event) {
        ChunkLoaderHandler handler;
        ServerLevel world;
        Level level = event.level;
        if (level instanceof ServerLevel && (world = (ServerLevel)level).m_46472_() == Level.f_46428_ && (handler = ChunkLoaderHandler.getHandler((LevelAccessor)world)) != null) {
            handler.tick(event);
        }
    }

    private static void attachCapabilities(AttachCapabilitiesEvent<Level> event) {
        if (((Level)event.getObject()).f_46443_) {
            return;
        }
        final ServerLevel world = (ServerLevel)event.getObject();
        if (world.m_46472_() != Level.f_46428_) {
            return;
        }
        event.addCapability(KEY, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
            private final ChunkLoaderHandler handler;
            private final LazyOptional<ChunkLoaderHandler> opt;
            {
                this.handler = new ChunkLoaderHandler(world.m_7654_());
                this.opt = LazyOptional.of(() -> this.handler);
            }

            public CompoundTag serializeNBT() {
                return this.handler.serializeNBT();
            }

            public void deserializeNBT(CompoundTag tag) {
                this.handler.deserializeNBT(tag);
            }

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                if (cap == HANDLER_CAPABILITY) {
                    return (LazyOptional)SneakyUtils.unsafeCast(this.opt);
                }
                return LazyOptional.empty();
            }
        });
    }

    protected ChunkLoaderHandler(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public void addChunkLoader(IChunkLoader loader) {
        Objects.requireNonNull(loader);
        if (loader.getOwner() == null) {
            LOGGER.error("ChunkLoader at {} has null owner. Not processing.", (Object)loader.pos());
            return;
        }
        Organiser organiser = this.getOrganiser(loader);
        if (this.canLoadChunks(loader, loader.getChunks())) {
            organiser.addChunkLoader(loader);
        } else {
            loader.deactivate();
        }
    }

    @Override
    public void removeChunkLoader(IChunkLoader loader) {
        Objects.requireNonNull(loader);
        Organiser organiser = this.getOrganiser(loader);
        organiser.remChunkLoader(loader);
    }

    @Override
    public boolean canLoadChunks(IChunkLoader loader, Set<ChunkPos> newChunks) {
        Objects.requireNonNull(loader);
        UUID player = Objects.requireNonNull(loader.getOwner());
        ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getRestrictions(player);
        int totalLoaded = this.getLoadedChunkCount(player);
        Organiser organiser = this.getOrganiser(loader);
        Set<ChunkPos> currentLoaded = organiser.forcedChunksByLoader.get(loader);
        int netChange = newChunks.size();
        if (currentLoaded != null && !currentLoaded.isEmpty()) {
            netChange = newChunks.size() - Sets.intersection(newChunks, currentLoaded).size();
        }
        return ChickenChunksConfig.doesBypassRestrictions(this.server, player) || totalLoaded + netChange <= restrictions.getTotalAllowedChunks();
    }

    @Override
    public void updateLoader(IChunkLoader loader) {
        Objects.requireNonNull(loader);
        Organiser organiser = this.getOrganiser(loader);
        organiser.updateLoader(loader);
    }

    public void login(PlayerEvent.PlayerLoggedInEvent event) {
        this.loginTimes.put((Object)event.getEntity().m_20148_(), System.currentTimeMillis());
        this.reviveList.addAll(this.playerOrganisers.row((Object)event.getEntity().m_20148_()).values());
    }

    public void logout(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID player = event.getEntity().m_20148_();
        ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getRestrictions(player);
        if (!restrictions.canLoadOffline()) {
            this.deviveList.addAll(this.playerOrganisers.row((Object)player).values());
        }
    }

    private void onOverWorldLoad() {
        for (Map.Entry playerEntry : this.playerOrganisers.rowMap().entrySet()) {
            long curr = System.currentTimeMillis();
            UUID player = (UUID)playerEntry.getKey();
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getRestrictions(player);
            int timeout = restrictions.getOfflineTimeout();
            long lastSeen = this.loginTimes.getOrDefault((Object)player, -1L);
            if (!restrictions.canLoadOffline() && lastSeen == -1L && (curr - lastSeen) / 60000L >= (long)timeout) continue;
            if (DEBUG) {
                LOGGER.info("Adding {} organizers to revive list for {}", (Object)((Map)playerEntry.getValue()).values().size(), (Object)player);
            }
            this.reviveList.addAll(((Map)playerEntry.getValue()).values());
        }
    }

    public void tick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (event.level.m_46467_() % 1200L == 0L) {
                long curr = System.currentTimeMillis();
                for (ServerPlayer serverPlayer : this.server.m_6846_().m_11314_()) {
                    this.loginTimes.put((Object)serverPlayer.m_20148_(), curr);
                }
                for (Map.Entry entry : this.playerOrganisers.rowMap().entrySet()) {
                    UUID player = (UUID)entry.getKey();
                    ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getRestrictions(player);
                    if (restrictions.canLoadOffline()) continue;
                    int timeout = restrictions.getOfflineTimeout();
                    long lastSeen = this.loginTimes.getOrDefault((Object)player, -1L);
                    if (lastSeen == curr || timeout != 0 && lastSeen != -1L && (curr - lastSeen) / 60000L >= (long)timeout) continue;
                    this.deviveList.addAll(((Map)entry.getValue()).values());
                }
            }
            this.playerOrganisers.values().forEach(Organiser::onTickEnd);
            for (Organiser organiser : this.reviveList) {
                ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)organiser.dim);
                ServerLevel serverLevel = this.server.m_129880_(key);
                if (serverLevel == null) continue;
                organiser.revive(serverLevel);
            }
            this.reviveList.clear();
            for (Organiser organiser : this.deviveList) {
                organiser.devive();
            }
            this.deviveList.clear();
        }
    }

    public void remChunk(IChunkLoader loader, ResourceLocation dim, ChunkPos pos) {
        ChunkTicket ticket = (ChunkTicket)this.activeTickets.get((Object)dim, (Object)pos);
        if (ticket != null) {
            if (ticket.remLoader(loader)) {
                this.activeTickets.remove((Object)dim, (Object)pos);
            }
            if (DEBUG) {
                LOGGER.info("Loader {} Un-Forcing chunk: {}", (Object)loader.pos(), (Object)pos);
            }
        }
    }

    public void addChunk(IChunkLoader loader, ResourceLocation dim, ChunkPos pos) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dim);
        ServerLevel world = this.server.m_129880_(key);
        ChunkTicket ticket = ChunkLoaderHandler.computeIfAbsent(this.activeTickets, dim, pos, () -> new ChunkTicket(world, pos));
        ticket.addLoader(loader);
        if (DEBUG) {
            LOGGER.info("Loader {} Forcing chunk: {}", (Object)loader.pos(), (Object)pos);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag playerList = new ListTag();
        for (Map.Entry playerEntry : this.playerOrganisers.rowMap().entrySet()) {
            CompoundTag playerTag = new CompoundTag();
            playerTag.m_128362_("player", (UUID)playerEntry.getKey());
            ListTag dimensions = new ListTag();
            for (Map.Entry dimEntry : ((Map)playerEntry.getValue()).entrySet()) {
                if (((Organiser)dimEntry.getValue()).isEmpty()) continue;
                CompoundTag dimTag = new CompoundTag();
                dimTag.m_128359_("dimension", ((ResourceLocation)dimEntry.getKey()).toString());
                dimTag.m_128365_("organiser", (Tag)((Organiser)dimEntry.getValue()).write(new CompoundTag()));
                dimensions.add((Object)dimTag);
            }
            if (dimensions.isEmpty()) continue;
            playerTag.m_128365_("dimensions", (Tag)dimensions);
            playerList.add((Object)playerTag);
        }
        tag.m_128365_("playerOrganisers", (Tag)playerList);
        ListTag loginList = new ListTag();
        for (Object2LongMap.Entry uuidEntry : this.loginTimes.object2LongEntrySet()) {
            CompoundTag playerTag = new CompoundTag();
            playerTag.m_128362_("player", (UUID)uuidEntry.getKey());
            playerTag.m_128356_("time", uuidEntry.getLongValue());
            loginList.add((Object)playerTag);
        }
        tag.m_128365_("loginTimes", (Tag)loginList);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        ListTag playerList = tag.m_128437_("playerOrganisers", 10);
        for (int i = 0; i < playerList.size(); ++i) {
            CompoundTag playerTag = playerList.m_128728_(i);
            UUID player = playerTag.m_128342_("player");
            ListTag dimensions = playerTag.m_128437_("dimensions", 10);
            for (int j = 0; j < dimensions.size(); ++j) {
                CompoundTag dimTag = dimensions.m_128728_(j);
                ResourceLocation dim = new ResourceLocation(dimTag.m_128461_("dimension"));
                Organiser organiser = new Organiser(this, dim, player).read(dimTag.m_128469_("organiser"));
                this.playerOrganisers.put((Object)player, (Object)dim, (Object)organiser);
            }
        }
        ListTag loginList = tag.m_128437_("times", 10);
        for (int i = 0; i < loginList.size(); ++i) {
            CompoundTag playerTag = loginList.m_128728_(i);
            this.loginTimes.put((Object)playerTag.m_128342_("player"), playerTag.m_128454_("time"));
        }
    }

    public int getLoadedChunkCount(UUID player) {
        return this.playerOrganisers.row((Object)player).values().stream().mapToInt(organiser -> organiser.forcedChunksByChunk.size()).sum();
    }

    public Organiser getOrganiser(IChunkLoader loader) {
        Objects.requireNonNull(loader);
        UUID player = Objects.requireNonNull(loader.getOwner());
        return this.getOrganiser((ResourceKey<Level>)loader.world().m_46472_(), player);
    }

    public Organiser getOrganiser(ResourceKey<Level> dim, UUID player) {
        return this.getOrganiser(dim.m_135782_(), player);
    }

    public Organiser getOrganiser(ResourceLocation dim, UUID player) {
        return ChunkLoaderHandler.computeIfAbsent(this.playerOrganisers, player, dim, () -> new Organiser(this, dim, player));
    }

    private static ChunkLoaderHandler getHandler(LevelAccessor world) {
        return (ChunkLoaderHandler)IChunkLoaderHandler.getCapability(world);
    }

    private static <R, C, V> V computeIfAbsent(Table<R, C, V> table, R r, C c, Supplier<V> vFunc) {
        Object val = table.get(r, c);
        if (val == null) {
            val = vFunc.get();
            table.put(r, c, val);
        }
        return (V)val;
    }
}

