/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.client;

import codechicken.chunkloader.client.TileChunkLoaderRenderer;
import codechicken.lib.model.PerspectiveModelState;
import codechicken.lib.model.bakedmodels.WrappedItemModel;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemStack;

public class ChunkLoaderItemModel
extends WrappedItemModel
implements IItemRenderer {
    private final boolean spotLoader;

    public ChunkLoaderItemModel(BakedModel wrappedModel, boolean spotLoader) {
        super(wrappedModel);
        this.spotLoader = spotLoader;
    }

    public void renderItem(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        double size;
        double height;
        this.renderWrapped(stack, mStack, getter, packedLight, packedOverlay, false);
        double rot = ClientUtils.getRenderTime() / 6.0;
        if (!this.spotLoader) {
            height = 0.9;
            size = 0.08;
        } else {
            height = 0.55;
            size = 0.05;
        }
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        ccrs.reset();
        Matrix4 pearlMat = RenderUtils.getMatrix((Matrix4)new Matrix4(mStack), (Vector3)new Vector3(0.5, height, 0.5), (Rotation)new Rotation(rot, Vector3.Y_POS), (double)size);
        ccrs.brightness = 0xF000F0;
        ccrs.bind(TileChunkLoaderRenderer.pearlType, getter);
        CCModelLibrary.icosahedron4.render(ccrs, new IVertexOperation[]{pearlMat});
        ccrs.reset();
    }

    public PerspectiveModelState getModelState() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }
}

