/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_forge.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.collective_common_forge.functions.CompareBlockFunctions;
import com.natamus.collective_common_forge.functions.CompareItemFunctions;
import com.natamus.collective_common_forge.functions.DataFunctions;
import com.natamus.collective_common_forge.services.Services;
import com.natamus.treeharvester_common_forge.config.ConfigHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.MyceliumBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;

public class Util {
    private static final String dirpath = DataFunctions.getConfigDirectory() + File.separator + "treeharvester";
    private static final File dir = new File(dirpath);
    private static final File file = new File(dirpath + File.separator + "harvestable_axe_blacklist.txt");
    public static List<Item> allowedAxes = new ArrayList<Item>();
    public static HashMap<BlockPos, Integer> highestleaf = new HashMap();
    public static CopyOnWriteArrayList<Pair<BlockPos, CopyOnWriteArrayList<BlockPos>>> lowerlogs = new CopyOnWriteArrayList();

    public static void setupAxeBlacklist() throws IOException {
        ArrayList<String> blacklist = new ArrayList<String>();
        PrintWriter writer = null;
        if (!dir.isDirectory() || !file.isFile()) {
            boolean ignored = dir.mkdirs();
            writer = new PrintWriter(dirpath + File.separator + "harvestable_axe_blacklist.txt", StandardCharsets.UTF_8);
        } else {
            String blcontent = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "harvestable_axe_blacklist.txt", new String[0])));
            for (String axerl : blcontent.split(",")) {
                String name = axerl.replace("\n", "").trim();
                if (name.startsWith("//") || !name.startsWith("!")) continue;
                blacklist.add(name.replace("!", ""));
            }
        }
        if (writer != null) {
            writer.println("// To disable a certain axe from being able to harvest trees, add an exclamation mark (!) in front of the line,");
        }
        for (Item item : Registry.f_122827_) {
            ResourceLocation rl;
            if (!Services.TOOLFUNCTIONS.isAxe(new ItemStack((ItemLike)item)) || (rl = Registry.f_122827_.m_7981_((Object)item)) == null) continue;
            String name = rl.toString();
            if (writer != null) {
                writer.println(name + ",");
            }
            if (blacklist.contains(name)) continue;
            allowedAxes.add(item);
        }
        if (writer != null) {
            writer.close();
        }
    }

    public static int isTreeAndReturnLogAmount(Level level, BlockPos pos) {
        highestleaf.put(pos, 0);
        int leafcount = 9;
        int logcount = 0;
        int prevleafcount = -1;
        int prevlogcount = -1;
        int highesty = 0;
        for (int y = 1; y <= 30 && (prevleafcount != leafcount || prevlogcount != logcount); ++y) {
            prevleafcount = leafcount;
            prevlogcount = logcount;
            Iterator it = BlockPos.m_121886_((int)(pos.m_123341_() - 2), (int)(pos.m_123342_() + (y - 1)), (int)(pos.m_123343_() - 2), (int)(pos.m_123341_() + 2), (int)(pos.m_123342_() + (y - 1)), (int)(pos.m_123343_() + 2)).iterator();
            while (it.hasNext()) {
                BlockPos npos = (BlockPos)it.next();
                Block nblock = level.m_8055_(npos).m_60734_();
                if (CompareBlockFunctions.isTreeLeaf((Block)nblock, (boolean)ConfigHandler.enableNetherTrees) || Util.isGiantMushroomLeafBlock(nblock)) {
                    --leafcount;
                    if (npos.m_123342_() <= highesty) continue;
                    highesty = npos.m_123342_();
                    continue;
                }
                if (!CompareBlockFunctions.isTreeLog((Block)nblock) && !Util.isGiantMushroomStemBlock(nblock)) continue;
                ++logcount;
            }
        }
        highestleaf.put(pos.m_7949_(), highesty);
        if (leafcount < 0) {
            return logcount;
        }
        return -1;
    }

    public static List<BlockPos> getAllLogsToBreak(Level level, BlockPos pos, int logcount, Block logtype) {
        Block blockbelow;
        CopyOnWriteArrayList<BlockPos> bottomlogs = new CopyOnWriteArrayList<BlockPos>();
        if (ConfigHandler.replaceSaplingOnTreeHarvest && (CompareBlockFunctions.isDirtBlock((Block)(blockbelow = level.m_8055_(pos.m_7495_()).m_60734_())) || blockbelow instanceof MyceliumBlock)) {
            Iterator it = BlockPos.m_121886_((int)(pos.m_123341_() - 1), (int)pos.m_123342_(), (int)(pos.m_123343_() - 1), (int)(pos.m_123341_() + 1), (int)pos.m_123342_(), (int)(pos.m_123343_() + 1)).iterator();
            while (it.hasNext()) {
                BlockPos npos = (BlockPos)it.next();
                Block block = level.m_8055_(npos).m_60734_();
                if (!block.equals(logtype)) continue;
                bottomlogs.add(npos.m_7949_());
            }
        }
        if (ConfigHandler.replaceSaplingOnTreeHarvest) {
            if (ConfigHandler.instantBreakLeavesAround) {
                Util.replaceSapling(level, pos, bottomlogs, 1, null);
            } else if (ConfigHandler.enableFastLeafDecay) {
                lowerlogs.add((Pair<BlockPos, CopyOnWriteArrayList<BlockPos>>)new Pair((Object)pos.m_7949_(), bottomlogs));
            }
        }
        return Util.getLogsToBreak(level, pos, new ArrayList<BlockPos>(), logcount, logtype);
    }

    public static void replaceSapling(Level level, BlockPos pos, CopyOnWriteArrayList<BlockPos> bottomlogs, int radius, Item saplingitem) {
        int rc = bottomlogs.size();
        if (rc == 0) {
            return;
        }
        ItemStack sapling = null;
        for (Entity ea : level.m_45933_(null, new AABB((double)(pos.m_123341_() - radius), (double)(pos.m_123342_() - 2), (double)(pos.m_123343_() - radius), (double)(pos.m_123341_() + radius), (double)(pos.m_123342_() + 30), (double)(pos.m_123343_() + radius)))) {
            int count;
            if (!(ea instanceof ItemEntity)) continue;
            ItemEntity eia = (ItemEntity)ea;
            ItemStack eisa = eia.m_32055_();
            Item eisaitem = eisa.m_41720_();
            if (saplingitem != null && !eisaitem.equals(saplingitem) || !CompareItemFunctions.isSapling((ItemStack)eisa) && (!ConfigHandler.replaceMushroomOnMushroomHarvest || !(Block.m_49814_((Item)eisaitem) instanceof MushroomBlock))) continue;
            if (sapling == null) {
                sapling = eisa.m_41777_();
                saplingitem = eisaitem;
            }
            if ((count = eisa.m_41613_()) > 1) {
                for (int n = 0; n < count; ++n) {
                    eisa.m_41774_(1);
                    if (--rc == 0) break;
                }
                eia.m_32045_(eisa);
            } else {
                --rc;
                eia.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (rc != 0) continue;
            break;
        }
        int setsaplings = bottomlogs.size() - rc;
        for (BlockPos bottompos : bottomlogs) {
            if (setsaplings == 0) break;
            Block belowblock = level.m_8055_(bottompos.m_7495_()).m_60734_();
            if (CompareBlockFunctions.isDirtBlock((Block)belowblock) || belowblock instanceof MyceliumBlock) {
                level.m_46597_(bottompos, Block.m_49814_((Item)sapling.m_41720_()).m_49966_());
            }
            --setsaplings;
            bottomlogs.remove(bottompos);
        }
        if (bottomlogs.size() > 0) {
            if (radius >= 5) {
                return;
            }
            Util.replaceSapling(level, pos, bottomlogs, radius + 2, saplingitem);
        }
    }

    private static List<BlockPos> getLogsToBreak(Level level, BlockPos pos, List<BlockPos> logstobreak, int logcount, Block logtype) {
        ArrayList<Object> checkaround = new ArrayList<Object>();
        Iterator aroundlogs = BlockPos.m_121886_((int)(pos.m_123341_() - 1), (int)pos.m_123342_(), (int)(pos.m_123343_() - 1), (int)(pos.m_123341_() + 1), (int)(pos.m_123342_() + 1), (int)(pos.m_123343_() + 1)).iterator();
        while (aroundlogs.hasNext()) {
            BlockState blockState;
            Block logblock;
            BlockPos nalogpos = ((BlockPos)aroundlogs.next()).m_7949_();
            if (logstobreak.contains(nalogpos) || !(logblock = (blockState = level.m_8055_(nalogpos)).m_60734_()).equals(logtype)) continue;
            checkaround.add(nalogpos);
            logstobreak.add(nalogpos);
            if (!ConfigHandler.instantBreakLeavesAround) continue;
            Pair<Integer, Integer> hv = Util.getHorizontalAndVerticalValue(level, pos, logtype, logcount);
            int h = (Integer)hv.getFirst();
            int v = (Integer)hv.getSecond();
            Iterator aroundleaves = BlockPos.m_121886_((int)(pos.m_123341_() - h), (int)pos.m_123342_(), (int)(pos.m_123343_() - h), (int)(pos.m_123341_() + h), (int)(pos.m_123342_() + v), (int)(pos.m_123343_() + h)).iterator();
            while (aroundleaves.hasNext()) {
                BlockPos naleafpos = (BlockPos)aroundleaves.next();
                Block leafblock = level.m_8055_(naleafpos).m_60734_();
                if (!CompareBlockFunctions.isTreeLeaf((Block)leafblock, (boolean)ConfigHandler.enableNetherTrees) && !Util.isGiantMushroomLeafBlock(leafblock)) continue;
                level.m_46961_(naleafpos, true);
            }
        }
        if (checkaround.size() == 0) {
            return logstobreak;
        }
        for (BlockPos blockPos : checkaround) {
            for (BlockPos logpos : Util.getLogsToBreak(level, blockPos, logstobreak, logcount, logtype)) {
                if (logstobreak.contains(logpos)) continue;
                logstobreak.add(logpos.m_7949_());
            }
        }
        BlockPos up = pos.m_6630_(2);
        return Util.getLogsToBreak(level, up.m_7949_(), logstobreak, logcount, logtype);
    }

    public static Pair<Integer, Integer> getHorizontalAndVerticalValue(Level level, BlockPos startpos, Block logtype, int logcount) {
        int h = 4;
        int v = 4;
        if (logtype.equals(Blocks.f_50003_)) {
            h = 5;
            v = 5;
        } else if (Util.isGiantMushroomStemBlock(logtype)) {
            BlockPos temppos = startpos.m_7949_();
            while (!Util.isGiantMushroomLeafBlock(level.m_8055_(temppos.m_7494_()).m_60734_()) && temppos.m_123342_() <= level.m_151558_()) {
                temppos = temppos.m_7494_().m_7949_();
            }
            if (level.m_8055_(temppos.m_7494_()).m_60734_().m_60590_().equals(MaterialColor.f_76364_)) {
                h = 2;
                v = 2;
            } else {
                h = 3;
                v = 3;
            }
        } else if (logcount >= 20) {
            h = 5;
            v = 5;
        } else if (logcount >= 15) {
            h = 6;
            v = 7;
        } else if (logcount >= 10) {
            h = 4;
            v = 5;
        }
        return new Pair((Object)h, (Object)v);
    }

    public static boolean isGiantMushroomStemBlock(Block block) {
        if (!ConfigHandler.enableHugeMushrooms) {
            return false;
        }
        MaterialColor materialcolour = block.m_60590_();
        return block instanceof HugeMushroomBlock && materialcolour.equals(MaterialColor.f_76401_);
    }

    public static boolean isGiantMushroomLeafBlock(Block block) {
        if (!ConfigHandler.enableHugeMushrooms) {
            return false;
        }
        MaterialColor materialcolour = block.m_60590_();
        return block instanceof HugeMushroomBlock && (materialcolour.equals(MaterialColor.f_76408_) || materialcolour.equals(MaterialColor.f_76364_));
    }

    public static Pair<Boolean, List<BlockPos>> isConnectedToLogs(Level level, BlockPos startpos) {
        List recursiveList = BlockPosFunctions.getBlocksNextToEachOtherMaterial((Level)level, (BlockPos)startpos, Arrays.asList(Material.f_76320_, Material.f_76274_), (int)6);
        for (BlockPos connectedpos : recursiveList) {
            Block connectedblock = level.m_8055_(connectedpos).m_60734_();
            if (!CompareBlockFunctions.isTreeLog((Block)connectedblock) && !Util.isGiantMushroomStemBlock(connectedblock)) continue;
            return new Pair((Object)true, (Object)recursiveList);
        }
        return new Pair((Object)false, (Object)recursiveList);
    }
}

