/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_fabric.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.functions.BlockPosFunctions;
import com.natamus.collective_common_fabric.functions.CompareBlockFunctions;
import com.natamus.collective_common_fabric.functions.CompareItemFunctions;
import com.natamus.collective_common_fabric.functions.DataFunctions;
import com.natamus.collective_common_fabric.services.Services;
import com.natamus.treeharvester_common_fabric.config.ConfigHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2381;
import net.minecraft.class_2418;
import net.minecraft.class_2420;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_3620;

public class Util {
    private static final String dirpath = DataFunctions.getConfigDirectory() + File.separator + "treeharvester";
    private static final File dir = new File(dirpath);
    private static final File file = new File(dirpath + File.separator + "harvestable_axe_blacklist.txt");
    public static List<class_1792> allowedAxes = new ArrayList<class_1792>();
    public static HashMap<class_2338, Integer> highestleaf = new HashMap();
    public static CopyOnWriteArrayList<Pair<class_2338, CopyOnWriteArrayList<class_2338>>> lowerlogs = new CopyOnWriteArrayList();

    public static void setupAxeBlacklist() throws IOException {
        ArrayList<String> blacklist = new ArrayList<String>();
        PrintWriter writer = null;
        if (!dir.isDirectory() || !file.isFile()) {
            boolean ignored = dir.mkdirs();
            writer = new PrintWriter(dirpath + File.separator + "harvestable_axe_blacklist.txt", StandardCharsets.UTF_8);
        } else {
            String blcontent = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "harvestable_axe_blacklist.txt", new String[0])));
            for (String axerl : blcontent.split(",")) {
                String name = axerl.replace("\n", "").trim();
                if (name.startsWith("//") || !name.startsWith("!")) continue;
                blacklist.add(name.replace("!", ""));
            }
        }
        if (writer != null) {
            writer.println("// To disable a certain axe from being able to harvest trees, add an exclamation mark (!) in front of the line,");
        }
        for (class_1792 item : class_2378.field_11142) {
            class_2960 rl;
            if (!Services.TOOLFUNCTIONS.isAxe(new class_1799((class_1935)item)) || (rl = class_2378.field_11142.method_10221((Object)item)) == null) continue;
            String name = rl.toString();
            if (writer != null) {
                writer.println(name + ",");
            }
            if (blacklist.contains(name)) continue;
            allowedAxes.add(item);
        }
        if (writer != null) {
            writer.close();
        }
    }

    public static int isTreeAndReturnLogAmount(class_1937 level, class_2338 pos) {
        highestleaf.put(pos, 0);
        int leafcount = 9;
        int logcount = 0;
        int prevleafcount = -1;
        int prevlogcount = -1;
        int highesty = 0;
        for (int y = 1; y <= 30 && (prevleafcount != leafcount || prevlogcount != logcount); ++y) {
            prevleafcount = leafcount;
            prevlogcount = logcount;
            Iterator it = class_2338.method_17962((int)(pos.method_10263() - 2), (int)(pos.method_10264() + (y - 1)), (int)(pos.method_10260() - 2), (int)(pos.method_10263() + 2), (int)(pos.method_10264() + (y - 1)), (int)(pos.method_10260() + 2)).iterator();
            while (it.hasNext()) {
                class_2338 npos = (class_2338)it.next();
                class_2248 nblock = level.method_8320(npos).method_26204();
                if (CompareBlockFunctions.isTreeLeaf((class_2248)nblock, (boolean)ConfigHandler.enableNetherTrees) || Util.isGiantMushroomLeafBlock(nblock)) {
                    --leafcount;
                    if (npos.method_10264() <= highesty) continue;
                    highesty = npos.method_10264();
                    continue;
                }
                if (!CompareBlockFunctions.isTreeLog((class_2248)nblock) && !Util.isGiantMushroomStemBlock(nblock)) continue;
                ++logcount;
            }
        }
        highestleaf.put(pos.method_10062(), highesty);
        if (leafcount < 0) {
            return logcount;
        }
        return -1;
    }

    public static List<class_2338> getAllLogsToBreak(class_1937 level, class_2338 pos, int logcount, class_2248 logtype) {
        class_2248 blockbelow;
        CopyOnWriteArrayList<class_2338> bottomlogs = new CopyOnWriteArrayList<class_2338>();
        if (ConfigHandler.replaceSaplingOnTreeHarvest && (CompareBlockFunctions.isDirtBlock((class_2248)(blockbelow = level.method_8320(pos.method_10074()).method_26204())) || blockbelow instanceof class_2418)) {
            Iterator it = class_2338.method_17962((int)(pos.method_10263() - 1), (int)pos.method_10264(), (int)(pos.method_10260() - 1), (int)(pos.method_10263() + 1), (int)pos.method_10264(), (int)(pos.method_10260() + 1)).iterator();
            while (it.hasNext()) {
                class_2338 npos = (class_2338)it.next();
                class_2248 block = level.method_8320(npos).method_26204();
                if (!block.equals(logtype)) continue;
                bottomlogs.add(npos.method_10062());
            }
        }
        if (ConfigHandler.replaceSaplingOnTreeHarvest) {
            if (ConfigHandler.instantBreakLeavesAround) {
                Util.replaceSapling(level, pos, bottomlogs, 1, null);
            } else if (ConfigHandler.enableFastLeafDecay) {
                lowerlogs.add((Pair<class_2338, CopyOnWriteArrayList<class_2338>>)new Pair((Object)pos.method_10062(), bottomlogs));
            }
        }
        return Util.getLogsToBreak(level, pos, new ArrayList<class_2338>(), logcount, logtype);
    }

    public static void replaceSapling(class_1937 level, class_2338 pos, CopyOnWriteArrayList<class_2338> bottomlogs, int radius, class_1792 saplingitem) {
        int rc = bottomlogs.size();
        if (rc == 0) {
            return;
        }
        class_1799 sapling = null;
        for (class_1297 ea : level.method_8335(null, new class_238((double)(pos.method_10263() - radius), (double)(pos.method_10264() - 2), (double)(pos.method_10260() - radius), (double)(pos.method_10263() + radius), (double)(pos.method_10264() + 30), (double)(pos.method_10260() + radius)))) {
            int count;
            if (!(ea instanceof class_1542)) continue;
            class_1542 eia = (class_1542)ea;
            class_1799 eisa = eia.method_6983();
            class_1792 eisaitem = eisa.method_7909();
            if (saplingitem != null && !eisaitem.equals(saplingitem) || !CompareItemFunctions.isSapling((class_1799)eisa) && (!ConfigHandler.replaceMushroomOnMushroomHarvest || !(class_2248.method_9503((class_1792)eisaitem) instanceof class_2420))) continue;
            if (sapling == null) {
                sapling = eisa.method_7972();
                saplingitem = eisaitem;
            }
            if ((count = eisa.method_7947()) > 1) {
                for (int n = 0; n < count; ++n) {
                    eisa.method_7934(1);
                    if (--rc == 0) break;
                }
                eia.method_6979(eisa);
            } else {
                --rc;
                eia.method_5650(class_1297.class_5529.field_26999);
            }
            if (rc != 0) continue;
            break;
        }
        int setsaplings = bottomlogs.size() - rc;
        for (class_2338 bottompos : bottomlogs) {
            if (setsaplings == 0) break;
            class_2248 belowblock = level.method_8320(bottompos.method_10074()).method_26204();
            if (CompareBlockFunctions.isDirtBlock((class_2248)belowblock) || belowblock instanceof class_2418) {
                level.method_8501(bottompos, class_2248.method_9503((class_1792)sapling.method_7909()).method_9564());
            }
            --setsaplings;
            bottomlogs.remove(bottompos);
        }
        if (bottomlogs.size() > 0) {
            if (radius >= 5) {
                return;
            }
            Util.replaceSapling(level, pos, bottomlogs, radius + 2, saplingitem);
        }
    }

    private static List<class_2338> getLogsToBreak(class_1937 level, class_2338 pos, List<class_2338> logstobreak, int logcount, class_2248 logtype) {
        ArrayList<Object> checkaround = new ArrayList<Object>();
        Iterator aroundlogs = class_2338.method_17962((int)(pos.method_10263() - 1), (int)pos.method_10264(), (int)(pos.method_10260() - 1), (int)(pos.method_10263() + 1), (int)(pos.method_10264() + 1), (int)(pos.method_10260() + 1)).iterator();
        while (aroundlogs.hasNext()) {
            class_2680 class_26802;
            class_2248 logblock;
            class_2338 nalogpos = ((class_2338)aroundlogs.next()).method_10062();
            if (logstobreak.contains(nalogpos) || !(logblock = (class_26802 = level.method_8320(nalogpos)).method_26204()).equals(logtype)) continue;
            checkaround.add(nalogpos);
            logstobreak.add(nalogpos);
            if (!ConfigHandler.instantBreakLeavesAround) continue;
            Pair<Integer, Integer> hv = Util.getHorizontalAndVerticalValue(level, pos, logtype, logcount);
            int h = (Integer)hv.getFirst();
            int v = (Integer)hv.getSecond();
            Iterator aroundleaves = class_2338.method_17962((int)(pos.method_10263() - h), (int)pos.method_10264(), (int)(pos.method_10260() - h), (int)(pos.method_10263() + h), (int)(pos.method_10264() + v), (int)(pos.method_10260() + h)).iterator();
            while (aroundleaves.hasNext()) {
                class_2338 naleafpos = (class_2338)aroundleaves.next();
                class_2248 leafblock = level.method_8320(naleafpos).method_26204();
                if (!CompareBlockFunctions.isTreeLeaf((class_2248)leafblock, (boolean)ConfigHandler.enableNetherTrees) && !Util.isGiantMushroomLeafBlock(leafblock)) continue;
                level.method_22352(naleafpos, true);
            }
        }
        if (checkaround.size() == 0) {
            return logstobreak;
        }
        for (class_2338 class_23382 : checkaround) {
            for (class_2338 logpos : Util.getLogsToBreak(level, class_23382, logstobreak, logcount, logtype)) {
                if (logstobreak.contains(logpos)) continue;
                logstobreak.add(logpos.method_10062());
            }
        }
        class_2338 up = pos.method_10086(2);
        return Util.getLogsToBreak(level, up.method_10062(), logstobreak, logcount, logtype);
    }

    public static Pair<Integer, Integer> getHorizontalAndVerticalValue(class_1937 level, class_2338 startpos, class_2248 logtype, int logcount) {
        int h = 4;
        int v = 4;
        if (logtype.equals(class_2246.field_10533)) {
            h = 5;
            v = 5;
        } else if (Util.isGiantMushroomStemBlock(logtype)) {
            class_2338 temppos = startpos.method_10062();
            while (!Util.isGiantMushroomLeafBlock(level.method_8320(temppos.method_10084()).method_26204()) && temppos.method_10264() <= level.method_31600()) {
                temppos = temppos.method_10084().method_10062();
            }
            if (level.method_8320(temppos.method_10084()).method_26204().method_26403().equals(class_3620.field_16020)) {
                h = 2;
                v = 2;
            } else {
                h = 3;
                v = 3;
            }
        } else if (logcount >= 20) {
            h = 5;
            v = 5;
        } else if (logcount >= 15) {
            h = 6;
            v = 7;
        } else if (logcount >= 10) {
            h = 4;
            v = 5;
        }
        return new Pair((Object)h, (Object)v);
    }

    public static boolean isGiantMushroomStemBlock(class_2248 block) {
        if (!ConfigHandler.enableHugeMushrooms) {
            return false;
        }
        class_3620 materialcolour = block.method_26403();
        return block instanceof class_2381 && materialcolour.equals(class_3620.field_15979);
    }

    public static boolean isGiantMushroomLeafBlock(class_2248 block) {
        if (!ConfigHandler.enableHugeMushrooms) {
            return false;
        }
        class_3620 materialcolour = block.method_26403();
        return block instanceof class_2381 && (materialcolour.equals(class_3620.field_16000) || materialcolour.equals(class_3620.field_16020));
    }

    public static Pair<Boolean, List<class_2338>> isConnectedToLogs(class_1937 level, class_2338 startpos) {
        List recursiveList = BlockPosFunctions.getBlocksNextToEachOtherMaterial((class_1937)level, (class_2338)startpos, Arrays.asList(class_3614.field_15932, class_3614.field_15923), (int)6);
        for (class_2338 connectedpos : recursiveList) {
            class_2248 connectedblock = level.method_8320(connectedpos).method_26204();
            if (!CompareBlockFunctions.isTreeLog((class_2248)connectedblock) && !Util.isGiantMushroomStemBlock(connectedblock)) continue;
            return new Pair((Object)true, (Object)recursiveList);
        }
        return new Pair((Object)false, (Object)recursiveList);
    }
}

