/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_fabric.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.functions.BlockFunctions;
import com.natamus.collective_common_fabric.functions.BlockPosFunctions;
import com.natamus.collective_common_fabric.functions.CompareBlockFunctions;
import com.natamus.collective_common_fabric.functions.ItemFunctions;
import com.natamus.collective_common_fabric.services.Services;
import com.natamus.treeharvester_common_fabric.config.ConfigHandler;
import com.natamus.treeharvester_common_fabric.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3614;
import net.minecraft.class_3965;

public class TreeEvent {
    private static boolean setupBlacklistRan = false;
    private static final HashMap<class_1937, CopyOnWriteArrayList<List<class_2338>>> processleaves = new HashMap();
    private static final HashMap<Pair<class_1937, class_1657>, Pair<Date, Integer>> harvestSpeedCache = new HashMap();

    public static void setupBlacklist() {
        if (setupBlacklistRan) {
            return;
        }
        setupBlacklistRan = true;
        try {
            Util.setupAxeBlacklist();
        }
        catch (Exception ex) {
            System.out.println("[Tree Harvester] Something went wrong setting up the axe blacklist file.");
        }
    }

    public static void onWorldLoad(class_3218 level) {
        processleaves.put((class_1937)level, new CopyOnWriteArrayList());
    }

    public static void onWorldTick(class_3218 level) {
        if (processleaves.get(level).size() == 0) {
            return;
        }
        block0: for (List<class_2338> leaves : processleaves.get(level)) {
            class_2338 lasttr = null;
            int size = leaves.size();
            if (size > 0) {
                for (int i = 0; i < ConfigHandler.amountOfLeavesBrokenPerTick && !leaves.isEmpty(); ++i) {
                    class_2338 tr = leaves.get(0);
                    BlockFunctions.dropBlock((class_1937)level, (class_2338)tr);
                    leaves.remove(0);
                    lasttr = tr.method_10062();
                }
            }
            if (leaves.size() != 0) continue;
            processleaves.get(level).remove(leaves);
            if (lasttr == null || !ConfigHandler.replaceSaplingOnTreeHarvest || Util.lowerlogs.size() <= 0) continue;
            class_2338 lowerlasttrpos = new class_2338(lasttr.method_10263(), 1, lasttr.method_10260());
            for (Pair<class_2338, CopyOnWriteArrayList<class_2338>> pair : Util.lowerlogs) {
                class_2338 breakpos = (class_2338)pair.getFirst();
                if (!BlockPosFunctions.withinDistance((class_2338)lowerlasttrpos, (class_2338)new class_2338(breakpos.method_10263(), 1, breakpos.method_10260()), (int)5).booleanValue()) continue;
                Util.replaceSapling((class_1937)level, breakpos, (CopyOnWriteArrayList)pair.getSecond(), 1, null);
                Util.lowerlogs.remove(pair);
                continue block0;
            }
        }
    }

    public static boolean onTreeHarvest(class_1937 level, class_1657 player, class_2338 bpos, class_2680 state, class_2586 blockEntity) {
        int logcount;
        if (level.field_9236) {
            return true;
        }
        class_2248 block = level.method_8320(bpos).method_26204();
        if (!CompareBlockFunctions.isTreeLog((class_2248)block) && !Util.isGiantMushroomStemBlock(block)) {
            return true;
        }
        if (ConfigHandler.treeHarvestWithoutSneak ? player.method_5715() : !player.method_5715()) {
            return true;
        }
        class_1799 hand = player.method_5998(class_1268.field_5808);
        class_1792 handitem = hand.method_7909();
        if (ConfigHandler.mustHoldAxeForTreeHarvest) {
            if (!Services.TOOLFUNCTIONS.isAxe(hand)) {
                return true;
            }
            if (!Util.allowedAxes.contains(handitem)) {
                return true;
            }
        }
        if (ConfigHandler.automaticallyFindBottomBlock) {
            class_2338 temppos = bpos.method_10062();
            while (level.method_8320(temppos.method_10074()).method_26204().equals(block)) {
                temppos = temppos.method_10074().method_10062();
            }
            for (class_2338 belowpos : class_2338.method_10094((int)(temppos.method_10263() - 1), (int)(temppos.method_10264() - 1), (int)(temppos.method_10260() - 1), (int)(temppos.method_10263() + 1), (int)(temppos.method_10264() - 1), (int)(temppos.method_10260() + 1))) {
                if (!level.method_8320(belowpos).method_26204().equals(block)) continue;
                temppos = belowpos.method_10062();
                while (level.method_8320(temppos.method_10074()).method_26204().equals(block)) {
                    temppos = temppos.method_10074().method_10062();
                }
                break block1;
            }
            bpos = temppos.method_10062();
        }
        if ((logcount = Util.isTreeAndReturnLogAmount(level, bpos)) < 0) {
            return true;
        }
        int durabilitylosecount = (int)Math.ceil(1.0 / ConfigHandler.loseDurabilityModifier);
        int durabilitystartcount = -1;
        class_3222 serverPlayer = (class_3222)player;
        class_2338 highestlog = bpos.method_10062();
        List<class_2338> logstobreak = Util.getAllLogsToBreak(level, bpos, logcount, block);
        for (class_2338 logpos : logstobreak) {
            if (logpos.method_10264() > highestlog.method_10264()) {
                highestlog = logpos.method_10062();
            }
            class_2680 logstate = level.method_8320(logpos);
            class_2248 log = logstate.method_26204();
            BlockFunctions.dropBlock((class_1937)level, (class_2338)logpos);
            if (player.method_7337()) continue;
            if (ConfigHandler.loseDurabilityPerHarvestedLog) {
                if (durabilitystartcount == -1) {
                    durabilitystartcount = durabilitylosecount;
                    ItemFunctions.itemHurtBreakAndEvent((class_1799)hand, (class_3222)serverPlayer, (class_1268)class_1268.field_5808, (int)1);
                } else if (--durabilitylosecount == 0) {
                    ItemFunctions.itemHurtBreakAndEvent((class_1799)hand, (class_3222)serverPlayer, (class_1268)class_1268.field_5808, (int)1);
                    durabilitylosecount = durabilitystartcount;
                }
            }
            if (!ConfigHandler.increaseExhaustionPerHarvestedLog) continue;
            player.method_7322(0.025f * (float)ConfigHandler.increaseExhaustionModifier);
        }
        if (logstobreak.size() == 0) {
            return true;
        }
        if (ConfigHandler.enableFastLeafDecay && !ConfigHandler.instantBreakLeavesAround) {
            ArrayList<class_2338> logs = new ArrayList<class_2338>();
            ArrayList<class_2338> leaves = new ArrayList<class_2338>();
            for (class_2338 next : class_2338.method_10094((int)(bpos.method_10263() - 8), (int)bpos.method_10264(), (int)(bpos.method_10260() - 8), (int)(bpos.method_10263() + 8), (int)Util.highestleaf.get(bpos), (int)(bpos.method_10260() + 8))) {
                class_2248 nextblock = level.method_8320(next).method_26204();
                if (!CompareBlockFunctions.isTreeLog((class_2248)nextblock) && !Util.isGiantMushroomStemBlock(nextblock) || !nextblock.equals(block)) continue;
                logs.add(next.method_10062());
            }
            Pair<Integer, Integer> hv = Util.getHorizontalAndVerticalValue(level, bpos, block, logcount);
            int h = (Integer)hv.getFirst();
            CopyOnWriteArrayList<class_2338> leftoverleaves = new CopyOnWriteArrayList<class_2338>();
            class_2248 leafblock = level.method_8320(highestlog.method_10084()).method_26204();
            for (class_2338 next : class_2338.method_10094((int)(bpos.method_10263() - h), (int)bpos.method_10264(), (int)(bpos.method_10260() - h), (int)(bpos.method_10263() + h), (int)Util.highestleaf.get(bpos), (int)(bpos.method_10260() + h))) {
                class_2248 nextblock = level.method_8320(next).method_26204();
                if (!leafblock.equals(nextblock) && (!ConfigHandler.enableNetherTrees || !nextblock.equals(class_2246.field_22122)) || !CompareBlockFunctions.isTreeLeaf((class_2248)nextblock, (boolean)ConfigHandler.enableNetherTrees) && !Util.isGiantMushroomLeafBlock(nextblock)) continue;
                boolean logclose = false;
                for (class_2338 log : logs) {
                    double distance = log.method_10262((class_2382)next);
                    if (!BlockPosFunctions.withinDistance((class_2338)log, (class_2338)next, (int)3).booleanValue()) continue;
                    logclose = true;
                    break;
                }
                if (!logclose) {
                    leaves.add(next.method_10062());
                    continue;
                }
                leftoverleaves.add(next.method_10062());
            }
            for (class_2338 leftoverleaf : leftoverleaves) {
                if (leftoverleaves.isEmpty()) break;
                Pair<Boolean, List<class_2338>> connectedpair = Util.isConnectedToLogs(level, leftoverleaf);
                if (((Boolean)connectedpair.getFirst()).booleanValue()) {
                    for (class_2338 connectedpos : (List)connectedpair.getSecond()) {
                        leftoverleaves.remove(connectedpos);
                    }
                    continue;
                }
                for (class_2338 connectedpos : (List)connectedpair.getSecond()) {
                    if (!leaves.contains(connectedpos)) {
                        leaves.add(connectedpos.method_10062());
                    }
                    leftoverleaves.remove(connectedpos);
                }
            }
            Collections.shuffle(leaves);
            processleaves.get(level).add(leaves);
            Util.highestleaf.remove(bpos);
            if (ConfigHandler.increaseHarvestingTimePerLog) {
                Pair keypair = new Pair((Object)level, (Object)bpos);
                harvestSpeedCache.remove(keypair);
            }
        }
        return false;
    }

    public static float onHarvestBreakSpeed(class_1937 level, class_1657 player, float digSpeed, class_2680 state) {
        if (!ConfigHandler.increaseHarvestingTimePerLog) {
            return digSpeed;
        }
        class_2248 block = state.method_26204();
        if (!CompareBlockFunctions.isTreeLog((class_2248)block) && !Util.isGiantMushroomStemBlock(block)) {
            return digSpeed;
        }
        if (ConfigHandler.treeHarvestWithoutSneak ? player.method_5715() : !player.method_5715()) {
            return digSpeed;
        }
        class_1799 hand = player.method_5998(class_1268.field_5808);
        class_1792 handitem = hand.method_7909();
        if (ConfigHandler.mustHoldAxeForTreeHarvest) {
            if (!Services.TOOLFUNCTIONS.isAxe(hand)) {
                return digSpeed;
            }
            if (!Util.allowedAxes.contains(handitem)) {
                return digSpeed;
            }
        }
        int logcount = -1;
        Date now = new Date();
        Pair keypair = new Pair((Object)level, (Object)player);
        if (harvestSpeedCache.containsKey(keypair)) {
            Pair<Date, Integer> valuepair = harvestSpeedCache.get(keypair);
            long ms = now.getTime() - ((Date)valuepair.getFirst()).getTime();
            if (ms < 1000L) {
                logcount = (Integer)valuepair.getSecond();
            } else {
                harvestSpeedCache.remove(keypair);
            }
        }
        class_2338 bpos = null;
        class_239 hitResult = player.method_5745(20.0, 0.0f, false);
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            bpos = ((class_3965)hitResult).method_17777();
        }
        if (bpos == null) {
            return digSpeed;
        }
        if (logcount < 0) {
            if (Util.isTreeAndReturnLogAmount(level, bpos) < 0) {
                return digSpeed;
            }
            logcount = BlockPosFunctions.getBlocksNextToEachOtherMaterial((class_1937)level, (class_2338)bpos, Arrays.asList(class_3614.field_15932), (int)30).size();
            if (logcount <= 0) {
                return digSpeed;
            }
            harvestSpeedCache.put((Pair<class_1937, class_1657>)keypair, (Pair<Date, Integer>)new Pair((Object)now, (Object)logcount));
        }
        return digSpeed / (1.0f + (float)logcount * (float)ConfigHandler.increasedHarvestingTimePerLogModifier);
    }
}

