/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.types;

import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class PipeType<T> {
    public abstract String getKey();

    public abstract void tick(PipeLogicTileEntity var1);

    public abstract int getRate(@Nullable Upgrade var1);

    public abstract boolean canInsert(BlockEntity var1, Direction var2);

    public abstract Filter<T> createFilter();

    public abstract String getTranslationKey();

    public abstract ItemStack getIcon();

    public abstract Component getTransferText(@Nullable Upgrade var1);

    public boolean hasFilter() {
        return true;
    }

    public UpgradeTileEntity.Distribution getDefaultDistribution() {
        return UpgradeTileEntity.Distribution.ROUND_ROBIN;
    }

    public UpgradeTileEntity.RedstoneMode getDefaultRedstoneMode() {
        return UpgradeTileEntity.RedstoneMode.IGNORED;
    }

    public UpgradeTileEntity.FilterMode getDefaultFilterMode() {
        return UpgradeTileEntity.FilterMode.WHITELIST;
    }

    public int getRate(PipeLogicTileEntity tileEntity, Direction direction) {
        return this.getRate(tileEntity.getUpgrade(direction));
    }

    public boolean matchesConnection(PipeTileEntity.Connection connection, Filter<T> filter) {
        if (filter.getDestination() == null) {
            return true;
        }
        return filter.getDestination().equals(new DirectionalPosition(connection.getPos(), connection.getDirection()));
    }

    public boolean deepExactCompare(Tag meta, Tag item) {
        if (meta instanceof CompoundTag) {
            if (!(item instanceof CompoundTag)) {
                return false;
            }
            CompoundTag c = (CompoundTag)meta;
            CompoundTag i = (CompoundTag)item;
            HashSet allKeys = new HashSet();
            allKeys.addAll(c.m_128431_());
            allKeys.addAll(i.m_128431_());
            for (String key : allKeys) {
                if (c.m_128441_(key)) {
                    if (i.m_128441_(key)) {
                        Tag nbt = c.m_128423_(key);
                        if (this.deepExactCompare(nbt, i.m_128423_(key))) continue;
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return true;
        }
        if (meta instanceof ListTag) {
            ListTag l = (ListTag)meta;
            if (!(item instanceof ListTag)) {
                return false;
            }
            ListTag il = (ListTag)item;
            if (!l.stream().allMatch(inbt -> il.stream().anyMatch(inbt1 -> this.deepExactCompare((Tag)inbt, (Tag)inbt1)))) {
                return false;
            }
            return il.stream().allMatch(inbt -> l.stream().anyMatch(inbt1 -> this.deepExactCompare((Tag)inbt, (Tag)inbt1)));
        }
        return meta != null && meta.equals(item);
    }

    public boolean deepFuzzyCompare(Tag meta, Tag item) {
        if (meta instanceof CompoundTag) {
            if (!(item instanceof CompoundTag)) {
                return false;
            }
            CompoundTag c = (CompoundTag)meta;
            CompoundTag i = (CompoundTag)item;
            for (String key : c.m_128431_()) {
                Tag nbt;
                if (i.m_128425_(key, (int)(nbt = c.m_128423_(key)).m_7060_())) {
                    if (this.deepFuzzyCompare(nbt, i.m_128423_(key))) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        if (meta instanceof ListTag) {
            ListTag l = (ListTag)meta;
            if (!(item instanceof ListTag)) {
                return false;
            }
            ListTag il = (ListTag)item;
            return l.stream().allMatch(inbt -> il.stream().anyMatch(inbt1 -> this.deepFuzzyCompare((Tag)inbt, (Tag)inbt1)));
        }
        return meta != null && meta.equals(item);
    }

    public static int getConnectionsNotFullCount(boolean[] connections) {
        int count = 0;
        for (boolean connection : connections) {
            if (connection) continue;
            ++count;
        }
        return count;
    }
}

