/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.types;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.GasFilter;
import de.maxhenkel.pipez.Main;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.ModBlocks;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.capabilities.ModCapabilities;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.providers.IGasProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GasPipeType
extends PipeType<Gas> {
    public static final GasPipeType INSTANCE = new GasPipeType();

    @Override
    public String getKey() {
        return "Gas";
    }

    @Override
    public boolean canInsert(BlockEntity tileEntity, Direction direction) {
        return tileEntity.getCapability(ModCapabilities.GAS_HANDLER_CAPABILITY, direction).isPresent();
    }

    @Override
    public Filter<Gas> createFilter() {
        return new GasFilter();
    }

    @Override
    public String getTranslationKey() {
        return "tooltip.pipez.gas";
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)ModBlocks.GAS_PIPE.get());
    }

    @Override
    public Component getTransferText(@Nullable Upgrade upgrade) {
        return Component.m_237110_((String)"tooltip.pipez.rate.gas", (Object[])new Object[]{this.getRate(upgrade)});
    }

    @Override
    public void tick(PipeLogicTileEntity tileEntity) {
        for (Direction side : Direction.values()) {
            IGasHandler gasHandler;
            if (!tileEntity.isExtracting(side) || !tileEntity.shouldWork(side, this) || (gasHandler = this.getGasHandler(tileEntity, tileEntity.m_58899_().m_121945_(side), side.m_122424_())) == null) continue;
            List<PipeTileEntity.Connection> connections = tileEntity.getSortedConnections(side, this);
            if (tileEntity.getDistribution(side, this).equals(UpgradeTileEntity.Distribution.ROUND_ROBIN)) {
                this.insertEqually(tileEntity, side, connections, gasHandler);
                continue;
            }
            this.insertOrdered(tileEntity, side, connections, gasHandler);
        }
    }

    protected void insertEqually(PipeLogicTileEntity tileEntity, Direction side, List<PipeTileEntity.Connection> connections, IGasHandler gasHandler) {
        long completeAmount;
        if (connections.isEmpty()) {
            return;
        }
        long mbToTransfer = completeAmount = (long)this.getRate(tileEntity, side);
        boolean[] connectionsFull = new boolean[connections.size()];
        int p = tileEntity.getRoundRobinIndex(side, this) % connections.size();
        while (mbToTransfer > 0L && this.hasNotInserted(connectionsFull)) {
            PipeTileEntity.Connection connection = connections.get(p);
            IGasHandler destination = this.getGasHandler(tileEntity, connection.getPos(), connection.getDirection());
            boolean hasInserted = false;
            if (destination != null && !connectionsFull[p]) {
                for (int j = 0; j < gasHandler.getTanks(); ++j) {
                    GasStack stack;
                    GasStack gasInTank = (GasStack)gasHandler.getChemicalInTank(j);
                    GasStack simulatedExtract = (GasStack)gasHandler.extractChemical((ChemicalStack)new GasStack((IGasProvider)gasInTank.getType(), Math.min(Math.max(completeAmount / (long)GasPipeType.getConnectionsNotFullCount(connectionsFull), 1L), mbToTransfer)), Action.SIMULATE);
                    if (simulatedExtract.isEmpty() || this.canInsert(connection, simulatedExtract, tileEntity.getFilters(side, this)) == tileEntity.getFilterMode(side, this).equals(UpgradeTileEntity.FilterMode.BLACKLIST) || (stack = this.transfer(gasHandler, destination, simulatedExtract)).getAmount() <= 0L) continue;
                    mbToTransfer -= stack.getAmount();
                    hasInserted = true;
                    break;
                }
            }
            if (!hasInserted) {
                connectionsFull[p] = true;
            }
            p = (p + 1) % connections.size();
        }
        tileEntity.setRoundRobinIndex(side, this, p);
    }

    protected void insertOrdered(PipeLogicTileEntity tileEntity, Direction side, List<PipeTileEntity.Connection> connections, IGasHandler gasHandler) {
        long mbToTransfer = this.getRate(tileEntity, side);
        block0: for (PipeTileEntity.Connection connection : connections) {
            IGasHandler destination = this.getGasHandler(tileEntity, connection.getPos(), connection.getDirection());
            if (destination == null) continue;
            for (int i = 0; i < gasHandler.getTanks(); ++i) {
                if (mbToTransfer <= 0L) break block0;
                GasStack gasInTank = (GasStack)gasHandler.getChemicalInTank(i);
                GasStack simulatedExtract = (GasStack)gasHandler.extractChemical((ChemicalStack)new GasStack((IGasProvider)gasInTank.getType(), mbToTransfer), Action.SIMULATE);
                if (simulatedExtract.isEmpty() || this.canInsert(connection, simulatedExtract, tileEntity.getFilters(side, this)) == tileEntity.getFilterMode(side, this).equals(UpgradeTileEntity.FilterMode.BLACKLIST)) continue;
                GasStack stack = this.transfer(gasHandler, destination, simulatedExtract);
                mbToTransfer -= stack.getAmount();
            }
        }
    }

    private GasStack transfer(IGasHandler source, IGasHandler destination, GasStack transfer) {
        GasStack extracted = (GasStack)source.extractChemical((ChemicalStack)transfer, Action.SIMULATE);
        GasStack gasStack = (GasStack)destination.insertChemical((ChemicalStack)extracted, Action.EXECUTE);
        return (GasStack)source.extractChemical((ChemicalStack)new GasStack((IGasProvider)extracted.getType(), extracted.getAmount() - gasStack.getAmount()), Action.EXECUTE);
    }

    private boolean canInsert(PipeTileEntity.Connection connection, GasStack stack, List<Filter<?>> filters) {
        for (Filter filter2 : filters.stream().map(filter -> filter).filter(Filter::isInvert).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList())) {
            if (!this.matches(filter2, stack)) continue;
            return false;
        }
        List collect = filters.stream().map(filter -> filter).filter(f -> !f.isInvert()).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return true;
        }
        for (Filter filter3 : collect) {
            if (!this.matches(filter3, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(Filter<Gas> filter, GasStack stack) {
        return filter.getTag() == null || filter.getTag().contains((Gas)stack.getType());
    }

    private boolean hasNotInserted(boolean[] inventoriesFull) {
        for (boolean b : inventoriesFull) {
            if (b) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private IGasHandler getGasHandler(PipeLogicTileEntity tileEntity, BlockPos pos, Direction direction) {
        BlockEntity te = tileEntity.m_58904_().m_7702_(pos);
        if (te == null) {
            return null;
        }
        return (IGasHandler)te.getCapability(ModCapabilities.GAS_HANDLER_CAPABILITY, direction).orElse(null);
    }

    @Override
    public int getRate(@Nullable Upgrade upgrade) {
        if (upgrade == null) {
            return (Integer)Main.SERVER_CONFIG.gasPipeAmount.get();
        }
        switch (upgrade) {
            case BASIC: {
                return (Integer)Main.SERVER_CONFIG.gasPipeAmountBasic.get();
            }
            case IMPROVED: {
                return (Integer)Main.SERVER_CONFIG.gasPipeAmountImproved.get();
            }
            case ADVANCED: {
                return (Integer)Main.SERVER_CONFIG.gasPipeAmountAdvanced.get();
            }
            case ULTIMATE: {
                return (Integer)Main.SERVER_CONFIG.gasPipeAmountUltimate.get();
            }
        }
        return Integer.MAX_VALUE;
    }
}

