/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFluffBlocks;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class StonecuttingProvider
extends BotaniaRecipeProvider {
    public StonecuttingProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public void registerRecipes(Consumer<FinishedRecipe> consumer) {
        for (String variant : LibBlockNames.METAMORPHIC_VARIANTS) {
            this.registerForMetamorphic(variant, consumer);
        }
        for (String color : LibBlockNames.PAVEMENT_VARIANTS) {
            this.registerForPavement(color, consumer);
        }
        for (String variant : LibBlockNames.QUARTZ_VARIANTS) {
            this.registerForQuartz(variant, consumer);
        }
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.shimmerrock, (ItemLike)BotaniaFluffBlocks.shimmerrockSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.shimmerrock, (ItemLike)BotaniaFluffBlocks.shimmerrockStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaFluffBlocks.livingrockPolishedSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaFluffBlocks.livingrockPolishedStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaFluffBlocks.livingrockPolishedWall));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaFluffBlocks.livingrockSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaFluffBlocks.livingrockStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaFluffBlocks.livingrockWall));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockBrick));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaFluffBlocks.livingrockBrickSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaFluffBlocks.livingrockBrickStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaFluffBlocks.livingrockBrickWall));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockBrickChiseled));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaFluffBlocks.livingrockPolishedSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaFluffBlocks.livingrockPolishedStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaFluffBlocks.livingrockPolishedWall));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockBrick));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaFluffBlocks.livingrockBrickSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaFluffBlocks.livingrockBrickStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaFluffBlocks.livingrockBrickWall));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockBrickChiseled));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockBrick, (ItemLike)BotaniaFluffBlocks.livingrockBrickSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockBrick, (ItemLike)BotaniaFluffBlocks.livingrockBrickStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockBrick, (ItemLike)BotaniaFluffBlocks.livingrockBrickWall));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockBrick, (ItemLike)BotaniaBlocks.livingrockBrickChiseled));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockBrickMossy, (ItemLike)BotaniaFluffBlocks.livingrockBrickMossySlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockBrickMossy, (ItemLike)BotaniaFluffBlocks.livingrockBrickMossyStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.livingrockBrickMossy, (ItemLike)BotaniaFluffBlocks.livingrockBrickMossyWall));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaBrick));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaBrickSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaBrickStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaBrickWall));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBrick, (ItemLike)BotaniaBlocks.corporeaBrickSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBrick, (ItemLike)BotaniaBlocks.corporeaBrickStairs));
        consumer.accept(this.stonecutting((ItemLike)BotaniaBlocks.corporeaBrick, (ItemLike)BotaniaBlocks.corporeaBrickWall));
        List allAzulejos = IntStream.range(0, 16).mapToObj(i -> "azulejo_" + i).map(ResourceLocationHelper::prefix).map(arg_0 -> ((DefaultedRegistry)Registry.f_122827_).m_6612_(arg_0)).map(Optional::get).collect(Collectors.toList());
        for (Item azulejo : allAzulejos) {
            consumer.accept(this.anyToAnyStonecutting(allAzulejos, (ItemLike)azulejo));
        }
    }

    private void registerForQuartz(String variant, Consumer<FinishedRecipe> consumer) {
        Block base = (Block)Registry.f_122824_.m_6612_(this.prefix(variant)).get();
        Block slab = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_slab")).get();
        Block stairs = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_stairs")).get();
        Block chiseled = (Block)Registry.f_122824_.m_6612_(this.prefix("chiseled_" + variant)).get();
        Block pillar = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_pillar")).get();
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)slab, 2));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)stairs));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)chiseled));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)pillar));
    }

    private void registerForPavement(String color, Consumer<FinishedRecipe> consumer) {
        Block base = (Block)Registry.f_122824_.m_6612_(this.prefix(color + "_pavement")).get();
        Block slab = (Block)Registry.f_122824_.m_6612_(this.prefix(color + "_pavement_slab")).get();
        Block stair = (Block)Registry.f_122824_.m_6612_(this.prefix(color + "_pavement_stairs")).get();
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)slab, 2));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)stair));
    }

    private void registerForMetamorphic(String variant, Consumer<FinishedRecipe> consumer) {
        Block base = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_stone")).get();
        Block slab = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_stone_slab")).get();
        Block stair = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_stone_stairs")).get();
        Block wall = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_stone_wall")).get();
        Block brick = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_bricks")).get();
        Block brickSlab = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_bricks_slab")).get();
        Block brickStair = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_bricks_stairs")).get();
        Block brickWall = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_bricks_wall")).get();
        Block chiseledBrick = (Block)Registry.f_122824_.m_6612_(this.prefix("chiseled_metamorphic_" + variant + "_bricks")).get();
        Block cobble = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_cobblestone")).get();
        Block cobbleSlab = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_cobblestone_slab")).get();
        Block cobbleStair = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_cobblestone_stairs")).get();
        Block cobbleWall = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_cobblestone_wall")).get();
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)slab, 2));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)stair));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)wall));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)brick));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)brickSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)brickStair));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)brickWall));
        consumer.accept(this.stonecutting((ItemLike)base, (ItemLike)chiseledBrick));
        consumer.accept(this.stonecutting((ItemLike)brick, (ItemLike)brickSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)brick, (ItemLike)brickStair));
        consumer.accept(this.stonecutting((ItemLike)brick, (ItemLike)brickWall));
        consumer.accept(this.stonecutting((ItemLike)brick, (ItemLike)chiseledBrick));
        consumer.accept(this.stonecutting((ItemLike)cobble, (ItemLike)cobbleSlab, 2));
        consumer.accept(this.stonecutting((ItemLike)cobble, (ItemLike)cobbleStair));
        consumer.accept(this.stonecutting((ItemLike)cobble, (ItemLike)cobbleWall));
    }

    @NotNull
    public String m_6055_() {
        return "Botania stonecutting recipes";
    }

    protected ResourceLocation idFor(ItemLike a, ItemLike b) {
        ResourceLocation aId = Registry.f_122827_.m_7981_((Object)a.m_5456_());
        ResourceLocation bId = Registry.f_122827_.m_7981_((Object)b.m_5456_());
        return this.prefix("stonecutting/" + aId.m_135815_() + "_to_" + bId.m_135815_());
    }

    protected FinishedRecipe stonecutting(ItemLike input, ItemLike output) {
        return this.stonecutting(input, output, 1);
    }

    protected FinishedRecipe stonecutting(ItemLike input, ItemLike output, int count) {
        return new Result(this.idFor(input, output), RecipeSerializer.f_44095_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), output.m_5456_(), count);
    }

    protected FinishedRecipe anyToAnyStonecutting(List<? extends ItemLike> inputs, ItemLike output) {
        Ingredient input = Ingredient.m_43929_((ItemLike[])((ItemLike[])inputs.stream().filter(obj -> output != obj).toArray(ItemLike[]::new)));
        return new Result(this.prefix("stonecutting/" + Registry.f_122827_.m_7981_((Object)output.m_5456_()).m_135815_()), RecipeSerializer.f_44095_, input, output.m_5456_(), 1);
    }

    protected ResourceLocation prefix(String path) {
        return ResourceLocationHelper.prefix(path);
    }

    public static class Result
    extends SingleItemRecipeBuilder.Result {
        public Result(ResourceLocation id, RecipeSerializer<?> serializer, Ingredient input, Item result, int count) {
            super(id, serializer, "", input, result, count, null, null);
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

