/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.BotaniaFluffBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class OrechidProvider
extends BotaniaRecipeProvider {
    public OrechidProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    protected void registerRecipes(Consumer<FinishedRecipe> consumer) {
        consumer.accept(this.stone(Blocks.f_49997_, 67415));
        consumer.accept(this.stone(Blocks.f_49996_, 29371));
        consumer.accept(this.stone(Blocks.f_50173_, 7654));
        consumer.accept(this.stone(Blocks.f_152505_, 7000));
        consumer.accept(this.stone(Blocks.f_49995_, 2647));
        consumer.accept(this.stone(Blocks.f_50264_, 1239));
        consumer.accept(this.stone(Blocks.f_50059_, 1079));
        consumer.accept(this.stone(Blocks.f_50089_, 883));
        consumer.accept(this.deepslate(Blocks.f_152469_, 75));
        consumer.accept(this.deepslate(Blocks.f_152468_, 250));
        consumer.accept(this.deepslate(Blocks.f_152473_, 150));
        consumer.accept(this.deepslate(Blocks.f_152506_, 75));
        consumer.accept(this.deepslate(Blocks.f_152467_, 125));
        consumer.accept(this.deepslate(Blocks.f_152479_, 50));
        consumer.accept(this.deepslate(Blocks.f_152472_, 175));
        consumer.accept(this.deepslate(Blocks.f_152474_, 100));
        consumer.accept(this.netherrack(Blocks.f_50331_, 19600));
        consumer.accept(this.netherrack(Blocks.f_49998_, 3635));
        consumer.accept(this.netherrack(Blocks.f_50722_, 148));
        consumer.accept(this.biomeStone(BotaniaFluffBlocks.biomeStoneForest, BotaniaTags.Biomes.MARIMORPHOSIS_FOREST_BONUS));
        consumer.accept(this.biomeStone(BotaniaFluffBlocks.biomeStonePlains, BotaniaTags.Biomes.MARIMORPHOSIS_PLAINS_BONUS));
        consumer.accept(this.biomeStone(BotaniaFluffBlocks.biomeStoneMountain, BotaniaTags.Biomes.MARIMORPHOSIS_MOUNTAIN_BONUS));
        consumer.accept(this.biomeStone(BotaniaFluffBlocks.biomeStoneFungal, BotaniaTags.Biomes.MARIMORPHOSIS_FUNGAL_BONUS));
        consumer.accept(this.biomeStone(BotaniaFluffBlocks.biomeStoneSwamp, BotaniaTags.Biomes.MARIMORPHOSIS_SWAMP_BONUS));
        consumer.accept(this.biomeStone(BotaniaFluffBlocks.biomeStoneDesert, BotaniaTags.Biomes.MARIMORPHOSIS_DESERT_BONUS));
        consumer.accept(this.biomeStone(BotaniaFluffBlocks.biomeStoneTaiga, BotaniaTags.Biomes.MARIMORPHOSIS_TAIGA_BONUS));
        consumer.accept(this.biomeStone(BotaniaFluffBlocks.biomeStoneMesa, BotaniaTags.Biomes.MARIMORPHOSIS_MESA_BONUS));
    }

    protected ResourceLocation orechidId(Block b) {
        return ResourceLocationHelper.prefix("orechid/" + Registry.f_122824_.m_7981_((Object)b).m_135815_());
    }

    protected ResourceLocation ignemId(Block b) {
        return ResourceLocationHelper.prefix("orechid_ignem/" + Registry.f_122824_.m_7981_((Object)b).m_135815_());
    }

    protected ResourceLocation marimorphosisId(Block b) {
        return ResourceLocationHelper.prefix("marimorphosis/" + Registry.f_122824_.m_7981_((Object)b).m_135815_());
    }

    protected Result stone(Block output, int weight) {
        return new Result(BotaniaRecipeTypes.ORECHID_SERIALIZER, this.orechidId(output), OrechidProvider.forBlock(Blocks.f_50069_), OrechidProvider.forBlock(output), weight);
    }

    protected Result deepslate(Block output, int weight) {
        return new Result(BotaniaRecipeTypes.ORECHID_SERIALIZER, this.orechidId(output), OrechidProvider.forBlock(Blocks.f_152550_), OrechidProvider.forBlock(output), weight);
    }

    protected Result netherrack(Block output, int weight) {
        return new Result(BotaniaRecipeTypes.ORECHID_IGNEM_SERIALIZER, this.ignemId(output), OrechidProvider.forBlock(Blocks.f_50134_), OrechidProvider.forBlock(output), weight);
    }

    protected Result biomeStone(Block output, TagKey<Biome> biome) {
        return new BiomeResult(BotaniaRecipeTypes.MARIMORPHOSIS_SERIALIZER, this.marimorphosisId(output), OrechidProvider.forTag(BotaniaTags.Blocks.MARIMORPHOSIS_CONVERTABLE), OrechidProvider.forBlock(output), 1, 11, biome);
    }

    protected static StateIngredient forBlock(Block block) {
        return StateIngredientHelper.of(block);
    }

    protected static StateIngredient forTag(TagKey<Block> tag) {
        return StateIngredientHelper.of(tag);
    }

    public String m_6055_() {
        return "Botania Orechid and Marimorphosis recipes";
    }

    protected static class Result
    implements FinishedRecipe {
        private final RecipeSerializer<? extends OrechidRecipe> type;
        private final ResourceLocation id;
        private final StateIngredient input;
        private final StateIngredient output;
        private final int weight;

        public Result(RecipeSerializer<? extends OrechidRecipe> type, ResourceLocation id, StateIngredient input, StateIngredient output, int weight) {
            this.type = type;
            this.id = id;
            this.input = input;
            this.output = output;
            this.weight = weight;
        }

        public void m_7917_(JsonObject json) {
            json.add("input", (JsonElement)this.input.serialize());
            json.add("output", (JsonElement)this.output.serialize());
            json.addProperty("weight", (Number)this.weight);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.type;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    protected static class BiomeResult
    extends Result {
        private final int bonusWeight;
        private final TagKey<Biome> biome;

        public BiomeResult(RecipeSerializer<? extends OrechidRecipe> type, ResourceLocation id, StateIngredient input, StateIngredient output, int weight, int bonusWeight, TagKey<Biome> biome) {
            super(type, id, input, output, weight);
            this.bonusWeight = bonusWeight;
            this.biome = biome;
        }

        @Override
        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            json.addProperty("biome_bonus_tag", this.biome.f_203868_().toString());
            json.addProperty("biome_bonus", (Number)this.bonusWeight);
        }
    }
}

