/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.blockstates.VariantProperty;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.AlfheimPortalState;
import vazkii.botania.api.state.enums.CraftyCratePattern;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaDoubleFlowerBlock;
import vazkii.botania.common.block.BotaniaFlowerBlock;
import vazkii.botania.common.block.BotaniaFluffBlocks;
import vazkii.botania.common.block.BotaniaGrassBlock;
import vazkii.botania.common.block.PetalApothecaryBlock;
import vazkii.botania.common.block.decor.BotaniaMushroomBlock;
import vazkii.botania.common.block.decor.BuriedPetalBlock;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.block.decor.FlowerMotifBlock;
import vazkii.botania.common.block.decor.PetalBlock;
import vazkii.botania.common.block.decor.panes.BotaniaPaneBlock;
import vazkii.botania.common.block.red_string.RedStringBlock;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.BlockModelGeneratorsAccessor;
import vazkii.botania.mixin.TextureSlotAccessor;
import vazkii.botania.xplat.XplatAbstractions;

public class BlockstateProvider
implements DataProvider {
    private final DataGenerator generator;
    private final List<BlockStateGenerator> blockstates = new ArrayList<BlockStateGenerator>();
    private final Map<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();
    private final BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput = this.models::put;

    public BlockstateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    @NotNull
    public String m_6055_() {
        return "Botania Blockstates and Models";
    }

    public void m_213708_(CachedOutput cache) {
        Path path;
        try {
            this.registerStatesAndModels();
        }
        catch (Exception e) {
            BotaniaAPI.LOGGER.error("Error registering states and models", (Throwable)e);
        }
        Path root = this.generator.m_123916_();
        for (BlockStateGenerator blockStateGenerator : this.blockstates) {
            ResourceLocation id = Registry.f_122824_.m_7981_((Object)blockStateGenerator.m_6968_());
            path = root.resolve("assets/" + id.m_135827_() + "/blockstates/" + id.m_135815_() + ".json");
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)((JsonElement)blockStateGenerator.get()), (Path)path);
            }
            catch (IOException ex) {
                BotaniaAPI.LOGGER.error("Error generating blockstate file for {}", (Object)id, (Object)ex);
            }
        }
        for (Map.Entry entry : this.models.entrySet()) {
            ResourceLocation modelId = (ResourceLocation)entry.getKey();
            path = root.resolve("assets/" + modelId.m_135827_() + "/models/" + modelId.m_135815_() + ".json");
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)((JsonElement)((Supplier)entry.getValue()).get()), (Path)path);
            }
            catch (IOException ex) {
                BotaniaAPI.LOGGER.error("Error generating model file {}", (Object)modelId, (Object)ex);
            }
        }
    }

    private void registerStatesAndModels() {
        Set<Block> remainingBlocks = Registry.f_122824_.m_123024_().filter(b -> "botania".equals(Registry.f_122824_.m_7981_(b).m_135827_())).collect(Collectors.toSet());
        remainingBlocks.remove(BotaniaBlocks.ghostRail);
        remainingBlocks.remove(BotaniaBlocks.solidVines);
        this.manualModel(remainingBlocks, BotaniaBlocks.cocoon);
        this.manualModel(remainingBlocks, BotaniaBlocks.corporeaCrystalCube);
        this.manualModel(remainingBlocks, BotaniaBlocks.distributor);
        this.manualModel(remainingBlocks, BotaniaBlocks.prism);
        this.manualModel(remainingBlocks, BotaniaBlocks.runeAltar);
        this.manualModel(remainingBlocks, BotaniaBlocks.spawnerClaw);
        ResourceLocation alfPortalModel = ModelTemplates.f_125692_.m_125612_(ModelLocationUtils.m_125576_((Block)BotaniaBlocks.alfPortal), TextureMapping.m_125748_((Block)BotaniaBlocks.alfPortal), this.modelOutput);
        ResourceLocation alfPortalActivatedModel = ModelTemplates.f_125692_.m_125612_(ModelLocationUtils.m_125578_((Block)BotaniaBlocks.alfPortal, (String)"_activated"), TextureMapping.m_125776_((ResourceLocation)ModelLocationUtils.m_125578_((Block)BotaniaBlocks.alfPortal, (String)"_activated")), this.modelOutput);
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)BotaniaBlocks.alfPortal).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_(BotaniaStateProperties.ALFPORTAL_STATE).m_125329_((Comparable)((Object)AlfheimPortalState.OFF), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)alfPortalModel)).m_125329_((Comparable)((Object)AlfheimPortalState.ON_X), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)alfPortalActivatedModel)).m_125329_((Comparable)((Object)AlfheimPortalState.ON_Z), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)alfPortalActivatedModel))));
        remainingBlocks.remove(BotaniaBlocks.alfPortal);
        this.singleVariantBlockState(BotaniaBlocks.bifrostPerm, ModelTemplates.f_125692_.m_125612_(ModelLocationUtils.m_125576_((Block)BotaniaBlocks.bifrostPerm), TextureMapping.m_125748_((Block)BotaniaBlocks.bifrost), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.bifrostPerm);
        this.singleVariantBlockState(BotaniaBlocks.cacophonium, ModelTemplates.f_125696_.m_125592_(BotaniaBlocks.cacophonium, new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125740_((Block)Blocks.f_50065_)).m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)BotaniaBlocks.cacophonium, (String)"_top")), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.cacophonium);
        ModelTemplate crateTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/crate")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125875_});
        ResourceLocation craftCrateBottomTex = TextureMapping.m_125753_((Block)BotaniaBlocks.craftCrate, (String)"_bottom");
        PropertyDispatch.C1 crateDispatch = PropertyDispatch.m_125294_(BotaniaStateProperties.CRATE_PATTERN);
        for (CraftyCratePattern pattern : CraftyCratePattern.values()) {
            String suffix = pattern == CraftyCratePattern.NONE ? "" : "_" + pattern.m_7912_().substring("crafty_".length());
            ResourceLocation model = crateTemplate.m_125612_(ModelLocationUtils.m_125578_((Block)BotaniaBlocks.craftCrate, (String)suffix), new TextureMapping().m_125758_(TextureSlot.f_125871_, craftCrateBottomTex).m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)BotaniaBlocks.craftCrate, (String)suffix)), this.modelOutput);
            crateDispatch = crateDispatch.m_125329_((Comparable)((Object)pattern), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model));
        }
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)BotaniaBlocks.craftCrate).m_125271_((PropertyDispatch)crateDispatch));
        remainingBlocks.remove(BotaniaBlocks.craftCrate);
        ResourceLocation corpSlabSide = ResourceLocationHelper.prefix("block/corporea_slab_side");
        ResourceLocation corpBlock = TextureMapping.m_125740_((Block)BotaniaBlocks.corporeaBlock);
        ResourceLocation corpSlabBottomModel = ModelTemplates.f_125627_.m_125592_((Block)BotaniaBlocks.corporeaSlab, new TextureMapping().m_125758_(TextureSlot.f_125871_, corpBlock).m_125758_(TextureSlot.f_125872_, corpBlock).m_125758_(TextureSlot.f_125875_, corpBlock), this.modelOutput);
        ResourceLocation corpSlabTopModel = ModelTemplates.f_125628_.m_125612_(ModelLocationUtils.m_125578_((Block)BotaniaBlocks.corporeaSlab, (String)"_top"), new TextureMapping().m_125758_(TextureSlot.f_125871_, corpBlock).m_125758_(TextureSlot.f_125872_, corpBlock).m_125758_(TextureSlot.f_125875_, corpBlock), this.modelOutput);
        ResourceLocation corpSlabDoubleModel = ModelTemplates.f_125697_.m_125612_(ResourceLocationHelper.prefix("block/corporea_double_slab"), new TextureMapping().m_125758_(TextureSlot.f_125875_, corpSlabSide).m_125758_(TextureSlot.f_125871_, corpBlock).m_125758_(TextureSlot.f_125872_, corpBlock), this.modelOutput);
        this.blockstates.add(BlockModelGeneratorsAccessor.makeSlabState((Block)BotaniaBlocks.corporeaSlab, corpSlabBottomModel, corpSlabTopModel, corpSlabDoubleModel));
        remainingBlocks.remove(BotaniaBlocks.corporeaSlab);
        this.stairsBlock(remainingBlocks, (Block)BotaniaBlocks.corporeaStairs, corpBlock, corpBlock, corpBlock);
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125259_((Block)BotaniaBlocks.elfGlass, (Variant[])((Variant[])IntStream.rangeClosed(0, 3).mapToObj(i -> {
            ResourceLocation model = ModelTemplates.f_125692_.m_125612_(ModelLocationUtils.m_125578_((Block)BotaniaBlocks.elfGlass, (String)("_" + i)), TextureMapping.m_125776_((ResourceLocation)TextureMapping.m_125753_((Block)BotaniaBlocks.elfGlass, (String)("_" + i))), this.modelOutput);
            return Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model);
        }).toArray(Variant[]::new))));
        remainingBlocks.remove(BotaniaBlocks.elfGlass);
        this.singleVariantBlockState(BotaniaBlocks.enchantedSoil, ModelTemplates.f_125697_.m_125592_(BotaniaBlocks.enchantedSoil, TextureMapping.m_125826_((Block)BotaniaBlocks.enchantedSoil).m_125758_(TextureSlot.f_125871_, TextureMapping.m_125740_((Block)Blocks.f_50493_)), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.enchantedSoil);
        ResourceLocation pumpkinModel = ModelTemplates.f_125698_.m_125592_(BotaniaBlocks.felPumpkin, new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)Blocks.f_50133_, (String)"_side")).m_125758_(TextureSlot.f_125873_, TextureMapping.m_125740_((Block)BotaniaBlocks.felPumpkin)).m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)Blocks.f_50133_, (String)"_top")), this.modelOutput);
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)BotaniaBlocks.felPumpkin, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)pumpkinModel)).m_125271_(BlockModelGeneratorsAccessor.horizontalDispatch()));
        remainingBlocks.remove(BotaniaBlocks.felPumpkin);
        ModelTemplate eightByEightTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/eightbyeight")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_, TextureSlot.f_125876_, TextureSlot.f_125877_, TextureSlot.f_125879_, TextureSlot.f_125878_});
        this.singleVariantBlockState(BotaniaBlocks.forestEye, eightByEightTemplate.m_125592_(BotaniaBlocks.forestEye, new TextureMapping().m_125758_(TextureSlot.f_125871_, TextureMapping.m_125753_((Block)BotaniaBlocks.forestEye, (String)"_bottom")).m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)BotaniaBlocks.forestEye, (String)"_top")).m_125758_(TextureSlot.f_125876_, TextureMapping.m_125753_((Block)BotaniaBlocks.forestEye, (String)"_north")).m_125758_(TextureSlot.f_125877_, TextureMapping.m_125753_((Block)BotaniaBlocks.forestEye, (String)"_south")).m_125758_(TextureSlot.f_125879_, TextureMapping.m_125753_((Block)BotaniaBlocks.forestEye, (String)"_west")).m_125758_(TextureSlot.f_125878_, TextureMapping.m_125753_((Block)BotaniaBlocks.forestEye, (String)"_east")), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.forestEye);
        ResourceLocation plateFile = ModelLocationUtils.m_125576_((Block)BotaniaBlocks.incensePlate);
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)BotaniaBlocks.incensePlate, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)plateFile)).m_125271_(BlockModelGeneratorsAccessor.horizontalDispatch()));
        remainingBlocks.remove(BotaniaBlocks.incensePlate);
        ModelTemplate fourHighBottomTopTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/four_high_bottom_top")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_, TextureSlot.f_125875_});
        this.singleVariantBlockState(BotaniaBlocks.lightLauncher, fourHighBottomTopTemplate.m_125592_(BotaniaBlocks.lightLauncher, new TextureMapping().m_125758_(TextureSlot.f_125871_, TextureMapping.m_125753_((Block)BotaniaBlocks.lightLauncher, (String)"_end")).m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)BotaniaBlocks.lightLauncher, (String)"_end")).m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)BotaniaBlocks.lightLauncher, (String)"_side")), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.lightLauncher);
        this.singleVariantBlockState(BotaniaBlocks.openCrate, crateTemplate.m_125592_(BotaniaBlocks.openCrate, new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125740_((Block)BotaniaBlocks.openCrate)).m_125758_(TextureSlot.f_125871_, TextureMapping.m_125753_((Block)BotaniaBlocks.openCrate, (String)"_bottom")), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.openCrate);
        ModelTemplate threeHighBottomTopTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/three_high_bottom_top")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_, TextureSlot.f_125875_});
        this.singleVariantBlockState(BotaniaBlocks.sparkChanger, threeHighBottomTopTemplate.m_125592_(BotaniaBlocks.sparkChanger, TextureMapping.m_125826_((Block)BotaniaBlocks.sparkChanger), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.sparkChanger);
        this.singleVariantBlockState(BotaniaBlocks.starfield, fourHighBottomTopTemplate.m_125592_(BotaniaBlocks.starfield, TextureMapping.m_125826_((Block)BotaniaBlocks.starfield), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.starfield);
        this.singleVariantBlockState(BotaniaBlocks.terraPlate, threeHighBottomTopTemplate.m_125592_(BotaniaBlocks.terraPlate, TextureMapping.m_125826_((Block)BotaniaBlocks.terraPlate), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.terraPlate);
        ModelTemplate tenByTenAllTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/tenbyten_all")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125867_});
        this.singleVariantBlockState(BotaniaBlocks.tinyPlanet, tenByTenAllTemplate.m_125592_(BotaniaBlocks.tinyPlanet, TextureMapping.m_125748_((Block)BotaniaBlocks.tinyPlanet), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.tinyPlanet);
        this.singleVariantBlockState(BotaniaBlocks.turntable, ModelTemplates.f_125697_.m_125592_(BotaniaBlocks.turntable, TextureMapping.m_125826_((Block)BotaniaBlocks.turntable), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.turntable);
        ResourceLocation[] topTexs = new ResourceLocation[6];
        ResourceLocation[] sideTexs = new ResourceLocation[6];
        ResourceLocation[] topStrippedTexs = new ResourceLocation[6];
        ResourceLocation[] sideStrippedTexs = new ResourceLocation[6];
        ResourceLocation[] sideGlimmeringTexs = new ResourceLocation[6];
        ResourceLocation[] sideGlimmeringStrippedTexs = new ResourceLocation[6];
        ResourceLocation[] logModels = new ResourceLocation[6];
        ResourceLocation[] strippedLogModels = new ResourceLocation[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            Object suffix = i2 == 0 ? "" : "_" + i2;
            sideTexs[i2] = TextureMapping.m_125753_((Block)BotaniaBlocks.dreamwoodLog, (String)suffix);
            topTexs[i2] = TextureMapping.m_125753_((Block)BotaniaBlocks.dreamwoodLog, (String)"_top");
            sideStrippedTexs[i2] = TextureMapping.m_125753_((Block)BotaniaBlocks.dreamwoodLogStripped, (String)suffix);
            topStrippedTexs[i2] = TextureMapping.m_125753_((Block)BotaniaBlocks.dreamwoodLogStripped, (String)"_top");
            sideGlimmeringTexs[i2] = TextureMapping.m_125753_((Block)BotaniaBlocks.dreamwoodLogGlimmering, (String)suffix);
            sideGlimmeringStrippedTexs[i2] = TextureMapping.m_125753_((Block)BotaniaBlocks.dreamwoodLogStrippedGlimmering, (String)suffix);
            logModels[i2] = ModelLocationUtils.m_125578_((Block)BotaniaBlocks.dreamwood, (String)suffix);
            strippedLogModels[i2] = ModelLocationUtils.m_125578_((Block)BotaniaBlocks.dreamwoodStripped, (String)suffix);
        }
        this.pillarWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodLog, topTexs, sideTexs);
        this.pillarWithVariants(remainingBlocks, BotaniaBlocks.dreamwood, sideTexs, sideTexs);
        this.pillarWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodLogStripped, topStrippedTexs, sideStrippedTexs);
        this.pillarWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodStripped, sideStrippedTexs, sideStrippedTexs);
        this.pillarWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodLogGlimmering, topTexs, sideGlimmeringTexs);
        this.pillarWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodGlimmering, sideGlimmeringTexs, sideGlimmeringTexs);
        this.pillarWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodLogStrippedGlimmering, topStrippedTexs, sideGlimmeringStrippedTexs);
        this.pillarWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodStrippedGlimmering, sideGlimmeringStrippedTexs, sideGlimmeringStrippedTexs);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.dreamwoodStairs, sideTexs, sideTexs, sideTexs);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.dreamwoodStrippedStairs, sideStrippedTexs, sideStrippedTexs, sideStrippedTexs);
        this.slabBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.dreamwoodSlab, logModels, sideTexs, sideTexs, sideTexs);
        this.slabBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.dreamwoodStrippedSlab, strippedLogModels, sideStrippedTexs, sideStrippedTexs, sideStrippedTexs);
        this.wallBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.dreamwoodWall, sideTexs);
        this.wallBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.dreamwoodStrippedWall, sideStrippedTexs);
        this.pillar(remainingBlocks, BotaniaBlocks.livingwoodLog, TextureMapping.m_125753_((Block)BotaniaBlocks.livingwoodLog, (String)"_top"), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLog));
        this.pillar(remainingBlocks, BotaniaBlocks.livingwood, TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLog), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLog));
        this.pillar(remainingBlocks, BotaniaBlocks.livingwoodLogStripped, TextureMapping.m_125753_((Block)BotaniaBlocks.livingwoodLogStripped, (String)"_top"), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogStripped));
        this.pillar(remainingBlocks, BotaniaBlocks.livingwoodStripped, TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogStripped), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogStripped));
        this.pillar(remainingBlocks, BotaniaBlocks.livingwoodLogGlimmering, TextureMapping.m_125753_((Block)BotaniaBlocks.livingwoodLog, (String)"_top"), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogGlimmering));
        this.pillar(remainingBlocks, BotaniaBlocks.livingwoodGlimmering, TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogGlimmering), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogGlimmering));
        this.pillar(remainingBlocks, BotaniaBlocks.livingwoodLogStrippedGlimmering, TextureMapping.m_125753_((Block)BotaniaBlocks.livingwoodLogStripped, (String)"_top"), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogStrippedGlimmering));
        this.pillar(remainingBlocks, BotaniaBlocks.livingwoodStrippedGlimmering, TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogStrippedGlimmering), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogStrippedGlimmering));
        this.pillarAlt(remainingBlocks, BotaniaBlocks.livingwoodFramed, TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodPatternFramed), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodFramed));
        this.pillarAlt(remainingBlocks, BotaniaBlocks.dreamwoodFramed, TextureMapping.m_125740_((Block)BotaniaBlocks.dreamwoodPatternFramed), TextureMapping.m_125740_((Block)BotaniaBlocks.dreamwoodFramed));
        this.stairsBlock(remainingBlocks, BotaniaFluffBlocks.livingwoodStairs, TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLog), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLog), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLog));
        this.stairsBlock(remainingBlocks, BotaniaFluffBlocks.livingwoodStrippedStairs, TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogStripped), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogStripped), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogStripped));
        this.slabBlock(remainingBlocks, BotaniaFluffBlocks.livingwoodSlab, ModelLocationUtils.m_125576_((Block)BotaniaBlocks.livingwood), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLog), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLog), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLog));
        this.slabBlock(remainingBlocks, BotaniaFluffBlocks.livingwoodStrippedSlab, ModelLocationUtils.m_125576_((Block)BotaniaBlocks.livingwoodStripped), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogStripped), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogStripped), TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogStripped));
        this.wallBlock(remainingBlocks, BotaniaFluffBlocks.livingwoodWall, TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLog));
        this.wallBlock(remainingBlocks, BotaniaFluffBlocks.livingwoodStrippedWall, TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogStripped));
        this.fenceBlock(BotaniaFluffBlocks.dreamwoodFence, TextureMapping.m_125740_((Block)BotaniaBlocks.dreamwoodPlanks));
        this.fenceGateBlock(BotaniaFluffBlocks.dreamwoodFenceGate, TextureMapping.m_125740_((Block)BotaniaBlocks.dreamwoodPlanks));
        this.fenceBlock(BotaniaFluffBlocks.livingwoodFence, TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodPlanks));
        this.fenceGateBlock(BotaniaFluffBlocks.livingwoodFenceGate, TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodPlanks));
        remainingBlocks.remove(BotaniaFluffBlocks.dreamwoodFence);
        remainingBlocks.remove(BotaniaFluffBlocks.dreamwoodFenceGate);
        remainingBlocks.remove(BotaniaFluffBlocks.livingwoodFence);
        remainingBlocks.remove(BotaniaFluffBlocks.livingwoodFenceGate);
        this.rotatedMirrored(remainingBlocks, BotaniaBlocks.livingrock, TextureMapping.m_125740_((Block)BotaniaBlocks.livingrock));
        ResourceLocation polishedLivingrockTexture = TextureMapping.m_125740_((Block)BotaniaBlocks.livingrockPolished);
        ResourceLocation polishedLivingrockSlabSideTexture = TextureMapping.m_125740_((Block)BotaniaFluffBlocks.livingrockPolishedSlab);
        ResourceLocation polishedLivingrockSlabDoubleModel = ModelTemplates.f_125694_.m_125612_(ModelLocationUtils.m_125578_((Block)BotaniaFluffBlocks.livingrockPolishedSlab, (String)"_double"), new TextureMapping().m_125758_(TextureSlot.f_125875_, polishedLivingrockSlabSideTexture).m_125758_(TextureSlot.f_125870_, polishedLivingrockTexture), this.modelOutput);
        this.slabBlock(remainingBlocks, BotaniaFluffBlocks.livingrockPolishedSlab, polishedLivingrockSlabDoubleModel, polishedLivingrockSlabSideTexture, polishedLivingrockTexture, polishedLivingrockTexture);
        this.particleOnly(remainingBlocks, BotaniaBlocks.animatedTorch, TextureMapping.m_125740_((Block)Blocks.f_50174_));
        this.particleOnly(remainingBlocks, BotaniaBlocks.avatar, TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLog));
        this.particleOnly(remainingBlocks, BotaniaBlocks.bellows, TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLog));
        this.particleOnly(remainingBlocks, BotaniaBlocks.brewery, TextureMapping.m_125740_((Block)BotaniaBlocks.livingrock));
        this.particleOnly(remainingBlocks, BotaniaBlocks.corporeaIndex, TextureMapping.m_125740_((Block)BotaniaBlocks.corporeaBlock));
        this.particleOnly(remainingBlocks, BotaniaBlocks.lightRelayDetector, TextureMapping.m_125740_((Block)BotaniaBlocks.lightRelayDetector));
        this.singleVariantBlockState(BotaniaBlocks.fakeAir, new ModelTemplate(Optional.empty(), Optional.empty(), new TextureSlot[0]).m_125592_(BotaniaBlocks.fakeAir, new TextureMapping(), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.fakeAir);
        this.particleOnly(remainingBlocks, BotaniaBlocks.lightRelayFork, TextureMapping.m_125740_((Block)BotaniaBlocks.lightRelayFork));
        this.particleOnly(remainingBlocks, BotaniaBlocks.gaiaHead, TextureMapping.m_125740_((Block)Blocks.f_50135_));
        this.particleOnly(remainingBlocks, BotaniaBlocks.gaiaHeadWall, TextureMapping.m_125740_((Block)Blocks.f_50135_));
        this.particleOnly(remainingBlocks, BotaniaBlocks.gaiaPylon, TextureMapping.m_125740_((Block)BotaniaBlocks.elementiumBlock));
        this.particleOnly(remainingBlocks, BotaniaBlocks.hourglass, TextureMapping.m_125740_((Block)BotaniaBlocks.manaGlass));
        this.particleOnly(remainingBlocks, BotaniaBlocks.lightRelayDefault, TextureMapping.m_125740_((Block)BotaniaBlocks.lightRelayDefault));
        this.particleOnly(remainingBlocks, BotaniaBlocks.manaFlame, new ResourceLocation("block/fire_0"));
        this.particleOnly(remainingBlocks, BotaniaBlocks.manaPylon, TextureMapping.m_125740_((Block)BotaniaBlocks.manasteelBlock));
        this.particleOnly(remainingBlocks, BotaniaBlocks.naturaPylon, TextureMapping.m_125740_((Block)BotaniaBlocks.terrasteelBlock));
        this.particleOnly(remainingBlocks, BotaniaBlocks.teruTeruBozu, TextureMapping.m_125740_((Block)Blocks.f_50041_));
        this.particleOnly(remainingBlocks, BotaniaBlocks.lightRelayToggle, TextureMapping.m_125740_((Block)BotaniaBlocks.lightRelayToggle));
        Predicate<Block> flowers = b -> XplatAbstractions.INSTANCE.isSpecialFlowerBlock((Block)b) || b instanceof BotaniaMushroomBlock || b instanceof BotaniaFlowerBlock;
        ModelTemplate crossTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/cross")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125882_});
        BlockstateProvider.takeAll(remainingBlocks, flowers).forEach(b -> this.singleVariantBlockState((Block)b, crossTemplate.m_125592_(b, TextureMapping.m_125780_((Block)b), this.modelOutput)));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof FlowerMotifBlock).forEach(b -> {
            String name = Registry.f_122824_.m_7981_(b).m_135815_().replace("_motif", "");
            this.singleVariantBlockState((Block)b, crossTemplate.m_125592_(b, new TextureMapping().m_125758_(TextureSlot.f_125882_, ResourceLocationHelper.prefix("block/" + name)), this.modelOutput));
        });
        BlockstateProvider.takeAll(remainingBlocks, BotaniaBlocks.corporeaFunnel, BotaniaBlocks.corporeaInterceptor, BotaniaBlocks.corporeaRetainer).forEach(b -> this.singleVariantBlockState((Block)b, ModelTemplates.f_125694_.m_125592_(b, TextureMapping.m_125763_((ResourceLocation)TextureMapping.m_125753_((Block)b, (String)"_side"), (ResourceLocation)TextureMapping.m_125753_((Block)b, (String)"_end")), this.modelOutput)));
        ModelTemplate drumModelTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/drum")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125872_, TextureSlot.f_125875_});
        BlockstateProvider.takeAll(remainingBlocks, BotaniaBlocks.gatheringDrum, BotaniaBlocks.canopyDrum, BotaniaBlocks.wildDrum).forEach(b -> this.singleVariantBlockState((Block)b, drumModelTemplate.m_125592_(b, new TextureMapping().m_125758_(TextureSlot.f_125872_, ResourceLocationHelper.prefix("block/drum_top")).m_125758_(TextureSlot.f_125875_, TextureMapping.m_125740_((Block)b)), this.modelOutput)));
        TextureSlot outsideSlot = TextureSlotAccessor.make("outside");
        TextureSlot coreSlot = TextureSlotAccessor.make("core");
        ModelTemplate spreaderTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125875_, TextureSlot.f_125874_, TextureSlot.f_176491_, outsideSlot});
        ModelTemplate spreaderCoreTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_core")), Optional.of("_core"), new TextureSlot[]{coreSlot});
        ModelTemplate spreaderPaddingTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_padding")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125873_, TextureSlot.f_125874_, TextureSlot.f_125875_});
        ModelTemplate spreaderScaffoldingTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_scaffolding")), Optional.of("_scaffolding"), new TextureSlot[]{TextureSlot.f_125872_, TextureSlot.f_125875_, TextureSlot.f_125871_});
        BlockstateProvider.takeAll(remainingBlocks, BotaniaBlocks.manaSpreader, BotaniaBlocks.redstoneSpreader, BotaniaBlocks.gaiaSpreader, BotaniaBlocks.elvenSpreader).forEach(b -> {
            ResourceLocation outside = b == BotaniaBlocks.redstoneSpreader || b == BotaniaBlocks.manaSpreader ? TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLog) : (b == BotaniaBlocks.elvenSpreader ? TextureMapping.m_125753_((Block)BotaniaBlocks.dreamwoodLog, (String)"_3") : TextureMapping.m_125753_((Block)b, (String)"_outside"));
            ResourceLocation inside = b == BotaniaBlocks.redstoneSpreader || b == BotaniaBlocks.manaSpreader ? TextureMapping.m_125740_((Block)BotaniaBlocks.livingwoodLogStripped) : (b == BotaniaBlocks.elvenSpreader ? TextureMapping.m_125753_((Block)BotaniaBlocks.dreamwoodLogStripped, (String)"_3") : TextureMapping.m_125753_((Block)b, (String)"_inside"));
            this.singleVariantBlockState((Block)b, spreaderTemplate.m_125592_(b, new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)b, (String)"_side")).m_125758_(TextureSlot.f_125874_, TextureMapping.m_125753_((Block)b, (String)"_back")).m_125758_(TextureSlot.f_176491_, inside).m_125758_(outsideSlot, outside), this.modelOutput));
            spreaderCoreTemplate.m_125592_(b, new TextureMapping().m_125758_(coreSlot, TextureMapping.m_125753_((Block)b, (String)"_core")), this.modelOutput);
            if (b != BotaniaBlocks.redstoneSpreader) {
                spreaderScaffoldingTemplate.m_125592_(b, new TextureMapping().m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)b, (String)"_scaffolding_top")).m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)b, (String)"_scaffolding_side")).m_125758_(TextureSlot.f_125871_, TextureMapping.m_125753_((Block)b, (String)"_scaffolding_bottom")), this.modelOutput);
            }
        });
        for (DyeColor color : DyeColor.values()) {
            Block wool = ColorHelper.WOOL_MAP.apply(color);
            spreaderPaddingTemplate.m_125612_(ResourceLocationHelper.prefix("block/" + color.m_41065_() + "_spreader_padding"), new TextureMapping().m_125758_(TextureSlot.f_125873_, TextureMapping.m_125740_((Block)wool)).m_125758_(TextureSlot.f_125874_, TextureMapping.m_125740_((Block)wool)).m_125758_(TextureSlot.f_125875_, TextureMapping.m_125740_((Block)wool)), this.modelOutput);
        }
        TextureSlot manaSlot = TextureSlotAccessor.make("mana");
        TextureSlot[] manaPoolSlots = new TextureSlot[]{TextureSlot.f_125875_, TextureSlot.f_125872_, TextureSlot.f_125871_, TextureSlot.f_176491_};
        TextureSlot[] manaPoolFullSlots = new TextureSlot[]{TextureSlot.f_125875_, TextureSlot.f_125872_, TextureSlot.f_125871_, TextureSlot.f_176491_, manaSlot};
        ModelTemplate poolTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/mana_pool")), Optional.empty(), manaPoolSlots);
        ModelTemplate dilutedPoolTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/diluted_mana_pool")), Optional.empty(), manaPoolSlots);
        ModelTemplate creativePoolTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/creative_mana_pool")), Optional.empty(), manaPoolSlots);
        ModelTemplate poolFullTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/mana_pool_full")), Optional.of("_full"), manaPoolFullSlots);
        ModelTemplate dilutedPoolFullTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/diluted_mana_pool_full")), Optional.of("_full"), manaPoolFullSlots);
        ModelTemplate creativePoolFullTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/creative_mana_pool_full")), Optional.of("_full"), manaPoolFullSlots);
        BlockstateProvider.takeAll(remainingBlocks, BotaniaBlocks.manaPool, BotaniaBlocks.dilutedPool, BotaniaBlocks.fabulousPool, BotaniaBlocks.creativePool).forEach(b -> {
            ModelTemplate template;
            Block blockForTexture = b == BotaniaBlocks.fabulousPool ? BotaniaBlocks.manaPool : b;
            ResourceLocation side = TextureMapping.m_125753_((Block)blockForTexture, (String)"_side");
            ResourceLocation top = TextureMapping.m_125753_((Block)blockForTexture, (String)"_top");
            ResourceLocation bottom = b == BotaniaBlocks.dilutedPool ? TextureMapping.m_125753_((Block)BotaniaBlocks.manaPool, (String)"_bottom") : TextureMapping.m_125753_((Block)blockForTexture, (String)"_bottom");
            ResourceLocation inside = TextureMapping.m_125753_((Block)blockForTexture, (String)"_inside");
            ModelTemplate modelTemplate = b == BotaniaBlocks.dilutedPool ? dilutedPoolTemplate : (template = b == BotaniaBlocks.creativePool ? creativePoolTemplate : poolTemplate);
            ModelTemplate fullTemplate = b == BotaniaBlocks.dilutedPool ? dilutedPoolFullTemplate : (b == BotaniaBlocks.creativePool ? creativePoolFullTemplate : poolFullTemplate);
            TextureMapping mapping = new TextureMapping().m_125758_(TextureSlot.f_125875_, side).m_125758_(TextureSlot.f_125872_, top).m_125758_(TextureSlot.f_125871_, bottom).m_125758_(TextureSlot.f_176491_, inside);
            this.singleVariantBlockState((Block)b, template.m_125592_(b, mapping, this.modelOutput));
            fullTemplate.m_125592_(b, mapping.m_125758_(manaSlot, ResourceLocationHelper.prefix("block/mana_water")), this.modelOutput);
        });
        BlockstateProvider.takeAll(remainingBlocks, BotaniaBlocks.pump, BotaniaBlocks.tinyPotato).forEach(b -> this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)b, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)ModelLocationUtils.m_125576_((Block)b))).m_125271_(BlockModelGeneratorsAccessor.horizontalDispatch())));
        BlockstateProvider.takeAll(remainingBlocks, BotaniaBlocks.enderEye, BotaniaBlocks.manaDetector).forEach(b -> {
            ResourceLocation offModel = ModelTemplates.f_125692_.m_125592_(b, TextureMapping.m_125748_((Block)b), this.modelOutput);
            ResourceLocation onModel = ModelTemplates.f_125692_.m_125612_(ModelLocationUtils.m_125578_((Block)b, (String)"_powered"), TextureMapping.m_125776_((ResourceLocation)TextureMapping.m_125753_((Block)b, (String)"_powered")), this.modelOutput);
            this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)b).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61448_).m_125329_((Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)offModel)).m_125329_((Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)onModel))));
        });
        ResourceLocation petalBlockModel = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_all_tinted")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125867_}).m_125612_(ResourceLocationHelper.prefix("block/petal_block"), new TextureMapping().m_125758_(TextureSlot.f_125867_, ResourceLocationHelper.prefix("block/petal_block")), this.modelOutput);
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof PetalBlock).forEach(b -> this.singleVariantBlockState((Block)b, petalBlockModel));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BotaniaGrassBlock).forEach(b -> {
            ResourceLocation model = ModelTemplates.f_125697_.m_125592_(b, new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)b, (String)"_side")).m_125758_(TextureSlot.f_125871_, TextureMapping.m_125740_((Block)Blocks.f_50493_)).m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)b, (String)"_top")), this.modelOutput);
            this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125259_((Block)b, (Variant[])BlockModelGeneratorsAccessor.createRotatedVariants(model)));
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof RedStringBlock).forEach(this::redStringBlock);
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BotaniaDoubleFlowerBlock).forEach(b -> {
            ResourceLocation bottom = ModelTemplates.f_125639_.m_125592_(b, TextureMapping.m_125780_((Block)b), this.modelOutput);
            ResourceLocation top = ModelTemplates.f_125639_.m_125612_(ModelLocationUtils.m_125578_((Block)b, (String)"_top"), TextureMapping.m_125788_((ResourceLocation)TextureMapping.m_125753_((Block)b, (String)"_top")), this.modelOutput);
            this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)b).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)TallFlowerBlock.f_52858_).m_125329_((Comparable)DoubleBlockHalf.LOWER, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottom)).m_125329_((Comparable)DoubleBlockHalf.UPPER, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)top))));
        });
        ResourceLocation[] mountainTextures = new ResourceLocation[]{TextureMapping.m_125740_((Block)BotaniaFluffBlocks.biomeStoneMountain), TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeStoneMountain, (String)"_1")};
        ResourceLocation[] mountainModels = new ResourceLocation[]{ModelLocationUtils.m_125576_((Block)BotaniaFluffBlocks.biomeStoneMountain), ModelLocationUtils.m_125578_((Block)BotaniaFluffBlocks.biomeStoneMountain, (String)"_1")};
        Integer[] mountainWeights = new Integer[]{5, 1};
        this.rotatedMirroredWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeStoneMountain, mountainTextures, mountainWeights);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeStoneMountainStairs, mountainTextures, mountainTextures, mountainTextures, mountainWeights);
        this.slabBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeStoneMountainSlab, mountainModels, mountainTextures, mountainTextures, mountainTextures, mountainWeights);
        this.wallBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeStoneMountainWall, mountainTextures, mountainWeights);
        ResourceLocation[] mountainBrickTextures = new ResourceLocation[]{TextureMapping.m_125740_((Block)BotaniaFluffBlocks.biomeBrickMountain), TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeBrickMountain, (String)"_1"), TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeBrickMountain, (String)"_2"), TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeBrickMountain, (String)"_3"), TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeBrickMountain, (String)"_4"), TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeBrickMountain, (String)"_5")};
        ResourceLocation[] mountainBrickModels = new ResourceLocation[]{ModelLocationUtils.m_125576_((Block)BotaniaFluffBlocks.biomeBrickMountain), ModelLocationUtils.m_125578_((Block)BotaniaFluffBlocks.biomeBrickMountain, (String)"_1"), ModelLocationUtils.m_125578_((Block)BotaniaFluffBlocks.biomeBrickMountain, (String)"_2"), ModelLocationUtils.m_125578_((Block)BotaniaFluffBlocks.biomeBrickMountain, (String)"_3"), ModelLocationUtils.m_125578_((Block)BotaniaFluffBlocks.biomeBrickMountain, (String)"_4"), ModelLocationUtils.m_125578_((Block)BotaniaFluffBlocks.biomeBrickMountain, (String)"_5")};
        this.cubeAllWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeBrickMountain, mountainBrickTextures);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeBrickMountainStairs, mountainBrickTextures, mountainBrickTextures, mountainBrickTextures);
        this.slabBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeBrickMountainSlab, mountainBrickModels, mountainBrickTextures, mountainBrickTextures, mountainBrickTextures);
        this.wallBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeBrickMountainWall, mountainBrickTextures);
        ResourceLocation[] taigaTextures = new ResourceLocation[]{TextureMapping.m_125740_((Block)BotaniaFluffBlocks.biomeStoneTaiga), TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeStoneTaiga, (String)"_1")};
        ResourceLocation[] taigaModels = new ResourceLocation[]{ModelLocationUtils.m_125576_((Block)BotaniaFluffBlocks.biomeStoneTaiga), ModelLocationUtils.m_125578_((Block)BotaniaFluffBlocks.biomeStoneTaiga, (String)"_1")};
        this.rotatedMirroredWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeStoneTaiga, taigaTextures);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeStoneTaigaStairs, taigaTextures, taigaTextures, taigaTextures);
        this.slabBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeStoneTaigaSlab, taigaModels, taigaTextures, taigaTextures, taigaTextures);
        this.wallBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeStoneTaigaWall, taigaTextures);
        ResourceLocation plainsBrickSide = TextureMapping.m_125740_((Block)BotaniaFluffBlocks.biomeBrickPlains);
        ResourceLocation plainsBrickTop = TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeBrickPlains, (String)"_top");
        this.pillarAlt(remainingBlocks, BotaniaFluffBlocks.biomeBrickPlains, plainsBrickTop, plainsBrickSide);
        this.stairsBlock(remainingBlocks, BotaniaFluffBlocks.biomeBrickPlainsStairs, plainsBrickSide, plainsBrickTop, plainsBrickTop);
        this.slabBlock(remainingBlocks, BotaniaFluffBlocks.biomeBrickPlainsSlab, ModelLocationUtils.m_125576_((Block)BotaniaFluffBlocks.biomeBrickPlains), plainsBrickSide, plainsBrickTop, plainsBrickTop);
        this.wallBlock(remainingBlocks, BotaniaFluffBlocks.biomeBrickPlainsWall, plainsBrickSide, plainsBrickTop, plainsBrickTop);
        ResourceLocation[] forestBrickTextures = new ResourceLocation[]{TextureMapping.m_125740_((Block)BotaniaFluffBlocks.biomeBrickForest), TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeBrickForest, (String)"_1")};
        ResourceLocation[] forestBrickModels = new ResourceLocation[]{ModelLocationUtils.m_125576_((Block)BotaniaFluffBlocks.biomeBrickForest), ModelLocationUtils.m_125578_((Block)BotaniaFluffBlocks.biomeBrickForest, (String)"_1")};
        Integer[] forestBrickWeights = new Integer[]{2, 1};
        this.cubeAllWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeBrickForest, forestBrickTextures, forestBrickWeights);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeBrickForestStairs, forestBrickTextures, forestBrickTextures, forestBrickTextures, forestBrickWeights);
        this.slabBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeBrickForestSlab, forestBrickModels, forestBrickTextures, forestBrickTextures, forestBrickTextures, forestBrickWeights);
        this.wallBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeBrickForestWall, forestBrickTextures, forestBrickWeights);
        ResourceLocation[] fungalBrickTextures = new ResourceLocation[]{TextureMapping.m_125740_((Block)BotaniaFluffBlocks.biomeBrickFungal), TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeBrickFungal, (String)"_1")};
        ResourceLocation[] fungalBrickModels = new ResourceLocation[]{ModelLocationUtils.m_125576_((Block)BotaniaFluffBlocks.biomeBrickFungal), ModelLocationUtils.m_125578_((Block)BotaniaFluffBlocks.biomeBrickFungal, (String)"_1")};
        this.cubeAllWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeBrickFungal, fungalBrickTextures);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeBrickFungalStairs, fungalBrickTextures, fungalBrickTextures, fungalBrickTextures);
        this.slabBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeBrickFungalSlab, fungalBrickModels, fungalBrickTextures, fungalBrickTextures, fungalBrickTextures);
        this.wallBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeBrickFungalWall, fungalBrickTextures);
        ResourceLocation[] swampBrickTopTextures = new ResourceLocation[]{TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeBrickSwamp, (String)"_top"), TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeBrickSwamp, (String)"_top_1")};
        ResourceLocation[] swampBrickBottomTextures = new ResourceLocation[]{TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeBrickSwamp, (String)"_bottom"), TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeBrickSwamp, (String)"_bottom")};
        ResourceLocation[] swampBrickSideTextures = new ResourceLocation[]{TextureMapping.m_125740_((Block)BotaniaFluffBlocks.biomeBrickSwamp), TextureMapping.m_125740_((Block)BotaniaFluffBlocks.biomeBrickSwamp)};
        ResourceLocation[] swampBrickModels = new ResourceLocation[]{ModelLocationUtils.m_125576_((Block)BotaniaFluffBlocks.biomeBrickSwamp), ModelLocationUtils.m_125578_((Block)BotaniaFluffBlocks.biomeBrickSwamp, (String)"_1")};
        this.directionalPillarWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeBrickSwamp, swampBrickTopTextures, swampBrickBottomTextures, swampBrickSideTextures);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeBrickSwampStairs, swampBrickSideTextures, swampBrickBottomTextures, swampBrickTopTextures);
        this.slabBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeBrickSwampSlab, swampBrickModels, swampBrickSideTextures, swampBrickBottomTextures, swampBrickTopTextures);
        this.wallBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeBrickSwampWall, swampBrickSideTextures, swampBrickBottomTextures, swampBrickTopTextures);
        ResourceLocation[] swampChiseledBrickTopTextures = new ResourceLocation[]{TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeChiseledBrickSwamp, (String)"_top"), TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeChiseledBrickSwamp, (String)"_top_1")};
        ResourceLocation[] swampChiseledBrickBottomTextures = new ResourceLocation[]{TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeChiseledBrickSwamp, (String)"_bottom"), TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeChiseledBrickSwamp, (String)"_bottom")};
        ResourceLocation[] swampChiseledBrickSideTextures = new ResourceLocation[]{TextureMapping.m_125740_((Block)BotaniaFluffBlocks.biomeChiseledBrickSwamp), TextureMapping.m_125740_((Block)BotaniaFluffBlocks.biomeChiseledBrickSwamp)};
        this.directionalPillarWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeChiseledBrickSwamp, swampChiseledBrickTopTextures, swampChiseledBrickBottomTextures, swampChiseledBrickSideTextures);
        ResourceLocation[] swampCobblestoneTextures = new ResourceLocation[]{TextureMapping.m_125740_((Block)BotaniaFluffBlocks.biomeCobblestoneSwamp), TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeCobblestoneSwamp, (String)"_1")};
        ResourceLocation[] swampCobblestoneModels = new ResourceLocation[]{ModelLocationUtils.m_125576_((Block)BotaniaFluffBlocks.biomeCobblestoneSwamp), ModelLocationUtils.m_125578_((Block)BotaniaFluffBlocks.biomeCobblestoneSwamp, (String)"_1")};
        this.cubeAllWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeCobblestoneSwamp, swampCobblestoneTextures);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeCobblestoneSwampStairs, swampCobblestoneTextures, swampCobblestoneTextures, swampCobblestoneTextures);
        this.slabBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeCobblestoneSwampSlab, swampCobblestoneModels, swampCobblestoneTextures, swampCobblestoneTextures, swampCobblestoneTextures);
        this.wallBlockWithVariants(remainingBlocks, BotaniaFluffBlocks.biomeCobblestoneSwampWall, swampCobblestoneTextures);
        ResourceLocation mesaBrick = TextureMapping.m_125740_((Block)BotaniaFluffBlocks.biomeBrickMesa);
        ResourceLocation mesaBrickMirrored = TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeBrickMesa, (String)"_mirrored");
        ResourceLocation mesaBrickModel = this.checkeredBlockWithBlockstate(remainingBlocks, BotaniaFluffBlocks.biomeBrickMesa, mesaBrick, mesaBrickMirrored);
        this.checkeredSlabBlock(remainingBlocks, BotaniaFluffBlocks.biomeBrickMesaSlab, mesaBrickModel, mesaBrick, mesaBrickMirrored);
        this.checkeredStairsBlock(remainingBlocks, BotaniaFluffBlocks.biomeBrickMesaStairs, mesaBrick, mesaBrickMirrored);
        this.checkeredWallBlock(remainingBlocks, BotaniaFluffBlocks.biomeBrickMesaWall, mesaBrick, mesaBrickMirrored);
        ResourceLocation mesaChiseledBrickSide = TextureMapping.m_125740_((Block)BotaniaFluffBlocks.biomeChiseledBrickMesa);
        ResourceLocation mesaChiseledBrickTop = TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeChiseledBrickMesa, (String)"_top");
        this.pillarAlt(remainingBlocks, BotaniaFluffBlocks.biomeChiseledBrickMesa, mesaChiseledBrickTop, mesaChiseledBrickSide);
        for (Block block : new Block[]{BotaniaFluffBlocks.biomeStoneDesert, BotaniaFluffBlocks.biomeStoneForest, BotaniaFluffBlocks.biomeStoneFungal, BotaniaFluffBlocks.biomeStoneMesa, BotaniaFluffBlocks.biomeStonePlains, BotaniaFluffBlocks.biomeStoneSwamp}) {
            this.rotatedMirrored(remainingBlocks, block, TextureMapping.m_125740_((Block)block));
        }
        for (String string : new String[]{"dark", "mana", "blaze", "lavender", "red", "elf", "sunny"}) {
            ResourceLocation quartzId = ResourceLocationHelper.prefix(string + "_quartz");
            Block quartz = (Block)Registry.f_122824_.m_6612_(quartzId).get();
            this.singleVariantBlockState(quartz, ModelTemplates.f_125697_.m_125592_(quartz, TextureMapping.m_125826_((Block)quartz), this.modelOutput));
            ResourceLocation pillarId = ResourceLocationHelper.prefix(string + "_quartz_pillar");
            Block pillar = (Block)Registry.f_122824_.m_6612_(pillarId).get();
            ResourceLocation pillarModel = ModelTemplates.f_125694_.m_125592_(pillar, TextureMapping.m_125763_((ResourceLocation)TextureMapping.m_125753_((Block)pillar, (String)"_side"), (ResourceLocation)TextureMapping.m_125753_((Block)pillar, (String)"_end")), this.modelOutput);
            this.blockstates.add(BlockModelGeneratorsAccessor.createAxisAlignedPillarBlock(pillar, pillarModel));
            ResourceLocation chiseledId = ResourceLocationHelper.prefix("chiseled_" + string + "_quartz");
            Block chiseled = (Block)Registry.f_122824_.m_6612_(chiseledId).get();
            this.singleVariantBlockState(chiseled, ModelTemplates.f_125694_.m_125592_(chiseled, new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)chiseled, (String)"_side")).m_125758_(TextureSlot.f_125870_, TextureMapping.m_125753_((Block)chiseled, (String)"_end")), this.modelOutput));
            remainingBlocks.remove(quartz);
            remainingBlocks.remove(pillar);
            remainingBlocks.remove(chiseled);
        }
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BuriedPetalBlock).forEach(b -> {
            DyeColor color = ((BuriedPetalBlock)b).color;
            ResourceLocation wool = new ResourceLocation("block/" + color.m_7912_() + "_wool");
            this.particleOnly(remainingBlocks, (Block)b, wool);
        });
        ModelTemplate modelTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/petal_apothecary")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125875_, TextureSlot.f_125872_, TextureSlot.f_125871_});
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof PetalApothecaryBlock).forEach(b -> this.singleVariantBlockState((Block)b, apothecaryTemplate.m_125592_(b, new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)b, (String)"_side")).m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)b, (String)"_top")).m_125758_(TextureSlot.f_125871_, TextureMapping.m_125753_((Block)b, (String)"_bottom")), this.modelOutput)));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof FloatingFlowerBlock).forEach(b -> this.singleVariantBlockState((Block)b, ModelLocationUtils.m_125576_((Block)b)));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BotaniaPaneBlock).forEach(b -> {
            String name = Registry.f_122824_.m_7981_(b).m_135815_();
            TextureMapping mapping = new TextureMapping().m_125758_(TextureSlot.f_125889_, TextureMapping.m_125740_((Block)b)).m_125758_(TextureSlot.f_125888_, ResourceLocationHelper.prefix("block/" + name.substring(0, name.length() - "_pane".length())));
            ResourceLocation postModel = ModelTemplates.f_125673_.m_125592_(b, mapping, this.modelOutput);
            ResourceLocation sideModel = ModelTemplates.f_125674_.m_125592_(b, mapping, this.modelOutput);
            ResourceLocation sideAltModel = ModelTemplates.f_125675_.m_125592_(b, mapping, this.modelOutput);
            ResourceLocation noSideModel = ModelTemplates.f_125671_.m_125592_(b, mapping, this.modelOutput);
            ResourceLocation noSideAltModel = ModelTemplates.f_125672_.m_125592_(b, mapping, this.modelOutput);
            this.blockstates.add((BlockStateGenerator)MultiPartGenerator.m_125204_((Block)b).m_125218_(Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)postModel)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)sideModel)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)sideModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)sideAltModel)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)sideAltModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(false)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)noSideModel)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(false)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)noSideAltModel)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(false)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)noSideAltModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(false)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)noSideModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)));
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof StairBlock).forEach(b -> {
            String name = Registry.f_122824_.m_7981_(b).m_135815_();
            String baseName = name.substring(0, name.length() - "_stairs".length());
            boolean quartz = name.contains("quartz");
            if (quartz) {
                ResourceLocation side = ResourceLocationHelper.prefix("block/" + baseName + "_side");
                ResourceLocation bottom = ResourceLocationHelper.prefix("block/" + baseName + "_bottom");
                ResourceLocation top = ResourceLocationHelper.prefix("block/" + baseName + "_top");
                this.stairsBlock((Set<Block>)new HashSet<Block>(), (Block)b, side, bottom, top);
            } else {
                ResourceLocation tex = ResourceLocationHelper.prefix("block/" + baseName);
                this.stairsBlock((Set<Block>)new HashSet<Block>(), (Block)b, tex, tex, tex);
            }
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof SlabBlock).forEach(slabBlock -> {
            String name = Registry.f_122824_.m_7981_(slabBlock).m_135815_();
            String baseName = name.substring(0, name.length() - "_slab".length());
            Block base = (Block)Registry.f_122824_.m_6612_(ResourceLocationHelper.prefix(baseName)).get();
            boolean quartz = name.contains("quartz");
            if (quartz) {
                ResourceLocation side = TextureMapping.m_125753_((Block)base, (String)"_side");
                ResourceLocation bottom = TextureMapping.m_125753_((Block)base, (String)"_bottom");
                ResourceLocation top = TextureMapping.m_125753_((Block)base, (String)"_top");
                ResourceLocation doubleModel = ModelLocationUtils.m_125576_((Block)base);
                this.slabBlock((Set<Block>)new HashSet<Block>(), (Block)slabBlock, doubleModel, side, bottom, top);
            } else {
                ResourceLocation baseTex = TextureMapping.m_125740_((Block)base);
                ResourceLocation doubleModel = ModelLocationUtils.m_125576_((Block)base);
                this.slabBlock((Set<Block>)new HashSet<Block>(), (Block)slabBlock, doubleModel, baseTex, baseTex, baseTex);
            }
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof WallBlock).forEach(wallBlock -> {
            String name = Registry.f_122824_.m_7981_(wallBlock).m_135815_();
            String baseName = name.substring(0, name.length() - "_wall".length());
            Block base = (Block)Registry.f_122824_.m_6612_(ResourceLocationHelper.prefix(baseName)).get();
            ResourceLocation baseTexture = TextureMapping.m_125740_((Block)base);
            this.wallBlock((Set<Block>)new HashSet<Block>(), (Block)wallBlock, baseTexture);
        });
        remainingBlocks.forEach(this::cubeAllNoRemove);
    }

    protected void particleOnly(Set<Block> blocks, Block b, ResourceLocation particle) {
        this.singleVariantBlockState(b, ModelTemplates.f_125626_.m_125592_(b, TextureMapping.m_125812_((ResourceLocation)particle), this.modelOutput));
        blocks.remove(b);
    }

    protected void manualModel(Set<Block> blocks, Block b) {
        this.singleVariantBlockState(b, ModelLocationUtils.m_125576_((Block)b));
        blocks.remove(b);
    }

    protected void stairsBlock(Set<Block> blocks, Block block, ResourceLocation sideTex, ResourceLocation bottomTex, ResourceLocation topTex) {
        this.stairsBlockWithVariants(blocks, block, new ResourceLocation[]{sideTex}, new ResourceLocation[]{bottomTex}, new ResourceLocation[]{topTex});
    }

    protected void checkeredStairsBlock(Set<Block> blocks, Block block, ResourceLocation texture, ResourceLocation mirroredTexture) {
        BiFunction<String, Optional, ModelTemplate> checkeredTemplate = (model, suffix) -> new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/" + model)), suffix, new TextureSlot[]{TextureSlot.f_125875_, TextureSlot.f_125876_});
        TextureMapping checkeredMapping = new TextureMapping().m_125758_(TextureSlot.f_125875_, texture).m_125758_(TextureSlot.f_125876_, mirroredTexture);
        ResourceLocation checkeredStairsModel = checkeredTemplate.apply("stairs_checkered", Optional.empty()).m_125592_(BotaniaFluffBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredStairsModelRot90 = checkeredTemplate.apply("stairs_checkered_90deg", Optional.of("_90deg")).m_125592_(BotaniaFluffBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredStairsOuterModel = checkeredTemplate.apply("stairs_outer_checkered", Optional.of("_outer")).m_125592_(BotaniaFluffBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredStairsOuterModelRot90 = checkeredTemplate.apply("stairs_outer_checkered_90deg", Optional.of("_outer_90deg")).m_125592_(BotaniaFluffBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredStairsInnerModel = checkeredTemplate.apply("stairs_inner_checkered", Optional.of("_inner")).m_125592_(BotaniaFluffBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredStairsInnerModelRot90 = checkeredTemplate.apply("stairs_inner_checkered_90deg", Optional.of("_inner_90deg")).m_125592_(BotaniaFluffBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        this.stairsBlockWithModels(blocks, block, checkeredStairsInnerModel, checkeredStairsInnerModelRot90, checkeredStairsModel, checkeredStairsModelRot90, checkeredStairsOuterModel, checkeredStairsOuterModelRot90);
    }

    protected void stairsBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] sideTextures, ResourceLocation[] bottomTextures, ResourceLocation[] topTextures) {
        Object[] weights = new Integer[sideTextures.length];
        Arrays.fill(weights, (Object)1);
        this.stairsBlockWithVariants(blocks, block, sideTextures, bottomTextures, topTextures, (Integer[])weights);
    }

    protected void stairsBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] sideTextures, ResourceLocation[] bottomTextures, ResourceLocation[] topTextures, Integer[] weights) {
        int length = sideTextures.length;
        if (length != topTextures.length || length != bottomTextures.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] innerModels = new ResourceLocation[length];
        ResourceLocation[] straightModels = new ResourceLocation[length];
        ResourceLocation[] outerModels = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            TextureMapping mapping = new TextureMapping().m_125758_(TextureSlot.f_125875_, sideTextures[i]).m_125758_(TextureSlot.f_125871_, bottomTextures[i]).m_125758_(TextureSlot.f_125872_, topTextures[i]);
            ResourceLocation modelIdInner = ModelLocationUtils.m_125578_((Block)block, (String)("_inner" + (String)suffix));
            ResourceLocation modelIdStraight = ModelLocationUtils.m_125578_((Block)block, (String)suffix);
            ResourceLocation modelIdOuter = ModelLocationUtils.m_125578_((Block)block, (String)("_outer" + (String)suffix));
            innerModels[i] = ModelTemplates.f_125631_.m_125612_(modelIdInner, mapping, this.modelOutput);
            straightModels[i] = ModelTemplates.f_125630_.m_125612_(modelIdStraight, mapping, this.modelOutput);
            outerModels[i] = ModelTemplates.f_125632_.m_125612_(modelIdOuter, mapping, this.modelOutput);
        }
        this.stairsBlockWithModels(blocks, block, innerModels, straightModels, outerModels, weights);
    }

    protected void stairsBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] innerModels, ResourceLocation[] straightModels, ResourceLocation[] outerModels, Integer[] weights) {
        this.stairsBlockWithModels(blocks, block, innerModels, straightModels, outerModels, weights, true);
    }

    protected void stairsBlockWithModels(Set<Block> blocks, Block block, ResourceLocation innerModel, ResourceLocation innerModelRot90, ResourceLocation straightModel, ResourceLocation straightModelRot90, ResourceLocation outerModel, ResourceLocation outerModelRot90) {
        this.stairsBlockWithModels(blocks, block, new ResourceLocation[]{innerModel}, new ResourceLocation[]{innerModelRot90}, new ResourceLocation[]{straightModel}, new ResourceLocation[]{straightModelRot90}, new ResourceLocation[]{outerModel}, new ResourceLocation[]{outerModelRot90}, new Integer[]{1}, true);
    }

    protected void stairsBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] innerModels, ResourceLocation[] straightModels, ResourceLocation[] outerModels, Integer[] weights, Boolean uvlock) {
        this.stairsBlockWithModels(blocks, block, innerModels, innerModels, straightModels, straightModels, outerModels, outerModels, weights, uvlock);
    }

    protected void stairsBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] innerModels, ResourceLocation[] innerModelsRot90, ResourceLocation[] straightModels, ResourceLocation[] straightModelsRot90, ResourceLocation[] outerModels, ResourceLocation[] outerModelsRot90, Integer[] weights, Boolean uvlock) {
        int length = innerModels.length;
        if (length != straightModels.length || length != outerModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        PropertyDispatch.C3 propertyDispatch = PropertyDispatch.m_125299_((Property)BlockStateProperties.f_61374_, (Property)BlockStateProperties.f_61402_, (Property)BlockStateProperties.f_61398_);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            for (Half half : Half.values()) {
                for (StairsShape stairsShape : StairsShape.values()) {
                    boolean isRight;
                    boolean isLeft = stairsShape == StairsShape.INNER_LEFT || stairsShape == StairsShape.OUTER_LEFT;
                    boolean bl = isRight = stairsShape == StairsShape.INNER_RIGHT || stairsShape == StairsShape.OUTER_RIGHT;
                    int rotationOffset = isLeft && half == Half.BOTTOM ? -1 : (isRight && half == Half.TOP ? 1 : 0);
                    VariantProperties.Rotation[] rotations = VariantProperties.Rotation.values();
                    VariantProperties.Rotation yRot = switch (direction) {
                        case Direction.EAST -> rotations[(4 + rotationOffset) % 4];
                        case Direction.WEST -> rotations[(2 + rotationOffset) % 4];
                        case Direction.SOUTH -> rotations[(1 + rotationOffset) % 4];
                        case Direction.NORTH -> rotations[(3 + rotationOffset) % 4];
                        default -> throw new IllegalStateException();
                    };
                    VariantProperties.Rotation xRot = switch (half) {
                        default -> throw new IncompatibleClassChangeError();
                        case Half.BOTTOM -> VariantProperties.Rotation.R0;
                        case Half.TOP -> VariantProperties.Rotation.R180;
                    };
                    boolean rotatedModel = yRot == VariantProperties.Rotation.R90 || yRot == VariantProperties.Rotation.R270;
                    ResourceLocation[] models = switch (stairsShape) {
                        default -> throw new IncompatibleClassChangeError();
                        case StairsShape.STRAIGHT -> {
                            if (rotatedModel) {
                                yield straightModelsRot90;
                            }
                            yield straightModels;
                        }
                        case StairsShape.OUTER_RIGHT, StairsShape.OUTER_LEFT -> {
                            if (rotatedModel) {
                                yield outerModelsRot90;
                            }
                            yield outerModels;
                        }
                        case StairsShape.INNER_RIGHT, StairsShape.INNER_LEFT -> rotatedModel ? innerModelsRot90 : innerModels;
                    };
                    Stream<Integer> indices = IntStream.range(0, length).boxed();
                    propertyDispatch.m_125396_((Comparable)direction, (Comparable)half, (Comparable)stairsShape, indices.map(i -> this.maybeUVLock(uvlock, this.maybeWeight(weights[i], this.maybeYRot(yRot, this.maybeXRot(xRot, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)models[i])))))).toList());
                }
            }
        }
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_((PropertyDispatch)propertyDispatch));
        blocks.remove(block);
    }

    protected void slabBlock(Set<Block> blocks, Block block, ResourceLocation doubleModel, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.slabBlockWithVariants(blocks, block, new ResourceLocation[]{doubleModel}, new ResourceLocation[]{side}, new ResourceLocation[]{bottom}, new ResourceLocation[]{top});
    }

    protected void checkeredSlabBlock(Set<Block> blocks, Block block, ResourceLocation doubleModel, ResourceLocation texture, ResourceLocation mirroredTexture) {
        BiFunction<String, Optional, ModelTemplate> checkeredTemplate = (model, suffix) -> new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/" + model)), suffix, new TextureSlot[]{TextureSlot.f_125875_, TextureSlot.f_125876_});
        TextureMapping checkeredMapping = new TextureMapping().m_125758_(TextureSlot.f_125875_, texture).m_125758_(TextureSlot.f_125876_, mirroredTexture);
        ResourceLocation slabModel = checkeredTemplate.apply("slab_checkered", Optional.empty()).m_125592_(BotaniaFluffBlocks.biomeBrickMesaSlab, checkeredMapping, this.modelOutput);
        ResourceLocation slabTopModel = checkeredTemplate.apply("slab_top_checkered", Optional.of("_top")).m_125592_(BotaniaFluffBlocks.biomeBrickMesaSlab, checkeredMapping, this.modelOutput);
        this.slabBlockWithModels(blocks, block, slabModel, slabTopModel, doubleModel);
    }

    protected void slabBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] doubleModels, ResourceLocation[] sideTextures, ResourceLocation[] bottomTextures, ResourceLocation[] topTextures) {
        Object[] weights = new Integer[sideTextures.length];
        Arrays.fill(weights, (Object)1);
        this.slabBlockWithVariants(blocks, block, doubleModels, sideTextures, bottomTextures, topTextures, (Integer[])weights);
    }

    protected void slabBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] doubleModels, ResourceLocation[] sideTextures, ResourceLocation[] bottomTextures, ResourceLocation[] topTextures, Integer[] weights) {
        int length = sideTextures.length;
        if (length != topTextures.length || length != bottomTextures.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] bottomModels = new ResourceLocation[length];
        ResourceLocation[] topModels = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            TextureMapping mapping = new TextureMapping().m_125758_(TextureSlot.f_125875_, sideTextures[i]).m_125758_(TextureSlot.f_125871_, bottomTextures[i]).m_125758_(TextureSlot.f_125872_, topTextures[i]);
            ResourceLocation modelIdBottom = ModelLocationUtils.m_125578_((Block)block, (String)suffix);
            ResourceLocation modelIdTop = ModelLocationUtils.m_125578_((Block)block, (String)("_top" + (String)suffix));
            bottomModels[i] = ModelTemplates.f_125627_.m_125612_(modelIdBottom, mapping, this.modelOutput);
            topModels[i] = ModelTemplates.f_125628_.m_125612_(modelIdTop, mapping, this.modelOutput);
        }
        this.slabBlockWithModels(blocks, block, bottomModels, topModels, doubleModels, weights);
    }

    protected void slabBlockWithModels(Set<Block> blocks, Block block, ResourceLocation bottomModel, ResourceLocation topModel, ResourceLocation doubleModel) {
        this.slabBlockWithModels(blocks, block, new ResourceLocation[]{bottomModel}, new ResourceLocation[]{topModel}, new ResourceLocation[]{doubleModel}, new Integer[]{1});
    }

    protected void slabBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] bottomModels, ResourceLocation[] topModels, ResourceLocation[] doubleModels, Integer[] weights) {
        int length = doubleModels.length;
        if (length != topModels.length || length != bottomModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        Stream<Integer> indicesBottom = IntStream.range(0, length).boxed();
        Stream<Integer> indicesTop = IntStream.range(0, length).boxed();
        Stream<Integer> indicesDouble = IntStream.range(0, length).boxed();
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61397_).m_125332_((Comparable)SlabType.BOTTOM, indicesBottom.map(i -> this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomModels[i]))).toList()).m_125332_((Comparable)SlabType.TOP, indicesTop.map(i -> this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topModels[i]))).toList()).m_125332_((Comparable)SlabType.DOUBLE, indicesDouble.map(i -> this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doubleModels[i]))).toList())));
        blocks.remove(block);
    }

    protected void wallBlock(Set<Block> blocks, Block block, ResourceLocation texture) {
        this.wallBlock(blocks, block, texture, texture, texture);
    }

    protected void wallBlock(Set<Block> blocks, Block block, ResourceLocation sideTexture, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        this.wallBlockWithVariants(blocks, block, new ResourceLocation[]{sideTexture}, new ResourceLocation[]{bottomTexture}, new ResourceLocation[]{topTexture});
    }

    protected void checkeredWallBlock(Set<Block> blocks, Block block, ResourceLocation texture, ResourceLocation mirroredTexture) {
        BiFunction<String, Optional, ModelTemplate> checkeredTemplate = (model, suffix) -> new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/" + model)), suffix, new TextureSlot[]{TextureSlot.f_125875_, TextureSlot.f_125876_});
        TextureMapping checkeredMapping = new TextureMapping().m_125758_(TextureSlot.f_125875_, texture).m_125758_(TextureSlot.f_125876_, mirroredTexture);
        ResourceLocation checkeredWallPostModel = checkeredTemplate.apply("wall_post_checkered", Optional.of("_post")).m_125592_(BotaniaFluffBlocks.biomeBrickMesaWall, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredWallSideModel = checkeredTemplate.apply("wall_side_checkered", Optional.of("_side")).m_125592_(BotaniaFluffBlocks.biomeBrickMesaWall, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredWallSideModelRot90 = checkeredTemplate.apply("wall_side_checkered_90deg", Optional.of("_side_90deg")).m_125592_(BotaniaFluffBlocks.biomeBrickMesaWall, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredWallSideTallModel = checkeredTemplate.apply("wall_side_tall_checkered", Optional.of("_side_tall")).m_125592_(BotaniaFluffBlocks.biomeBrickMesaWall, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredWallSideTallModelRot90 = checkeredTemplate.apply("wall_side_tall_checkered_90deg", Optional.of("_side_tall_90deg")).m_125592_(BotaniaFluffBlocks.biomeBrickMesaWall, checkeredMapping, this.modelOutput);
        this.wallBlockWithModels(blocks, block, checkeredWallPostModel, checkeredWallSideModel, checkeredWallSideModelRot90, checkeredWallSideTallModel, checkeredWallSideTallModelRot90);
    }

    protected void wallBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] textures) {
        this.wallBlockWithVariants(blocks, block, textures, textures, textures);
    }

    protected void wallBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] textures, Integer[] weights) {
        this.wallBlockWithVariants(blocks, block, textures, textures, textures, weights);
    }

    protected void wallBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] sideTextures, ResourceLocation[] bottomTextures, ResourceLocation[] topTextures) {
        Object[] weights = new Integer[sideTextures.length];
        Arrays.fill(weights, (Object)1);
        this.wallBlockWithVariants(blocks, block, sideTextures, bottomTextures, topTextures, (Integer[])weights);
    }

    protected void wallBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] sideTextures, ResourceLocation[] bottomTextures, ResourceLocation[] topTextures, Integer[] weights) {
        int length = sideTextures.length;
        if (length != bottomTextures.length && length != topTextures.length && length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] postModels = new ResourceLocation[length];
        ResourceLocation[] lowModels = new ResourceLocation[length];
        ResourceLocation[] tallModels = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            TextureMapping mapping = new TextureMapping().m_125758_(TextureSlot.f_125884_, sideTextures[i]).m_125758_(TextureSlot.f_125871_, bottomTextures[i]).m_125758_(TextureSlot.f_125872_, topTextures[i]);
            ResourceLocation modelIdPost = ModelLocationUtils.m_125578_((Block)block, (String)("_post" + (String)suffix));
            ResourceLocation modelIdLow = ModelLocationUtils.m_125578_((Block)block, (String)("_side" + (String)suffix));
            ResourceLocation modelIdTall = ModelLocationUtils.m_125578_((Block)block, (String)("_side_tall" + (String)suffix));
            ModelTemplate postTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_post")), Optional.of("_post"), new TextureSlot[]{TextureSlot.f_125884_, TextureSlot.f_125871_, TextureSlot.f_125872_});
            ModelTemplate sideTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_side")), Optional.of("_side"), new TextureSlot[]{TextureSlot.f_125884_, TextureSlot.f_125871_, TextureSlot.f_125872_});
            ModelTemplate sideTallTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_side_tall")), Optional.of("_side_tall"), new TextureSlot[]{TextureSlot.f_125884_, TextureSlot.f_125871_, TextureSlot.f_125872_});
            postModels[i] = postTemplate.m_125612_(modelIdPost, mapping, this.modelOutput);
            lowModels[i] = sideTemplate.m_125612_(modelIdLow, mapping, this.modelOutput);
            tallModels[i] = sideTallTemplate.m_125612_(modelIdTall, mapping, this.modelOutput);
        }
        this.wallBlockWithModels(blocks, block, postModels, lowModels, tallModels, weights);
    }

    protected void wallBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] postModels, ResourceLocation[] lowModels, ResourceLocation[] tallModels, Integer[] weights) {
        this.wallBlockWithModels(blocks, block, postModels, lowModels, tallModels, weights, true);
    }

    protected void wallBlockWithModels(Set<Block> blocks, Block block, ResourceLocation postModel, ResourceLocation lowModel, ResourceLocation lowModelRot90, ResourceLocation tallModel, ResourceLocation tallodelRot90) {
        this.wallBlockWithModels(blocks, block, new ResourceLocation[]{postModel}, new ResourceLocation[]{lowModel}, new ResourceLocation[]{lowModelRot90}, new ResourceLocation[]{tallModel}, new ResourceLocation[]{tallodelRot90}, new Integer[]{1}, true);
    }

    protected void wallBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] postModels, ResourceLocation[] lowModels, ResourceLocation[] tallModels, Integer[] weights, Boolean uvlock) {
        this.wallBlockWithModels(blocks, block, postModels, lowModels, lowModels, tallModels, tallModels, weights, uvlock);
    }

    protected void wallBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] postModels, ResourceLocation[] lowModels, ResourceLocation[] lowModelsRot90, ResourceLocation[] tallModels, ResourceLocation[] tallodelsRot90, Integer[] weights, Boolean uvlock) {
        int length = postModels.length;
        if (length != lowModels.length || length != tallModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        MultiPartGenerator multiPartGenerator = MultiPartGenerator.m_125204_((Block)block);
        Stream<Integer> indicesPost = IntStream.range(0, length).boxed();
        multiPartGenerator.m_125215_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(true)), (Variant[])indicesPost.map(i -> this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)postModels[i]))).toArray(Variant[]::new));
        List<EnumProperty> wallSides = List.of(BlockStateProperties.f_61378_, BlockStateProperties.f_61381_, BlockStateProperties.f_61380_, BlockStateProperties.f_61379_);
        for (EnumProperty wallSide : wallSides) {
            VariantProperties.Rotation yRot = wallSide == BlockStateProperties.f_61378_ ? VariantProperties.Rotation.R90 : (wallSide == BlockStateProperties.f_61381_ ? VariantProperties.Rotation.R270 : (wallSide == BlockStateProperties.f_61380_ ? VariantProperties.Rotation.R180 : VariantProperties.Rotation.R0));
            boolean rotatedModel = yRot == VariantProperties.Rotation.R90 || yRot == VariantProperties.Rotation.R270;
            Stream<Integer> indicesLow = IntStream.range(0, length).boxed();
            Stream<Integer> indicesTall = IntStream.range(0, length).boxed();
            multiPartGenerator.m_125215_((Condition)Condition.m_125135_().m_125176_((Property)wallSide, (Comparable)WallSide.LOW), (Variant[])indicesLow.map(i -> this.maybeUVLock(uvlock, this.maybeWeight(weights[i], this.maybeYRot(yRot, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)(rotatedModel ? lowModelsRot90[i] : lowModels[i])))))).toArray(Variant[]::new)).m_125215_((Condition)Condition.m_125135_().m_125176_((Property)wallSide, (Comparable)WallSide.TALL), (Variant[])indicesTall.map(i -> this.maybeUVLock(uvlock, this.maybeWeight(weights[i], this.maybeYRot(yRot, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)(rotatedModel ? tallodelsRot90[i] : tallModels[i])))))).toArray(Variant[]::new));
        }
        this.blockstates.add((BlockStateGenerator)multiPartGenerator);
        blocks.remove(block);
    }

    protected void fenceBlock(Block block, ResourceLocation tex) {
        TextureMapping mapping = TextureMapping.m_125761_((ResourceLocation)tex);
        ResourceLocation postModel = ModelTemplates.f_125708_.m_125592_(block, mapping, this.modelOutput);
        ResourceLocation sideModel = ModelTemplates.f_125709_.m_125592_(block, mapping, this.modelOutput);
        this.blockstates.add(BlockModelGeneratorsAccessor.makeFenceState(block, postModel, sideModel));
    }

    protected void fenceGateBlock(Block block, ResourceLocation tex) {
        TextureMapping mapping = TextureMapping.m_125761_((ResourceLocation)tex);
        ResourceLocation openModel = ModelTemplates.f_125621_.m_125592_(block, mapping, this.modelOutput);
        ResourceLocation closedModel = ModelTemplates.f_125715_.m_125592_(block, mapping, this.modelOutput);
        ResourceLocation openWallModel = ModelTemplates.f_125623_.m_125592_(block, mapping, this.modelOutput);
        ResourceLocation closedWallModel = ModelTemplates.f_125622_.m_125592_(block, mapping, this.modelOutput);
        this.blockstates.add(BlockModelGeneratorsAccessor.makeFenceGateState(block, openModel, closedModel, openWallModel, closedWallModel));
    }

    protected void cubeAllNoRemove(Block block) {
        this.cubeAll(new HashSet<Block>(), block);
    }

    protected void cubeAll(Set<Block> blocks, Block block) {
        ResourceLocation texture = TextureMapping.m_125740_((Block)block);
        this.cubeAllWithVariants(blocks, block, new ResourceLocation[]{texture});
    }

    protected ResourceLocation checkeredBlockWithBlockstate(Set<Block> blocks, Block block, ResourceLocation texture, ResourceLocation mirroredTexture) {
        BiFunction<String, Optional, ModelTemplate> checkeredTemplate = (model, suffix) -> new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/" + model)), suffix, new TextureSlot[]{TextureSlot.f_125875_, TextureSlot.f_125876_});
        TextureMapping checkeredMapping = new TextureMapping().m_125758_(TextureSlot.f_125875_, texture).m_125758_(TextureSlot.f_125876_, mirroredTexture);
        ResourceLocation blockModel = checkeredTemplate.apply("cube_checkered", Optional.empty()).m_125592_(BotaniaFluffBlocks.biomeBrickMesa, checkeredMapping, this.modelOutput);
        this.cubeAllWithModels(blocks, block, new ResourceLocation[]{blockModel}, new Integer[]{1});
        return blockModel;
    }

    protected void cubeAllWithVariants(Set<Block> blocks, Block block, ResourceLocation[] textures) {
        Object[] weights = new Integer[textures.length];
        Arrays.fill(weights, (Object)1);
        this.cubeAllWithVariants(blocks, block, textures, (Integer[])weights);
    }

    protected void cubeAllWithVariants(Set<Block> blocks, Block block, ResourceLocation[] textures, Integer[] weights) {
        int length = textures.length;
        if (length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] models = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            ResourceLocation modelId = ModelLocationUtils.m_125578_((Block)block, (String)suffix);
            models[i] = ModelTemplates.f_125692_.m_125612_(modelId, TextureMapping.m_125776_((ResourceLocation)textures[i]), this.modelOutput);
        }
        this.cubeAllWithModels(blocks, block, models, weights);
    }

    protected void cubeAllWithModels(Set<Block> blocks, Block block, ResourceLocation[] models, Integer[] weights) {
        int length = models.length;
        if (length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        Stream<Integer> indices = IntStream.range(0, length).boxed();
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125259_((Block)block, (Variant[])((Variant[])indices.map(i -> this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)models[i]))).toArray(Variant[]::new))));
        blocks.remove(block);
    }

    protected void singleVariantBlockState(Block b, ResourceLocation model) {
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)b, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model)));
    }

    protected void rotatedMirrored(Set<Block> blocks, Block block, ResourceLocation texture) {
        this.rotatedMirroredWithVariants(blocks, block, new ResourceLocation[]{texture});
    }

    protected void rotatedMirroredWithVariants(Set<Block> blocks, Block block, ResourceLocation[] textures) {
        Object[] weights = new Integer[textures.length];
        Arrays.fill(weights, (Object)1);
        this.rotatedMirroredWithVariants(blocks, block, textures, (Integer[])weights);
    }

    protected void rotatedMirroredWithVariants(Set<Block> blocks, Block block, ResourceLocation[] textures, Integer[] weights) {
        int length = textures.length;
        if (length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] models = new ResourceLocation[length];
        ResourceLocation[] mirroredModels = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            ResourceLocation modelId = ModelLocationUtils.m_125578_((Block)block, (String)suffix);
            ResourceLocation mirriredModelId = ModelLocationUtils.m_125578_((Block)block, (String)("_mirrored" + (String)suffix));
            models[i] = ModelTemplates.f_125692_.m_125612_(modelId, TextureMapping.m_125776_((ResourceLocation)textures[i]), this.modelOutput);
            mirroredModels[i] = ModelTemplates.f_125693_.m_125612_(mirriredModelId, TextureMapping.m_125776_((ResourceLocation)textures[i]), this.modelOutput);
        }
        this.rotatedMirroredWithModels(blocks, block, models, mirroredModels, weights);
    }

    protected void rotatedMirroredWithModels(Set<Block> blocks, Block block, ResourceLocation[] models, ResourceLocation[] mirroredModels, Integer[] weights) {
        int length = models.length;
        if (length != mirroredModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        Stream<Integer> indices = IntStream.range(0, length).boxed();
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125259_((Block)block, (Variant[])((Variant[])indices.flatMap(i -> Stream.of(this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)models[i])), this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)mirroredModels[i])), this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)models[i]).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)), this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)mirroredModels[i]).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)))).toArray(Variant[]::new))));
        blocks.remove(block);
    }

    protected void pillar(Set<Block> blocks, Block block, ResourceLocation top, ResourceLocation side) {
        this.pillarWithVariants(blocks, block, new ResourceLocation[]{top}, new ResourceLocation[]{side});
    }

    protected void pillarWithVariants(Set<Block> blocks, Block block, ResourceLocation[] topTextures, ResourceLocation[] sideTextures) {
        Object[] weights = new Integer[topTextures.length];
        Arrays.fill(weights, (Object)1);
        this.pillarWithVariants(blocks, block, topTextures, sideTextures, (Integer[])weights);
    }

    protected void pillarWithVariants(Set<Block> blocks, Block block, ResourceLocation[] topTextures, ResourceLocation[] sideTextures, Integer[] weights) {
        int length = topTextures.length;
        if (length != sideTextures.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] topModels = new ResourceLocation[length];
        ResourceLocation[] horizontalModels = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            ResourceLocation modelIdTop = ModelLocationUtils.m_125578_((Block)block, (String)suffix);
            ResourceLocation modelIdHorizontal = ModelLocationUtils.m_125578_((Block)block, (String)("_horizontal" + (String)suffix));
            topModels[i] = ModelTemplates.f_125694_.m_125612_(modelIdTop, TextureMapping.m_125763_((ResourceLocation)sideTextures[i], (ResourceLocation)topTextures[i]), this.modelOutput);
            horizontalModels[i] = ModelTemplates.f_125695_.m_125612_(modelIdHorizontal, TextureMapping.m_125763_((ResourceLocation)sideTextures[i], (ResourceLocation)topTextures[i]), this.modelOutput);
        }
        this.pillarWithModels(blocks, block, topModels, horizontalModels, weights);
    }

    protected void pillarWithModels(Set<Block> blocks, Block block, ResourceLocation[] topModels, ResourceLocation[] horizontalModels, Integer[] weights) {
        int length = topModels.length;
        if (length != horizontalModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        Stream<Integer> indicesX = IntStream.range(0, length).boxed();
        Stream<Integer> indicesY = IntStream.range(0, length).boxed();
        Stream<Integer> indicesZ = IntStream.range(0, length).boxed();
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61365_).m_125332_((Comparable)Direction.Axis.Y, indicesX.map(i -> this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topModels[i]))).toList()).m_125332_((Comparable)Direction.Axis.Z, indicesY.map(i -> this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)horizontalModels[i]).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90))).toList()).m_125332_((Comparable)Direction.Axis.X, indicesZ.map(i -> this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)horizontalModels[i]).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90))).toList())));
        blocks.remove(block);
    }

    protected void pillarAlt(Set<Block> blocks, Block block, ResourceLocation top, ResourceLocation side) {
        this.pillarAltWithVariants(blocks, block, new ResourceLocation[]{top}, new ResourceLocation[]{side});
    }

    protected void pillarAltWithVariants(Set<Block> blocks, Block block, ResourceLocation[] topTextures, ResourceLocation[] sideTextures) {
        int length = topTextures.length;
        if (length != sideTextures.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] topModels = new ResourceLocation[length];
        ResourceLocation[] horizontalXModels = new ResourceLocation[length];
        ResourceLocation[] horizontalZModels = new ResourceLocation[length];
        ModelTemplate horizontalXTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_column_horizontal_x")), Optional.of("_horizontal_x"), new TextureSlot[]{TextureSlot.f_125870_, TextureSlot.f_125875_});
        ModelTemplate horizontalZTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_column_horizontal_z")), Optional.of("_horizontal_z"), new TextureSlot[]{TextureSlot.f_125870_, TextureSlot.f_125875_});
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            ResourceLocation modelIdTop = ModelLocationUtils.m_125578_((Block)block, (String)suffix);
            ResourceLocation modelIdHorizontalX = ModelLocationUtils.m_125578_((Block)block, (String)("_horizontal_x" + (String)suffix));
            ResourceLocation modelIdHorizontalZ = ModelLocationUtils.m_125578_((Block)block, (String)("_horizontal_z" + (String)suffix));
            topModels[i] = ModelTemplates.f_125694_.m_125612_(modelIdTop, TextureMapping.m_125763_((ResourceLocation)sideTextures[i], (ResourceLocation)topTextures[i]), this.modelOutput);
            horizontalXModels[i] = horizontalXTemplate.m_125612_(modelIdHorizontalX, TextureMapping.m_125763_((ResourceLocation)sideTextures[i], (ResourceLocation)topTextures[i]), this.modelOutput);
            horizontalZModels[i] = horizontalZTemplate.m_125612_(modelIdHorizontalZ, TextureMapping.m_125763_((ResourceLocation)sideTextures[i], (ResourceLocation)topTextures[i]), this.modelOutput);
        }
        this.pillarAltWithModels(blocks, block, topModels, horizontalXModels, horizontalZModels);
    }

    protected void pillarAltWithModels(Set<Block> blocks, Block block, ResourceLocation[] yModels, ResourceLocation[] xModels, ResourceLocation[] zModels) {
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61365_).m_125332_((Comparable)Direction.Axis.Y, Stream.of(yModels).map(rl -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, rl)).toList()).m_125332_((Comparable)Direction.Axis.X, Stream.of(xModels).map(rl -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, rl)).toList()).m_125332_((Comparable)Direction.Axis.Z, Stream.of(zModels).map(rl -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, rl)).toList())));
        blocks.remove(block);
    }

    protected void directionalPillar(Set<Block> blocks, Block block, ResourceLocation top, ResourceLocation bottom, ResourceLocation side) {
        this.directionalPillarWithVariants(blocks, block, new ResourceLocation[]{top}, new ResourceLocation[]{top}, new ResourceLocation[]{side});
    }

    protected void directionalPillarWithVariants(Set<Block> blocks, Block block, ResourceLocation[] topTextures, ResourceLocation[] bottomTextures, ResourceLocation[] sideTextures) {
        Object[] weights = new Integer[topTextures.length];
        Arrays.fill(weights, (Object)1);
        this.directionalPillarWithVariants(blocks, block, topTextures, bottomTextures, sideTextures, (Integer[])weights);
    }

    protected void directionalPillarWithVariants(Set<Block> blocks, Block block, ResourceLocation[] topTextures, ResourceLocation[] bottomTextures, ResourceLocation[] sideTextures, Integer[] weights) {
        int length = topTextures.length;
        if (length != bottomTextures.length || length != sideTextures.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] topModels = new ResourceLocation[length];
        ResourceLocation[] horizontalModels = new ResourceLocation[length];
        ModelTemplate topTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_column_directional")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125872_, TextureSlot.f_125871_, TextureSlot.f_125875_});
        ModelTemplate horizontalTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_column_directional_horizontal")), Optional.of("_horizontal"), new TextureSlot[]{TextureSlot.f_125872_, TextureSlot.f_125871_, TextureSlot.f_125875_});
        for (int i = 0; i < length; ++i) {
            TextureMapping mapping = new TextureMapping().m_125758_(TextureSlot.f_125875_, sideTextures[i]).m_125758_(TextureSlot.f_125872_, topTextures[i]).m_125758_(TextureSlot.f_125871_, bottomTextures[i]);
            Object suffix = i == 0 ? "" : "_" + i;
            ResourceLocation modelIdTop = ModelLocationUtils.m_125578_((Block)block, (String)suffix);
            ResourceLocation modelIdHorizontal = ModelLocationUtils.m_125578_((Block)block, (String)("_horizontal" + (String)suffix));
            topModels[i] = topTemplate.m_125612_(modelIdTop, mapping, this.modelOutput);
            horizontalModels[i] = horizontalTemplate.m_125612_(modelIdHorizontal, mapping, this.modelOutput);
        }
        this.directionalPillarWithModels(blocks, block, topModels, horizontalModels, weights);
    }

    protected void directionalPillarWithModels(Set<Block> blocks, Block block, ResourceLocation[] topModels, ResourceLocation[] horizontalModels, Integer[] weights) {
        int length = topModels.length;
        if (length != horizontalModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        Stream<Integer> indicesUp = IntStream.range(0, length).boxed();
        Stream<Integer> indicesDown = IntStream.range(0, length).boxed();
        Stream<Integer> indicesNorth = IntStream.range(0, length).boxed();
        Stream<Integer> indicesSouth = IntStream.range(0, length).boxed();
        Stream<Integer> indicesEast = IntStream.range(0, length).boxed();
        Stream<Integer> indicesWest = IntStream.range(0, length).boxed();
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61372_).m_125332_((Comparable)Direction.UP, indicesUp.map(i -> this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topModels[i]))).toList()).m_125332_((Comparable)Direction.DOWN, indicesDown.map(i -> this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topModels[i]).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180))).toList()).m_125332_((Comparable)Direction.NORTH, indicesNorth.map(i -> this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)horizontalModels[i]))).toList()).m_125332_((Comparable)Direction.SOUTH, indicesSouth.map(i -> this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)horizontalModels[i]).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180))).toList()).m_125332_((Comparable)Direction.EAST, indicesEast.map(i -> this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)horizontalModels[i]).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90))).toList()).m_125332_((Comparable)Direction.WEST, indicesWest.map(i -> this.maybeWeight(weights[i], Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)horizontalModels[i]).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270))).toList())));
        blocks.remove(block);
    }

    protected <T> Variant withMaybe(VariantProperty<T> property, T value, boolean shouldAdd, Variant variant) {
        if (shouldAdd) {
            variant.m_125511_(property, value);
        }
        return variant;
    }

    protected Variant maybeUVLock(Boolean uvlock, Variant variant) {
        return this.withMaybe(VariantProperties.f_125521_, uvlock, uvlock, variant);
    }

    protected Variant maybeWeight(int weight, Variant variant) {
        return this.withMaybe(VariantProperties.f_125522_, weight, weight != 1, variant);
    }

    protected Variant maybeXRot(VariantProperties.Rotation rotation, Variant variant) {
        return this.withMaybe(VariantProperties.f_125518_, rotation, rotation != VariantProperties.Rotation.R0, variant);
    }

    protected Variant maybeYRot(VariantProperties.Rotation rotation, Variant variant) {
        return this.withMaybe(VariantProperties.f_125519_, rotation, rotation != VariantProperties.Rotation.R0, variant);
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Set<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            BotaniaAPI.LOGGER.warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            BotaniaAPI.LOGGER.warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            BotaniaAPI.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }

    protected void redStringBlock(Block b) {
        ResourceLocation selfName = TextureMapping.m_125740_((Block)b);
        ResourceLocation front = ResourceLocationHelper.prefix("block/red_string_sender");
        ResourceLocation model = ModelTemplates.f_125698_.m_125592_(b, new TextureMapping().m_125758_(TextureSlot.f_125872_, selfName).m_125758_(TextureSlot.f_125873_, front).m_125758_(TextureSlot.f_125875_, selfName), this.modelOutput);
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)b, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model)).m_125271_(BlockModelGeneratorsAccessor.facingDispatch()));
    }
}

