/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaTabletItem
extends Item {
    public static final int MAX_MANA = 500000;
    private static final String TAG_MANA = "mana";
    private static final String TAG_CREATIVE = "creative";
    private static final String TAG_ONE_USE = "oneUse";

    public ManaTabletItem(Item.Properties props) {
        super(props);
    }

    public void m_6787_(@NotNull CreativeModeTab tab, @NotNull NonNullList<ItemStack> stacks) {
        if (this.m_220152_(tab)) {
            stacks.add((Object)new ItemStack((ItemLike)this));
            ItemStack fullPower = new ItemStack((ItemLike)this);
            ManaTabletItem.setMana(fullPower, 500000);
            stacks.add((Object)fullPower);
            ItemStack creative = new ItemStack((ItemLike)this);
            ManaTabletItem.setMana(creative, 500000);
            ManaTabletItem.setStackCreative(creative);
            stacks.add((Object)creative);
        }
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack stack) {
        return ManaTabletItem.isStackCreative(stack) ? Rarity.EPIC : super.m_41460_(stack);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> stacks, TooltipFlag flags) {
        if (ManaTabletItem.isStackCreative(stack)) {
            stacks.add((Component)Component.m_237115_((String)"botaniamisc.creative").m_130940_(ChatFormatting.GRAY));
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(ManaBarTooltip.fromManaItem(stack));
    }

    protected static void setMana(ItemStack stack, int mana) {
        if (mana > 0) {
            ItemNBTHelper.setInt(stack, TAG_MANA, mana);
        } else {
            ItemNBTHelper.removeEntry(stack, TAG_MANA);
        }
    }

    public static void setStackCreative(ItemStack stack) {
        ItemNBTHelper.setBoolean(stack, TAG_CREATIVE, true);
    }

    public static boolean isStackCreative(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_CREATIVE, false);
    }

    public boolean m_142522_(ItemStack stack) {
        return !ManaTabletItem.isStackCreative(stack);
    }

    public int m_142158_(ItemStack stack) {
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
        return Math.round(13.0f * ManaBarTooltip.getFractionForDisplay(manaItem));
    }

    public int m_142159_(ItemStack stack) {
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
        return Mth.m_14169_((float)(ManaBarTooltip.getFractionForDisplay(manaItem) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static class ManaItemImpl
    implements ManaItem {
        private final ItemStack stack;

        public ManaItemImpl(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public int getMana() {
            if (ManaTabletItem.isStackCreative(this.stack)) {
                return this.getMaxMana();
            }
            return ItemNBTHelper.getInt(this.stack, ManaTabletItem.TAG_MANA, 0) * this.stack.m_41613_();
        }

        @Override
        public int getMaxMana() {
            return (ManaTabletItem.isStackCreative(this.stack) ? 501000 : 500000) * this.stack.m_41613_();
        }

        @Override
        public void addMana(int mana) {
            if (!ManaTabletItem.isStackCreative(this.stack)) {
                ManaTabletItem.setMana(this.stack, Math.min(this.getMana() + mana, this.getMaxMana()) / this.stack.m_41613_());
            }
        }

        @Override
        public boolean canReceiveManaFromPool(BlockEntity pool) {
            return !ItemNBTHelper.getBoolean(this.stack, ManaTabletItem.TAG_ONE_USE, false);
        }

        @Override
        public boolean canReceiveManaFromItem(ItemStack otherStack) {
            return !ManaTabletItem.isStackCreative(this.stack);
        }

        @Override
        public boolean canExportManaToPool(BlockEntity pool) {
            return true;
        }

        @Override
        public boolean canExportManaToItem(ItemStack otherStack) {
            return true;
        }

        @Override
        public boolean isNoExport() {
            return false;
        }
    }
}

