/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.advancements.GaiaGuardianNoArmorTrigger;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.MagicLandmineEntity;
import vazkii.botania.common.entity.MagicMissileEntity;
import vazkii.botania.common.entity.PixieEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.mixin.MobEffectAccessor;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.network.clientbound.SpawnGaiaGuardianPacket;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

public class GaiaGuardianEntity
extends Mob {
    public static final float ARENA_RANGE = 12.0f;
    public static final int ARENA_HEIGHT = 5;
    private static final int SPAWN_TICKS = 160;
    public static final float MAX_HP = 320.0f;
    public static final Supplier<IMultiblock> ARENA_MULTIBLOCK = Suppliers.memoize(() -> {
        IStateMatcher beaconBase = PatchouliAPI.get().predicateMatcher(Blocks.f_50075_, state -> state.m_204336_(BlockTags.f_13079_));
        return PatchouliAPI.get().makeMultiblock((String[][])new String[][]{{"P_______P", "_________", "_________", "_________", "_________", "_________", "_________", "_________", "P_______P"}, {"_________", "_________", "_________", "_________", "____B____", "_________", "_________", "_________", "_________"}, {"_________", "_________", "_________", "___III___", "___I0I___", "___III___", "_________", "_________", "_________"}}, new Object[]{Character.valueOf('P'), BotaniaBlocks.gaiaPylon, Character.valueOf('B'), Blocks.f_50273_, Character.valueOf('I'), beaconBase, Character.valueOf('0'), beaconBase});
    });
    private static final int MOB_SPAWN_START_TICKS = 20;
    private static final int MOB_SPAWN_END_TICKS = 80;
    private static final int MOB_SPAWN_BASE_TICKS = 800;
    private static final int MOB_SPAWN_TICKS = 900;
    private static final int MOB_SPAWN_WAVES = 10;
    private static final int MOB_SPAWN_WAVE_TIME = 80;
    private static final int DAMAGE_CAP = 32;
    private static final String TAG_INVUL_TIME = "invulTime";
    private static final String TAG_AGGRO = "aggro";
    private static final String TAG_SOURCE_X = "sourceX";
    private static final String TAG_SOURCE_Y = "sourceY";
    private static final String TAG_SOURCE_Z = "sourcesZ";
    private static final String TAG_MOB_SPAWN_TICKS = "mobSpawnTicks";
    private static final String TAG_HARD_MODE = "hardMode";
    private static final String TAG_PLAYER_COUNT = "playerCount";
    private static final TagKey<Block> BLACKLIST = BotaniaTags.Blocks.GAIA_BREAK_BLACKLIST;
    private static final EntityDataAccessor<Integer> INVUL_TIME = SynchedEntityData.m_135353_(GaiaGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final List<BlockPos> PYLON_LOCATIONS = ImmutableList.of((Object)new BlockPos(4, 1, 4), (Object)new BlockPos(4, 1, -4), (Object)new BlockPos(-4, 1, 4), (Object)new BlockPos(-4, 1, -4));
    private static final List<ResourceLocation> CHEATY_BLOCKS = Arrays.asList(new ResourceLocation("openblocks", "beartrap"), new ResourceLocation("thaumictinkerer", "magnet"));
    private boolean spawnLandmines = false;
    private boolean spawnPixies = false;
    private boolean anyWithArmor = false;
    private boolean aggro = false;
    private int tpDelay = 0;
    private int mobSpawnTicks = 0;
    private int playerCount = 0;
    private boolean hardMode = false;
    private BlockPos source = BlockPos.f_121853_;
    private final List<UUID> playersWhoAttacked = new ArrayList<UUID>();
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(BotaniaEntities.DOPPLEGANGER.m_20676_(), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS).m_7006_(true);
    private UUID bossInfoUUID = this.bossInfo.m_18860_();
    public Player trueKiller = null;

    public GaiaGuardianEntity(EntityType<GaiaGuardianEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 825;
        if (world.f_46443_) {
            Proxy.INSTANCE.addBoss(this);
        }
    }

    public static boolean spawn(Player player, ItemStack stack, Level world, BlockPos pos, boolean hard) {
        if (!(world.m_7702_(pos) instanceof BeaconBlockEntity) || !PlayerHelper.isTruePlayer((Entity)player) || GaiaGuardianEntity.countGaiaGuardiansAround(world, pos) > 0) {
            return false;
        }
        if (world.m_46791_() == Difficulty.PEACEFUL) {
            if (!world.f_46443_) {
                player.m_213846_((Component)Component.m_237115_((String)"botaniamisc.peacefulNoob").m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        List<BlockPos> invalidPylonBlocks = GaiaGuardianEntity.checkPylons(world, pos);
        if (!invalidPylonBlocks.isEmpty()) {
            if (world.f_46443_) {
                GaiaGuardianEntity.warnInvalidBlocks(world, invalidPylonBlocks);
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"botaniamisc.needsCatalysts").m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        List<BlockPos> invalidArenaBlocks = GaiaGuardianEntity.checkArena(world, pos);
        if (!invalidArenaBlocks.isEmpty()) {
            if (world.f_46443_) {
                GaiaGuardianEntity.warnInvalidBlocks(world, invalidArenaBlocks);
            } else {
                XplatAbstractions.INSTANCE.sendToPlayer(player, new BotaniaEffectPacket(EffectType.ARENA_INDICATOR, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), new int[0]));
                player.m_213846_((Component)Component.m_237115_((String)"botaniamisc.badArena").m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        if (!world.f_46443_) {
            int playerCount;
            stack.m_41774_(1);
            GaiaGuardianEntity e = (GaiaGuardianEntity)BotaniaEntities.DOPPLEGANGER.m_20615_(world);
            e.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 3, (double)pos.m_123343_() + 0.5);
            e.setInvulTime(160);
            e.m_21153_(1.0f);
            e.source = pos;
            e.mobSpawnTicks = 900;
            e.hardMode = hard;
            e.playerCount = playerCount = e.getPlayersAround().size();
            float healthMultiplier = 1.0f;
            if (playerCount > 1) {
                healthMultiplier += (float)playerCount * 0.25f;
            }
            e.m_21051_(Attributes.f_22276_).m_22100_((double)(320.0f * healthMultiplier));
            if (hard) {
                e.m_21051_(Attributes.f_22284_).m_22100_(15.0);
            }
            e.m_5496_(BotaniaSounds.gaiaSummon, 1.0f, 1.0f);
            e.m_6518_((ServerLevelAccessor)world, world.m_6436_(e.m_20183_()), MobSpawnType.EVENT, null, null);
            world.m_7967_((Entity)e);
        }
        return true;
    }

    private static List<BlockPos> checkPylons(Level world, BlockPos beaconPos) {
        ArrayList<BlockPos> invalidPylonBlocks = new ArrayList<BlockPos>();
        for (BlockPos coords : PYLON_LOCATIONS) {
            BlockPos pos_ = beaconPos.m_121955_((Vec3i)coords);
            BlockState state = world.m_8055_(pos_);
            if (state.m_60713_(BotaniaBlocks.gaiaPylon)) continue;
            invalidPylonBlocks.add(pos_);
        }
        return invalidPylonBlocks;
    }

    private static List<BlockPos> checkArena(Level world, BlockPos beaconPos) {
        ArrayList<BlockPos> trippedPositions = new ArrayList<BlockPos>();
        int range = (int)Math.ceil(12.0);
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (Math.abs(x) == 4 && Math.abs(z) == 4 || MathHelper.pointDistancePlane(x, z, 0.0, 0.0) > 12.0f) continue;
                boolean hasFloor = false;
                for (int y = -2; y <= 5; ++y) {
                    boolean isBlockHere;
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos pos = beaconPos.m_7918_(x, y, z);
                    BlockState state = world.m_8055_(pos);
                    boolean allowBlockHere = y < 0;
                    boolean bl = isBlockHere = !state.m_60812_((BlockGetter)world, pos).m_83281_();
                    if (allowBlockHere && isBlockHere) {
                        hasFloor = true;
                    }
                    if (y == 0 && !hasFloor) {
                        trippedPositions.add(pos.m_7495_());
                    }
                    if (allowBlockHere || !isBlockHere || state.m_204336_(BLACKLIST)) continue;
                    trippedPositions.add(pos);
                }
            }
        }
        return trippedPositions;
    }

    private static void warnInvalidBlocks(Level world, Iterable<BlockPos> invalidPositions) {
        WispParticleData data = WispParticleData.wisp(0.5f, 1.0f, 0.2f, 0.2f, 8.0f, false);
        for (BlockPos pos_ : invalidPositions) {
            world.m_7106_((ParticleOptions)data, (double)pos_.m_123341_() + 0.5, (double)pos_.m_123342_() + 0.5, (double)pos_.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 18.0f));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INVUL_TIME, (Object)0);
    }

    public int getInvulTime() {
        return (Integer)this.f_19804_.m_135370_(INVUL_TIME);
    }

    public BlockPos getSource() {
        return this.source;
    }

    public void setInvulTime(int time) {
        this.f_19804_.m_135381_(INVUL_TIME, (Object)time);
    }

    public void m_7380_(CompoundTag cmp) {
        super.m_7380_(cmp);
        cmp.m_128405_(TAG_INVUL_TIME, this.getInvulTime());
        cmp.m_128379_(TAG_AGGRO, this.aggro);
        cmp.m_128405_(TAG_MOB_SPAWN_TICKS, this.mobSpawnTicks);
        cmp.m_128405_(TAG_SOURCE_X, this.source.m_123341_());
        cmp.m_128405_(TAG_SOURCE_Y, this.source.m_123342_());
        cmp.m_128405_(TAG_SOURCE_Z, this.source.m_123343_());
        cmp.m_128379_(TAG_HARD_MODE, this.hardMode);
        cmp.m_128405_(TAG_PLAYER_COUNT, this.playerCount);
    }

    public void m_7378_(CompoundTag cmp) {
        super.m_7378_(cmp);
        this.setInvulTime(cmp.m_128451_(TAG_INVUL_TIME));
        this.aggro = cmp.m_128471_(TAG_AGGRO);
        this.mobSpawnTicks = cmp.m_128451_(TAG_MOB_SPAWN_TICKS);
        int x = cmp.m_128451_(TAG_SOURCE_X);
        int y = cmp.m_128451_(TAG_SOURCE_Y);
        int z = cmp.m_128451_(TAG_SOURCE_Z);
        this.source = new BlockPos(x, y, z);
        this.hardMode = cmp.m_128471_(TAG_HARD_MODE);
        this.playerCount = cmp.m_128441_(TAG_PLAYER_COUNT) ? cmp.m_128451_(TAG_PLAYER_COUNT) : 1;
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_5634_(float amount) {
        if (this.getInvulTime() == 0) {
            super.m_5634_(amount);
        }
    }

    public void m_6074_() {
        this.m_21153_(0.0f);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Entity e = source.m_7639_();
        if (e instanceof Player) {
            Player player = (Player)e;
            if (PlayerHelper.isTruePlayer(e) && this.getInvulTime() == 0) {
                if (!this.playersWhoAttacked.contains(player.m_20148_())) {
                    this.playersWhoAttacked.add(player.m_20148_());
                }
                return super.m_6469_(source, Math.min(32.0f, amount));
            }
        }
        return false;
    }

    protected void m_6475_(@NotNull DamageSource source, float amount) {
        super.m_6475_(source, Math.min(32.0f, amount));
        Entity attacker = source.m_7640_();
        if (attacker != null) {
            Vec3 thisVector = VecHelper.fromEntityCenter((Entity)this);
            Vec3 playerVector = VecHelper.fromEntityCenter(attacker);
            Vec3 motionVector = thisVector.m_82546_(playerVector).m_82541_().m_82490_(0.75);
            if (this.m_21223_() > 0.0f) {
                this.m_20334_(-motionVector.f_82479_, 0.5, -motionVector.f_82481_);
                this.tpDelay = 4;
                this.spawnPixies = true;
            }
        }
        this.f_19802_ = Math.max(this.f_19802_, 20);
    }

    protected float m_21161_(DamageSource source, float damage) {
        return super.m_21161_(source, Math.min(32.0f, damage));
    }

    public void m_6667_(@NotNull DamageSource source) {
        super.m_6667_(source);
        LivingEntity lastAttacker = this.m_21232_();
        if (!this.f_19853_.f_46443_) {
            for (UUID u : this.playersWhoAttacked) {
                DamageSource currSource;
                Player player = this.f_19853_.m_46003_(u);
                if (!PlayerHelper.isTruePlayer((Entity)player)) continue;
                DamageSource damageSource = currSource = player == lastAttacker ? source : DamageSource.m_19344_((Player)player);
                if (player != lastAttacker) {
                    CriteriaTriggers.f_10568_.m_48104_((ServerPlayer)player, (Entity)this, currSource);
                }
                if (this.anyWithArmor) continue;
                GaiaGuardianNoArmorTrigger.INSTANCE.trigger((ServerPlayer)player, this, currSource);
            }
            for (Player player : this.getPlayersAround()) {
                if (player.m_21124_(MobEffects.f_19615_) == null) continue;
                player.m_21195_(MobEffects.f_19615_);
            }
            for (PixieEntity pixie : this.f_19853_.m_6443_(PixieEntity.class, GaiaGuardianEntity.getArenaBB(this.getSource()), p -> p.m_6084_() && p.getPixieType() == 1)) {
                pixie.m_21373_();
                pixie.m_146870_();
            }
            for (MagicLandmineEntity landmine : this.f_19853_.m_45976_(MagicLandmineEntity.class, GaiaGuardianEntity.getArenaBB(this.getSource()))) {
                landmine.m_146870_();
            }
        }
        this.m_5496_(BotaniaSounds.gaiaDeath, 1.0f, (1.0f + (this.f_19853_.f_46441_.m_188501_() - this.f_19853_.f_46441_.m_188501_()) * 0.2f) * 0.7f);
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0, 0.0, 0.0);
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public ResourceLocation m_7582_() {
        if (this.mobSpawnTicks > 0) {
            return BuiltInLootTables.f_78712_;
        }
        return ResourceLocationHelper.prefix(this.hardMode ? "gaia_guardian_2" : "gaia_guardian");
    }

    protected void m_7625_(@NotNull DamageSource source, boolean wasRecentlyHit) {
        if (wasRecentlyHit && PlayerHelper.isTruePlayer(source.m_7639_())) {
            this.trueKiller = (Player)source.m_7639_();
        }
        for (UUID u : this.playersWhoAttacked) {
            Player player = this.f_19853_.m_46003_(u);
            if (!PlayerHelper.isTruePlayer((Entity)player)) continue;
            Player saveLastAttacker = this.f_20888_;
            Vec3 savePos = this.m_20182_();
            this.f_20888_ = player;
            this.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            super.m_7625_(DamageSource.m_19344_((Player)player), wasRecentlyHit);
            this.m_6034_(savePos.m_7096_(), savePos.m_7098_(), savePos.m_7094_());
            this.f_20888_ = saveLastAttacker;
        }
        this.trueKiller = null;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (this.f_19853_.f_46443_) {
            Proxy.INSTANCE.removeBoss(this);
        }
        super.m_142687_(reason);
    }

    public List<Player> getPlayersAround() {
        return PlayerHelper.getRealPlayersIn(this.f_19853_, GaiaGuardianEntity.getArenaBB(this.source));
    }

    public int getPlayerCount() {
        return this.playerCount;
    }

    private static int countGaiaGuardiansAround(Level world, BlockPos source) {
        List l = world.m_45976_(GaiaGuardianEntity.class, GaiaGuardianEntity.getArenaBB(source));
        return l.size();
    }

    @NotNull
    private static AABB getArenaBB(@NotNull BlockPos source) {
        double range = 15.0;
        return new AABB((double)source.m_123341_() + 0.5 - range, (double)source.m_123342_() + 0.5 - range, (double)source.m_123343_() + 0.5 - range, (double)source.m_123341_() + 0.5 + range, (double)source.m_123342_() + 0.5 + range, (double)source.m_123343_() + 0.5 + range);
    }

    private void particles() {
        float rad;
        for (int i = 0; i < 360; i += 8) {
            float r = 0.6f;
            float g = 0.0f;
            float b = 0.2f;
            float m = 0.15f;
            float mv = 0.35f;
            rad = (float)i * (float)Math.PI / 180.0f;
            double x = (double)this.source.m_123341_() + 0.5 - Math.cos(rad) * 12.0;
            double y = (double)this.source.m_123342_() + 0.5;
            double z = (double)this.source.m_123343_() + 0.5 - Math.sin(rad) * 12.0;
            WispParticleData data = WispParticleData.wisp(0.5f, r, g, b);
            this.f_19853_.m_7106_((ParticleOptions)data, x, y, z, (double)((float)(Math.random() - 0.5) * m), (double)((float)(Math.random() - 0.5) * mv), (double)((float)(Math.random() - 0.5) * m));
        }
        if (this.getInvulTime() > 10) {
            Vec3 pos = VecHelper.fromEntityCenter((Entity)this).m_82492_(0.0, 0.2, 0.0);
            for (BlockPos arr : PYLON_LOCATIONS) {
                Vec3 pylonPos = new Vec3((double)(this.source.m_123341_() + arr.m_123341_()), (double)(this.source.m_123342_() + arr.m_123342_()), (double)(this.source.m_123343_() + arr.m_123343_()));
                double worldTime = this.f_19797_;
                rad = 0.75f + (float)Math.random() * 0.05f;
                double xp = pylonPos.f_82479_ + 0.5 + Math.cos(worldTime /= 5.0) * (double)rad;
                double zp = pylonPos.f_82481_ + 0.5 + Math.sin(worldTime) * (double)rad;
                Vec3 partPos = new Vec3(xp, pylonPos.f_82480_, zp);
                Vec3 mot = pos.m_82546_(partPos).m_82490_(0.04);
                float r = 0.7f + (float)Math.random() * 0.3f;
                float g = (float)Math.random() * 0.3f;
                float b = 0.7f + (float)Math.random() * 0.3f;
                WispParticleData data = WispParticleData.wisp(0.25f + (float)Math.random() * 0.1f, r, g, b, 1.0f);
                this.f_19853_.m_7106_((ParticleOptions)data, partPos.f_82479_, partPos.f_82480_, partPos.f_82481_, 0.0, (double)(-(-0.075f - (float)Math.random() * 0.015f)), 0.0);
                WispParticleData data1 = WispParticleData.wisp(0.4f, r, g, b);
                this.f_19853_.m_7106_((ParticleOptions)data1, partPos.f_82479_, partPos.f_82480_, partPos.f_82481_, (double)((float)mot.f_82479_), (double)((float)mot.f_82480_), (double)((float)mot.f_82481_));
            }
        }
    }

    private void smashBlocksAround(int centerX, int centerY, int centerZ, int radius) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius + 1; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    int x = centerX + dx;
                    int y = centerY + dy;
                    int z = centerZ + dz;
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = this.f_19853_.m_8055_(pos);
                    Block block = state.m_60734_();
                    if (state.m_60800_((BlockGetter)this.f_19853_, pos) == -1.0f) continue;
                    if (CHEATY_BLOCKS.contains(Registry.f_122824_.m_7981_((Object)block))) {
                        this.f_19853_.m_46961_(pos, true);
                        continue;
                    }
                    if (state.m_204336_(BLACKLIST) || y < this.source.m_123342_() || Math.abs(this.source.m_123341_() - x) == 4 && Math.abs(this.source.m_123343_() - z) == 4) continue;
                    this.f_19853_.m_46961_(pos, true);
                }
            }
        }
    }

    private void clearPotions(Player player) {
        HashSet<MobEffect> effectsToRemove = new HashSet<MobEffect>();
        for (MobEffectInstance effectInstance : player.m_21220_()) {
            if (effectInstance.m_19557_() >= 160 || !effectInstance.m_19571_() || ((MobEffectAccessor)effectInstance.m_19544_()).getType() == MobEffectCategory.HARMFUL) continue;
            effectsToRemove.add(effectInstance.m_19544_());
        }
        for (MobEffect effect : effectsToRemove) {
            player.m_21195_(effect);
            ((ServerLevel)this.f_19853_).m_7726_().m_8394_((Entity)player, (Packet)new ClientboundRemoveMobEffectPacket(player.m_19879_(), effect));
        }
    }

    private void keepInsideArena(Player player) {
        if (MathHelper.pointDistanceSpace(player.m_20185_(), player.m_20186_(), player.m_20189_(), (double)this.source.m_123341_() + 0.5, (double)this.source.m_123342_() + 0.5, (double)this.source.m_123343_() + 0.5) >= 12.0f) {
            Vec3 sourceVector = new Vec3((double)this.source.m_123341_() + 0.5, (double)this.source.m_123342_() + 0.5, (double)this.source.m_123343_() + 0.5);
            Vec3 playerVector = VecHelper.fromEntityCenter((Entity)player);
            Vec3 motion = sourceVector.m_82546_(playerVector).m_82541_();
            player.m_20334_(motion.f_82479_, 0.2, motion.f_82481_);
            player.f_19864_ = true;
        }
    }

    private void spawnMobs(List<Player> players) {
        for (int pl = 0; pl < this.playerCount; ++pl) {
            for (int i = 0; i < 3 + this.f_19853_.f_46441_.m_188503_(2); ++i) {
                WitherSkeleton entity;
                switch (this.f_19853_.f_46441_.m_188503_(3)) {
                    case 0: {
                        WitherSkeleton witherSkeleton;
                        if (this.f_19853_.f_46441_.m_188503_(this.hardMode ? 3 : 12) == 0) {
                            witherSkeleton = (Witch)EntityType.f_20495_.m_20615_(this.f_19853_);
                            break;
                        }
                        witherSkeleton = (Zombie)EntityType.f_20501_.m_20615_(this.f_19853_);
                        break;
                    }
                    case 1: {
                        WitherSkeleton witherSkeleton;
                        if (this.f_19853_.f_46441_.m_188503_(8) == 0) {
                            witherSkeleton = (WitherSkeleton)EntityType.f_20497_.m_20615_(this.f_19853_);
                            break;
                        }
                        witherSkeleton = (Skeleton)EntityType.f_20524_.m_20615_(this.f_19853_);
                        break;
                    }
                    case 2: {
                        if (!players.isEmpty()) {
                            for (int j = 0; j < 1 + this.f_19853_.f_46441_.m_188503_(this.hardMode ? 8 : 5); ++j) {
                                PixieEntity pixie = new PixieEntity(this.f_19853_);
                                pixie.setProps((LivingEntity)players.get(this.f_19796_.m_188503_(players.size())), (LivingEntity)this, 1, 8.0f);
                                pixie.m_6034_(this.m_20185_() + (double)(this.m_20205_() / 2.0f), this.m_20186_() + 2.0, this.m_20189_() + (double)(this.m_20205_() / 2.0f));
                                pixie.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(pixie.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                                this.f_19853_.m_7967_((Entity)pixie);
                            }
                        }
                        WitherSkeleton witherSkeleton = null;
                        break;
                    }
                    default: {
                        WitherSkeleton witherSkeleton = entity = null;
                    }
                }
                if (entity == null) continue;
                if (!entity.m_5825_()) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 600, 0));
                }
                float range = 6.0f;
                entity.m_6034_(this.m_20185_() + 0.5 + Math.random() * (double)range - (double)(range / 2.0f), this.m_20186_() - 1.0, this.m_20189_() + 0.5 + Math.random() * (double)range - (double)(range / 2.0f));
                entity.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(entity.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                if (entity instanceof WitherSkeleton && this.hardMode) {
                    entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)BotaniaItems.elementiumSword));
                }
                this.f_19853_.m_7967_((Entity)entity);
            }
        }
    }

    public void m_8107_() {
        boolean spawnMissiles;
        super.m_8107_();
        int invul = this.getInvulTime();
        if (this.f_19853_.f_46443_) {
            this.particles();
            Player player = Proxy.INSTANCE.getClientPlayer();
            if (this.getPlayersAround().contains(player)) {
                player.m_150110_().f_35935_ &= player.m_150110_().f_35937_;
            }
            return;
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.m_20159_()) {
            this.m_8127_();
        }
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
        this.smashBlocksAround(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20186_()), Mth.m_14107_((double)this.m_20189_()), 1);
        List<Player> players = this.getPlayersAround();
        if (players.isEmpty() && !this.f_19853_.m_6907_().isEmpty()) {
            this.m_146870_();
        } else {
            for (Player player : players) {
                for (EquipmentSlot e : EquipmentSlot.values()) {
                    if (e.m_20743_() != EquipmentSlot.Type.ARMOR || player.m_6844_(e).m_41619_()) continue;
                    this.anyWithArmor = true;
                    break;
                }
                if (player.m_5803_()) {
                    player.m_5796_();
                }
                this.clearPotions(player);
                this.keepInsideArena(player);
                player.m_150110_().f_35935_ &= player.m_150110_().f_35937_;
            }
        }
        if (!this.m_6084_() || players.isEmpty()) {
            return;
        }
        boolean bl = spawnMissiles = this.hardMode && this.f_19797_ % 15 < 4;
        if (invul > 0 && this.mobSpawnTicks == 900) {
            if (invul < 160 && invul > 80 && this.f_19853_.f_46441_.m_188503_(160 - invul + 1) == 0) {
                for (int i = 0; i < 2; ++i) {
                    this.m_21373_();
                }
            }
            this.m_21153_(this.m_21223_() + (this.m_21233_() - 1.0f) / 160.0f);
            this.setInvulTime(invul - 1);
            this.m_20334_(this.m_20184_().m_7096_(), 0.0, this.m_20184_().m_7094_());
        } else if (this.aggro) {
            boolean dying;
            boolean bl2 = dying = (double)(this.m_21223_() / this.m_21233_()) < 0.2;
            if (dying && this.mobSpawnTicks > 0) {
                this.m_20256_(Vec3.f_82478_);
                int reverseTicks = 900 - this.mobSpawnTicks;
                if (reverseTicks < 20) {
                    this.m_20334_(this.m_20184_().m_7096_(), 0.2, this.m_20184_().m_7094_());
                    this.setInvulTime(invul + 1);
                }
                if (reverseTicks > 40 && this.mobSpawnTicks > 80 && this.mobSpawnTicks % 80 == 0) {
                    this.spawnMobs(players);
                    if (this.hardMode && this.f_19797_ % 3 < 2) {
                        for (i = 0; i < this.playerCount; ++i) {
                            this.spawnMissile();
                        }
                        spawnMissiles = false;
                    }
                }
                --this.mobSpawnTicks;
                this.tpDelay = 10;
            } else if (this.tpDelay > 0) {
                if (invul > 0) {
                    this.setInvulTime(invul - 1);
                }
                --this.tpDelay;
                if (this.tpDelay == 0 && this.m_21223_() > 0.0f) {
                    this.teleportRandomly();
                    if (this.spawnLandmines) {
                        int count = dying && this.hardMode ? 7 : 6;
                        for (i = 0; i < count; ++i) {
                            int x = this.source.m_123341_() - 10 + this.f_19796_.m_188503_(20);
                            int y = (int)players.get(this.f_19796_.m_188503_(players.size())).m_20186_();
                            int z = this.source.m_123343_() - 10 + this.f_19796_.m_188503_(20);
                            MagicLandmineEntity landmine = (MagicLandmineEntity)BotaniaEntities.MAGIC_LANDMINE.m_20615_(this.f_19853_);
                            landmine.m_6034_((double)x + 0.5, y, (double)z + 0.5);
                            landmine.summoner = this;
                            this.f_19853_.m_7967_((Entity)landmine);
                        }
                    }
                    for (int pl = 0; pl < this.playerCount; ++pl) {
                        for (i = 0; i < (this.spawnPixies ? this.f_19853_.f_46441_.m_188503_(this.hardMode ? 6 : 3) : 1); ++i) {
                            PixieEntity pixie = new PixieEntity(this.f_19853_);
                            pixie.setProps((LivingEntity)players.get(this.f_19796_.m_188503_(players.size())), (LivingEntity)this, 1, 8.0f);
                            pixie.m_6034_(this.m_20185_() + (double)(this.m_20205_() / 2.0f), this.m_20186_() + 2.0, this.m_20189_() + (double)(this.m_20205_() / 2.0f));
                            pixie.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(pixie.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                            this.f_19853_.m_7967_((Entity)pixie);
                        }
                    }
                    this.tpDelay = this.hardMode ? (dying ? 35 : 45) : (dying ? 40 : 60);
                    this.spawnLandmines = true;
                    this.spawnPixies = false;
                }
            }
            if (spawnMissiles) {
                this.spawnMissile();
            }
        } else {
            this.tpDelay = 30;
            this.aggro = true;
        }
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    protected void m_6138_() {
        if (this.getInvulTime() == 0) {
            super.m_6138_();
        }
    }

    public boolean m_6094_() {
        return super.m_6094_() && this.getInvulTime() == 0;
    }

    private void spawnMissile() {
        MagicMissileEntity missile = new MagicMissileEntity((LivingEntity)this, true);
        missile.m_6034_(this.m_20185_() + (Math.random() - 0.05), this.m_20186_() + 2.4 + (Math.random() - 0.05), this.m_20189_() + (Math.random() - 0.05));
        if (missile.findTarget()) {
            this.m_5496_(BotaniaSounds.missile, 1.0f, 0.8f + (float)Math.random() * 0.2f);
            this.f_19853_.m_7967_((Entity)missile);
        }
    }

    private void teleportRandomly() {
        Vec3 newPosVec;
        BlockPos tentativeFloorPos;
        double newZ;
        double newX;
        double oldX = this.m_20185_();
        double oldY = this.m_20186_();
        double oldZ = this.m_20189_();
        double newY = this.source.m_123342_();
        int tries = 0;
        do {
            newX = (double)this.source.m_123341_() + (this.f_19796_.m_188500_() - 0.5) * 12.0;
            newZ = (double)this.source.m_123343_() + (this.f_19796_.m_188500_() - 0.5) * 12.0;
        } while (++tries < 50 && MathHelper.pointDistanceSpace(newX, newY, newZ, this.source.m_123341_(), this.source.m_123342_(), this.source.m_123343_()) > 12.0f);
        if (tries == 50) {
            newX = (double)this.source.m_123341_() + 0.5;
            newY = (double)this.source.m_123342_() + 1.6;
            newZ = (double)this.source.m_123343_() + 0.5;
        }
        if (this.f_19853_.m_8055_(tentativeFloorPos = new BlockPos(newX, newY - 1.0, newZ)).m_60812_((BlockGetter)this.f_19853_, tentativeFloorPos).m_83281_()) {
            newY -= 1.0;
        }
        this.m_6021_(newX, newY, newZ);
        this.f_19853_.m_6263_(null, oldX, oldY, oldZ, BotaniaSounds.gaiaTeleport, this.m_5720_(), 1.0f, 1.0f);
        this.m_5496_(BotaniaSounds.gaiaTeleport, 1.0f, 1.0f);
        RandomSource random = this.m_217043_();
        int particleCount = 128;
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i / (double)(particleCount - 1);
            float vx = (random.m_188501_() - 0.5f) * 0.2f;
            float vy = (random.m_188501_() - 0.5f) * 0.2f;
            float vz = (random.m_188501_() - 0.5f) * 0.2f;
            double px = oldX + (newX - oldX) * progress + (random.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
            double py = oldY + (newY - oldY) * progress + random.m_188500_() * (double)this.m_20206_();
            double pz = oldZ + (newZ - oldZ) * progress + (random.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, px, py, pz, (double)vx, (double)vy, (double)vz);
        }
        Vec3 oldPosVec = new Vec3(oldX, oldY + (double)(this.m_20206_() / 2.0f), oldZ);
        if (oldPosVec.m_82557_(newPosVec = new Vec3(newX, newY + (double)(this.m_20206_() / 2.0f), newZ)) > 1.0) {
            for (Player player : this.getPlayersAround()) {
                boolean hit = player.m_20191_().m_82400_(0.25).m_82371_(oldPosVec, newPosVec).isPresent();
                if (!hit) continue;
                player.m_6469_(DamageSource.m_19370_((LivingEntity)this), 6.0f);
            }
            int breakSteps = (int)oldPosVec.m_82554_(newPosVec);
            if (breakSteps >= 2) {
                for (int i = 0; i < breakSteps; ++i) {
                    float progress = (float)i / (float)(breakSteps - 1);
                    int breakX = Mth.m_14107_((double)(oldX + (newX - oldX) * (double)progress));
                    int breakY = Mth.m_14107_((double)(oldY + (newY - oldY) * (double)progress));
                    int breakZ = Mth.m_14107_((double)(oldZ + (newZ - oldZ) * (double)progress));
                    this.smashBlocksAround(breakX, breakY, breakZ, 1);
                }
            }
        }
    }

    public UUID getBossInfoUuid() {
        return this.bossInfoUUID;
    }

    public boolean isHardMode() {
        return this.hardMode;
    }

    public void readSpawnData(int playerCount, boolean hardMode, BlockPos source, UUID bossInfoUUID) {
        this.playerCount = playerCount;
        this.hardMode = hardMode;
        this.source = source;
        this.bossInfoUUID = bossInfoUUID;
        Proxy.INSTANCE.runOnClient(() -> () -> DopplegangerMusic.play(this));
    }

    @NotNull
    public Packet<?> m_5654_() {
        return XplatAbstractions.INSTANCE.toVanillaClientboundPacket(new SpawnGaiaGuardianPacket(new ClientboundAddEntityPacket((LivingEntity)this), this.playerCount, this.hardMode, this.source, this.bossInfoUUID));
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    private static class DopplegangerMusic
    extends AbstractTickableSoundInstance {
        private final GaiaGuardianEntity guardian;

        private DopplegangerMusic(GaiaGuardianEntity guardian) {
            super(guardian.hardMode ? BotaniaSounds.gaiaMusic2 : BotaniaSounds.gaiaMusic1, SoundSource.RECORDS, SoundInstance.m_235150_());
            this.guardian = guardian;
            this.f_119575_ = guardian.getSource().m_123341_();
            this.f_119576_ = guardian.getSource().m_123342_();
            this.f_119577_ = guardian.getSource().m_123343_();
            this.f_119578_ = true;
        }

        public static void play(GaiaGuardianEntity guardian) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new DopplegangerMusic(guardian));
        }

        public void m_7788_() {
            if (!this.guardian.m_6084_()) {
                this.m_119609_();
            }
        }
    }
}

