/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.block_entity.CellularBlockEntity;

public class DandelifeonBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final int RANGE = 12;
    private static final int SPEED = 10;
    private static final int MAX_MANA_GENERATIONS = 100;
    private static final int MANA_PER_GEN = 60;
    private static final int[][] ADJACENT_BLOCKS = new int[][]{{-1, -1}, {-1, 0}, {-1, 1}, {0, 1}, {1, 1}, {1, 0}, {1, -1}, {0, -1}};

    public DandelifeonBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.DANDELIFEON, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.m_58904_().f_46443_ && this.ticksExisted % 10 == 0 && this.m_58904_().m_46753_(this.m_58899_())) {
            this.runSimulation();
        }
    }

    private void runSimulation() {
        int[][] table = this.getCellTable();
        ArrayList<int[]> changes = new ArrayList<int[]>();
        boolean wipe = false;
        for (int i = 0; i < table.length; ++i) {
            for (int j = 0; j < table[0].length; ++j) {
                int gen = table[i][j];
                int adj = this.getAdjCells(table, i, j);
                int newVal = gen;
                if (adj < 2 || adj > 3) {
                    newVal = -1;
                } else if (adj == 3 && gen == -1) {
                    newVal = this.getSpawnCellGeneration(table, i, j);
                } else if (gen > -1) {
                    newVal = gen + 1;
                }
                int xdist = Math.abs(i - 12);
                int zdist = Math.abs(j - 12);
                int allowDist = 1;
                if (xdist <= allowDist && zdist <= allowDist && newVal > -1) {
                    gen = newVal;
                    int n = newVal = gen == 1 ? -1 : -2;
                }
                if (newVal == gen) continue;
                changes.add(new int[]{i, j, newVal, gen});
                if (newVal != -2) continue;
                wipe = true;
            }
        }
        BlockPos pos = this.getEffectivePos();
        for (int[] change : changes) {
            BlockPos pos_ = pos.m_7918_(-12 + change[0], 0, -12 + change[1]);
            int val = change[2];
            if (val != -2 && wipe) {
                val = -1;
            }
            int old = change[3];
            this.setBlockForGeneration(pos_, val, old);
        }
    }

    private int[][] getCellTable() {
        int diam = 25;
        int[][] table = new int[diam][diam];
        BlockPos pos = this.getEffectivePos();
        for (int i = 0; i < diam; ++i) {
            for (int j = 0; j < diam; ++j) {
                BlockPos pos_ = pos.m_7918_(-12 + i, 0, -12 + j);
                table[i][j] = this.getCellGeneration(pos_);
            }
        }
        return table;
    }

    private int getCellGeneration(BlockPos pos) {
        BlockEntity tile = this.m_58904_().m_7702_(pos);
        if (tile instanceof CellularBlockEntity) {
            CellularBlockEntity cell = (CellularBlockEntity)tile;
            return cell.isSameFlower(this) ? cell.getGeneration() : 0;
        }
        return -1;
    }

    private int getAdjCells(int[][] table, int x, int z) {
        int count = 0;
        for (int[] shift : ADJACENT_BLOCKS) {
            int gen;
            int xp = x + shift[0];
            int zp = z + shift[1];
            if (this.isOffBounds(table, xp, zp) || (gen = table[xp][zp]) < 0) continue;
            ++count;
        }
        return count;
    }

    private int getSpawnCellGeneration(int[][] table, int x, int z) {
        int max = -1;
        for (int[] shift : ADJACENT_BLOCKS) {
            int gen;
            int xp = x + shift[0];
            int zp = z + shift[1];
            if (this.isOffBounds(table, xp, zp) || (gen = table[xp][zp]) <= max) continue;
            max = gen;
        }
        return max == -1 ? -1 : max + 1;
    }

    boolean isOffBounds(int[][] table, int x, int z) {
        return x < 0 || z < 0 || x >= table.length || z >= table[0].length;
    }

    void setBlockForGeneration(BlockPos pos, int gen, int prevGen) {
        Level world = this.m_58904_();
        BlockState stateAt = world.m_8055_(pos);
        BlockEntity tile = world.m_7702_(pos);
        if (gen == -2) {
            int val = Math.min(100, prevGen) * 60;
            this.addMana(val);
            this.sync();
        } else if (stateAt.m_60713_(BotaniaBlocks.cellBlock)) {
            if (gen < 0) {
                world.m_7471_(pos, false);
            } else {
                ((CellularBlockEntity)tile).setGeneration(this, gen);
            }
        } else if (gen >= 0 && stateAt.m_60795_()) {
            world.m_46597_(pos, BotaniaBlocks.cellBlock.m_49966_());
            tile = world.m_7702_(pos);
            ((CellularBlockEntity)tile).setGeneration(this, gen);
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 12);
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 1);
    }

    @Override
    public int getMaxMana() {
        return 50000;
    }

    @Override
    public int getColor() {
        return 10226302;
    }
}

