/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.item.FlowerPlaceable;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.flower.functional.HopperhockBlockEntity;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.xplat.BotaniaConfig;

public class RannuncarpusBlockEntity
extends FunctionalFlowerBlockEntity
implements Wandable {
    private static final int PICKUP_RANGE = 2;
    private static final int PICKUP_RANGE_Y = 3;
    private static final int RANGE_PLACE_MANA = 8;
    private static final int RANGE_PLACE = 6;
    private static final int RANGE_PLACE_Y = 6;
    private static final int RANGE_PLACE_MANA_MINI = 3;
    private static final int RANGE_PLACE_MINI = 2;
    private static final int RANGE_PLACE_Y_MINI = 2;
    private static final String TAG_STATE_SENSITIVE = "stateSensitive";
    private boolean stateSensitive = false;

    protected RannuncarpusBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public RannuncarpusBlockEntity(BlockPos pos, BlockState state) {
        this(BotaniaFlowerBlocks.RANNUNCARPUS, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46443_ || this.redstoneSignal > 0) {
            return;
        }
        if (this.ticksExisted % 10 == 0) {
            List items = this.m_58904_().m_45976_(ItemEntity.class, new AABB(this.m_58899_().m_7918_(-2, -3, -2), this.m_58899_().m_7918_(3, 4, 3)));
            List<ItemStack> filter = HopperhockBlockEntity.getFilterForInventory(this.m_58904_(), this.getFilterPos(), false);
            for (ItemEntity item : items) {
                BlockPos coords;
                ItemStack stack;
                if (!DelayHelper.canInteractWith(this, item) || !HopperhockBlockEntity.canAcceptItem(stack = item.m_32055_(), filter, 0)) continue;
                Item stackItem = stack.m_41720_();
                ResourceLocation id = Registry.f_122827_.m_7981_((Object)stackItem);
                if (BotaniaConfig.common().rannuncarpusModBlacklist().contains(id.m_135827_()) || BotaniaConfig.common().rannuncarpusItemBlacklist().contains(id.toString()) || !(stackItem instanceof BlockItem) && !(stackItem instanceof FlowerPlaceable) || (coords = this.getCandidatePosition(this.m_58904_().f_46441_)) == null) continue;
                BlockHitResult ray = new BlockHitResult(new Vec3((double)coords.m_123341_() + 0.5, (double)(coords.m_123342_() + 1), (double)coords.m_123343_() + 0.5), Direction.UP, coords, false);
                RannuncarpusPlaceContext ctx = new RannuncarpusPlaceContext(this.m_58904_(), stack, ray, this.f_58858_);
                boolean success = false;
                if (stackItem instanceof FlowerPlaceable) {
                    FlowerPlaceable flowerPlaceable = (FlowerPlaceable)stackItem;
                    success = flowerPlaceable.tryPlace(this, ctx);
                }
                if (!success && stackItem instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)stackItem;
                    success = blockItem.m_40576_((BlockPlaceContext)ctx).m_19077_();
                }
                if (!success) continue;
                if (BotaniaConfig.common().blockBreakParticles()) {
                    BlockState state = this.m_58904_().m_8055_(ctx.m_8083_());
                    this.m_58904_().m_46796_(2001, coords, Block.m_49956_((BlockState)state));
                }
                if (this.getMana() > 1) {
                    this.addMana(-1);
                }
                EntityHelper.syncItem(item);
                return;
            }
        }
    }

    private BlockPos getFilterPos() {
        return this.m_58899_().m_6625_(this.isFloating() ? 1 : 2);
    }

    public BlockState getUnderlyingBlock() {
        return this.m_58904_().m_8055_(this.getFilterPos());
    }

    @Nullable
    private BlockPos getCandidatePosition(RandomSource rand) {
        int rangePlace = this.getPlaceRange();
        int rangePlaceY = this.getVerticalPlaceRange();
        BlockPos center = this.getEffectivePos();
        BlockState filter = this.getUnderlyingBlock();
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_(-rangePlace, -rangePlaceY, -rangePlace), (BlockPos)center.m_7918_(rangePlace, rangePlaceY, rangePlace))) {
            BlockState state = this.m_58904_().m_8055_(pos);
            BlockState up = this.m_58904_().m_8055_(pos.m_7494_());
            boolean matches = this.stateSensitive ? state == filter : state.m_60713_(filter.m_60734_());
            if (!matches || !up.m_60795_() && !up.m_60767_().m_76336_()) continue;
            ret.add(pos.m_7949_());
        }
        return ret.isEmpty() ? null : (BlockPos)ret.get(rand.m_188503_(ret.size()));
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.stateSensitive = cmp.m_128441_(TAG_STATE_SENSITIVE) ? cmp.m_128471_(TAG_STATE_SENSITIVE) : true;
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128379_(TAG_STATE_SENSITIVE, this.stateSensitive);
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack wand, Direction side) {
        if (player == null || player.m_6144_()) {
            this.stateSensitive = !this.stateSensitive;
            this.m_6596_();
            this.sync();
            return true;
        }
        return false;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.getPlaceRange());
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        if (this.getPlaceRange() == 2 && this.getEffectivePos().equals((Object)this.m_58899_())) {
            return null;
        }
        return RadiusDescriptor.Rectangle.square(this.m_58899_(), 2);
    }

    public int getPlaceRange() {
        return this.getMana() > 0 ? 8 : 6;
    }

    public int getVerticalPlaceRange() {
        return 6;
    }

    @Override
    public int getMaxMana() {
        return 20;
    }

    @Override
    public int getColor() {
        return 16757375;
    }

    private static class RannuncarpusPlaceContext
    extends BlockPlaceContext {
        private final Direction[] lookDirs;
        private final float placementYaw;

        public RannuncarpusPlaceContext(Level world, ItemStack stack, BlockHitResult rtr, BlockPos flowerPos) {
            super(world, null, InteractionHand.MAIN_HAND, stack, rtr);
            int dx = rtr.m_82425_().m_123341_() - flowerPos.m_123341_();
            int dy = rtr.m_82425_().m_123342_() - flowerPos.m_123342_();
            int dz = rtr.m_82425_().m_123343_() - flowerPos.m_123343_();
            Direction xClosest = dx >= 0 ? Direction.EAST : Direction.WEST;
            Direction yClosest = dy >= 0 ? Direction.UP : Direction.DOWN;
            Direction zClosest = dz >= 0 ? Direction.SOUTH : Direction.NORTH;
            List<Direction> directions = RannuncarpusPlaceContext.sortThree(xClosest, yClosest, zClosest, Math.abs(dx), Math.abs(dy), Math.abs(dz));
            Direction first = directions.get(0);
            Direction second = directions.get(1);
            Direction third = directions.get(2);
            this.lookDirs = new Direction[]{first, second, third, third.m_122424_(), second.m_122424_(), first.m_122424_()};
            this.placementYaw = (float)(-Mth.m_14136_((double)dx, (double)dz) * 180.0 / Math.PI);
        }

        private static <T> List<T> sortThree(T a, T b, T c, int aInt, int bInt, int cInt) {
            if (aInt >= bInt) {
                if (bInt >= cInt) {
                    return ImmutableList.of(a, b, c);
                }
                return cInt >= aInt ? ImmutableList.of(c, a, b) : ImmutableList.of(a, c, b);
            }
            if (bInt >= cInt) {
                return cInt >= aInt ? ImmutableList.of(b, c, a) : ImmutableList.of(b, a, c);
            }
            return ImmutableList.of(c, b, a);
        }

        @NotNull
        public Direction m_7820_() {
            return this.m_6232_()[0];
        }

        @NotNull
        public Direction[] m_6232_() {
            return this.lookDirs;
        }

        @NotNull
        public Direction m_8125_() {
            return this.m_7820_().m_122434_().m_122479_() ? this.m_7820_() : this.m_6232_()[1];
        }

        public float m_7074_() {
            return this.placementYaw;
        }
    }

    public static class Mini
    extends RannuncarpusBlockEntity {
        public Mini(BlockPos pos, BlockState state) {
            super(BotaniaFlowerBlocks.RANNUNCARPUS_CHIBI, pos, state);
        }

        @Override
        public int getPlaceRange() {
            return this.getMana() > 0 ? 3 : 2;
        }

        @Override
        public int getVerticalPlaceRange() {
            return 2;
        }
    }

    public static class WandHud
    extends FunctionalFlowerBlockEntity.FunctionalWandHud<RannuncarpusBlockEntity> {
        public WandHud(RannuncarpusBlockEntity flower) {
            super(flower);
        }

        @Override
        public void renderHUD(PoseStack ms, Minecraft mc) {
            super.renderHUD(ms, mc);
            BlockState filter = ((RannuncarpusBlockEntity)this.flower).getUnderlyingBlock();
            ItemStack recieverStack = new ItemStack((ItemLike)filter.m_60734_());
            int color = ((RannuncarpusBlockEntity)this.flower).getColor();
            if (!recieverStack.m_41619_()) {
                Component stackName = recieverStack.m_41786_();
                int width = 16 + mc.f_91062_.m_92852_((FormattedText)stackName) / 2;
                int x = mc.m_91268_().m_85445_() / 2 - width;
                int y = mc.m_91268_().m_85446_() / 2 + 30;
                mc.f_91062_.m_92763_(ms, stackName, (float)(x + 20), (float)(y + 5), color);
                mc.m_91291_().m_115203_(recieverStack, x, y);
                String mode = I18n.m_118938_((String)("botaniamisc.rannuncarpus." + (((RannuncarpusBlockEntity)this.flower).stateSensitive ? "state_sensitive" : "state_insensitive")), (Object[])new Object[0]);
                x = mc.m_91268_().m_85445_() / 2 - mc.f_91062_.m_92895_(mode) / 2;
                y = mc.m_91268_().m_85446_() / 2 + 50;
                mc.f_91062_.m_92750_(ms, mode, (float)x, (float)y, ChatFormatting.WHITE.m_126665_().intValue());
            }
        }
    }
}

