/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.network.clientbound.ItemAgePacket;
import vazkii.botania.xplat.XplatAbstractions;

public class DaffomillBlockEntity
extends FunctionalFlowerBlockEntity
implements Wandable {
    private static final String TAG_ORIENTATION = "orientation";
    private static final String TAG_WIND_TICKS = "windTicks";
    private static final String TAG_POWERED = "powered";
    private int windTicks = 0;
    private Direction orientation = Direction.NORTH;
    private boolean redstonePowered;

    public DaffomillBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.DAFFOMILL, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46441_.m_188503_(4) == 0) {
            WispParticleData data = WispParticleData.wisp(0.25f + (float)Math.random() * 0.15f, 0.05f, 0.05f, 0.05f);
            this.emitParticle(data, Math.random(), Math.random(), Math.random(), (float)this.orientation.m_122429_() * 0.1f, (float)this.orientation.m_122430_() * 0.1f, (float)this.orientation.m_122431_() * 0.1f);
        }
        if (this.windTicks == 0 && this.getMana() > 0) {
            this.windTicks = 20;
            this.addMana(-1);
        }
        if (this.windTicks > 0 && !this.isRedstonePowered()) {
            AABB axis = this.aabbForOrientation();
            if (axis != null) {
                List items = this.m_58904_().m_45976_(ItemEntity.class, axis);
                for (ItemEntity item : items) {
                    if (!DelayHelper.canInteractWithImmediate(this, item)) continue;
                    item.m_20334_(item.m_20184_().m_7096_() + (double)this.orientation.m_122429_() * 0.05, item.m_20184_().m_7098_() + (double)this.orientation.m_122430_() * 0.05, item.m_20184_().m_7094_() + (double)this.orientation.m_122431_() * 0.05);
                }
            }
            --this.windTicks;
        }
    }

    private AABB aabbForOrientation() {
        int x = this.getEffectivePos().m_123341_();
        int y = this.getEffectivePos().m_123342_();
        int z = this.getEffectivePos().m_123343_();
        int w = 2;
        int h = 3;
        int l = 16;
        AABB axis = null;
        switch (this.orientation) {
            case NORTH: {
                axis = new AABB((double)(x - w), (double)(y - h), (double)(z - l), (double)(x + w + 1), (double)(y + h), (double)z);
                break;
            }
            case SOUTH: {
                axis = new AABB((double)(x - w), (double)(y - h), (double)(z + 1), (double)(x + w + 1), (double)(y + h), (double)(z + l + 1));
                break;
            }
            case WEST: {
                axis = new AABB((double)(x - l), (double)(y - h), (double)(z - w), (double)x, (double)(y + h), (double)(z + w + 1));
                break;
            }
            case EAST: {
                axis = new AABB((double)(x + 1), (double)(y - h), (double)(z - w), (double)(x + l + 1), (double)(y + h), (double)(z + w + 1));
                break;
            }
        }
        return axis;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack wand, Direction side) {
        if (player == null || !player.m_6144_()) {
            return false;
        }
        if (!player.f_19853_.f_46443_) {
            this.orientation = this.orientation.m_122427_();
            this.sync();
        }
        return true;
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer != null) {
            this.orientation = placer.m_6350_();
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    @Override
    public RadiusDescriptor getRadius() {
        AABB aabb = this.aabbForOrientation();
        aabb = new AABB(aabb.f_82288_, (double)this.getEffectivePos().m_123342_(), aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
        return new RadiusDescriptor.Rectangle(this.getEffectivePos(), aabb);
    }

    @Override
    public int getColor() {
        return 14203392;
    }

    @Override
    public int getMaxMana() {
        return 100;
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_ORIENTATION, this.orientation.m_122411_());
        cmp.m_128405_(TAG_WIND_TICKS, this.windTicks);
        cmp.m_128379_(TAG_POWERED, this.redstonePowered);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.orientation = Direction.m_122376_((int)cmp.m_128451_(TAG_ORIENTATION));
        this.windTicks = cmp.m_128451_(TAG_WIND_TICKS);
        this.redstonePowered = cmp.m_128471_(TAG_POWERED);
    }

    private boolean isRedstonePowered() {
        if (!this.f_58857_.f_46443_) {
            boolean powered;
            boolean bl = powered = this.redstoneSignal != 0;
            if (powered != this.redstonePowered) {
                this.redstonePowered = powered;
                this.sync();
            }
        }
        return this.redstonePowered;
    }

    public static void onItemTrack(Entity entity, ServerPlayer player) {
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            int entityId = entity.m_19879_();
            int age = XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).timeCounter;
            XplatAbstractions.INSTANCE.sendToPlayer((Player)player, new ItemAgePacket(entityId, age));
        }
    }
}

