/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.corporea;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaRequestor;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

public class CorporeaRetainerBlockEntity
extends BotaniaBlockEntity
implements Wandable {
    private static final String TAG_REQUEST_X = "requestX";
    private static final String TAG_REQUEST_Y = "requestY";
    private static final String TAG_REQUEST_Z = "requestZ";
    private static final String TAG_REQUEST_TYPE = "requestType";
    private static final String TAG_REQUEST_COUNT = "requestCount";
    private static final String TAG_RETAIN_MISSING = "retainMissing";
    private static final Map<ResourceLocation, Function<CompoundTag, ? extends CorporeaRequestMatcher>> corporeaMatcherDeserializers = new ConcurrentHashMap<ResourceLocation, Function<CompoundTag, ? extends CorporeaRequestMatcher>>();
    private static final Map<Class<? extends CorporeaRequestMatcher>, ResourceLocation> corporeaMatcherSerializers = new ConcurrentHashMap<Class<? extends CorporeaRequestMatcher>, ResourceLocation>();
    private BlockPos requestPos = BlockPos.f_121853_;
    @Nullable
    private CorporeaRequestMatcher request;
    private int requestCount;
    private boolean retainMissing = false;

    public CorporeaRetainerBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.CORPOREA_RETAINER, pos, state);
    }

    public void remember(BlockPos pos, CorporeaRequestMatcher request, int count, int missing) {
        this.requestPos = pos;
        this.request = request;
        this.requestCount = this.retainMissing ? missing : count;
        this.m_6596_();
    }

    public void forget() {
        this.request = null;
        this.requestCount = 0;
    }

    public int getComparatorValue() {
        return CorporeaHelper.instance().signalStrengthForRequestSize(this.requestCount);
    }

    public boolean hasPendingRequest() {
        return this.request != null;
    }

    public void fulfilRequest() {
        BlockEntity te;
        if (!this.hasPendingRequest()) {
            return;
        }
        CorporeaSpark spark = CorporeaHelper.instance().getSparkForBlock(this.f_58857_, this.requestPos);
        if (spark != null && (te = spark.getSparkNode().getWorld().m_7702_(spark.getSparkNode().getPos())) instanceof CorporeaRequestor) {
            CorporeaRequestor requestor = (CorporeaRequestor)te;
            requestor.doCorporeaRequest(this.request, this.requestCount, spark, null);
            this.forget();
            this.m_6596_();
        }
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        ResourceLocation reqType;
        super.writePacketNBT(cmp);
        cmp.m_128405_(TAG_REQUEST_X, this.requestPos.m_123341_());
        cmp.m_128405_(TAG_REQUEST_Y, this.requestPos.m_123342_());
        cmp.m_128405_(TAG_REQUEST_Z, this.requestPos.m_123343_());
        ResourceLocation resourceLocation = reqType = this.request != null ? corporeaMatcherSerializers.get(this.request.getClass()) : null;
        if (reqType != null) {
            cmp.m_128359_(TAG_REQUEST_TYPE, reqType.toString());
            this.request.writeToNBT(cmp);
            cmp.m_128405_(TAG_REQUEST_COUNT, this.requestCount);
        }
        cmp.m_128379_(TAG_RETAIN_MISSING, this.retainMissing);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        super.readPacketNBT(cmp);
        int x = cmp.m_128451_(TAG_REQUEST_X);
        int y = cmp.m_128451_(TAG_REQUEST_Y);
        int z = cmp.m_128451_(TAG_REQUEST_Z);
        this.requestPos = new BlockPos(x, y, z);
        ResourceLocation reqType = ResourceLocation.m_135820_((String)cmp.m_128461_(TAG_REQUEST_TYPE));
        this.request = reqType != null && corporeaMatcherDeserializers.containsKey(reqType) ? corporeaMatcherDeserializers.get(reqType).apply(cmp) : null;
        this.requestCount = cmp.m_128451_(TAG_REQUEST_COUNT);
        this.retainMissing = cmp.m_128471_(TAG_RETAIN_MISSING);
    }

    public static <T extends CorporeaRequestMatcher> void addCorporeaRequestMatcher(ResourceLocation id, Class<T> clazz, Function<CompoundTag, T> deserializer) {
        corporeaMatcherSerializers.put(clazz, id);
        corporeaMatcherDeserializers.put(id, deserializer);
    }

    @Override
    public boolean onUsedByWand(Player player, ItemStack stack, Direction side) {
        if (!this.f_58857_.f_46443_) {
            this.retainMissing = !this.retainMissing;
            this.m_6596_();
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }

    public static class WandHud
    implements WandHUD {
        private final CorporeaRetainerBlockEntity retainer;

        public WandHud(CorporeaRetainerBlockEntity retainer) {
            this.retainer = retainer;
        }

        @Override
        public void renderHUD(PoseStack ms, Minecraft mc) {
            String mode = I18n.m_118938_((String)("botaniamisc.retainer." + (this.retainer.retainMissing ? "retain_missing" : "retain_all")), (Object[])new Object[0]);
            int x = mc.m_91268_().m_85445_() / 2 - mc.f_91062_.m_92895_(mode) / 2;
            int y = mc.m_91268_().m_85446_() / 2 + 10;
            mc.f_91062_.m_92750_(ms, mode, (float)x, (float)y, ChatFormatting.GRAY.m_126665_().intValue());
        }
    }
}

