/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.Bound;
import vazkii.botania.api.block.WandBindable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.LuminizerBlock;
import vazkii.botania.common.block.block_entity.AnimatedTorchBlockEntity;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class LuminizerBlockEntity
extends BotaniaBlockEntity
implements WandBindable {
    public static final int MAX_DIST = 20;
    private static final String TAG_BIND_X = "bindX";
    private static final String TAG_BIND_Y = "bindY";
    private static final String TAG_BIND_Z = "bindZ";
    private static final String TAG_NO_PARTICLE = "noParticle";
    private BlockPos bindPos = Bound.UNBOUND_POS;
    private int ticksElapsed = 0;
    private boolean noParticle = false;

    public LuminizerBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.LIGHT_RELAY, pos, state);
    }

    public void mountEntity(Entity e) {
        BlockPos nextDest = this.getNextDestination();
        if (e.m_20159_() || this.f_58857_.f_46443_ || nextDest == null || !this.isValidBinding()) {
            return;
        }
        PlayerMoverEntity mover = new PlayerMoverEntity(this.f_58857_, this.f_58858_, nextDest);
        this.f_58857_.m_7967_((Entity)mover);
        e.m_20329_((Entity)mover);
        if (!(e instanceof ItemEntity)) {
            mover.m_5496_(BotaniaSounds.lightRelay, 1.0f, (float)Math.random() * 0.3f + 0.7f);
        }
        if (e instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)e;
            PlayerHelper.grantCriterion(serverPlayer, ResourceLocationHelper.prefix("main/luminizer_ride"), "code_triggered");
        }
    }

    public static void clientTick(Level level, BlockPos worldPosition, BlockState state, LuminizerBlockEntity self) {
        Vec3 vec;
        ++self.ticksElapsed;
        BlockPos nextDest = self.getNextDestination();
        if (!self.isNoParticle() && nextDest != null && nextDest.m_123342_() != Integer.MIN_VALUE && self.isValidBinding() && (vec = self.getMovementVector()) != null) {
            double dist = 0.1;
            int size = (int)(vec.m_82553_() / dist);
            int count = 10;
            int start = self.ticksElapsed % size;
            Vec3 vecMag = vec.m_82541_().m_82490_(dist);
            Vec3 vecTip = vecMag.m_82490_((double)start).m_82520_((double)worldPosition.m_123341_() + 0.5, (double)worldPosition.m_123342_() + 0.5, (double)worldPosition.m_123343_() + 0.5);
            double radPer = 0.19634954084936207;
            float mul = 0.5f;
            float mulPer = 0.4f;
            float maxMul = 2.0f;
            WispParticleData data = WispParticleData.wisp(0.1f, 0.4f, 0.4f, 1.0f, 1.0f);
            for (int i = start; i < start + count; ++i) {
                mul = Math.min(maxMul, mul + mulPer);
                double rad = radPer * ((double)i + (double)self.ticksElapsed * 0.4);
                Vec3 intermediate = vecMag.m_82537_(VecHelper.ONE).m_82490_((double)mul);
                Vec3 vecRot = VecHelper.rotate(intermediate, rad, vecMag).m_82549_(vecTip);
                level.m_7106_((ParticleOptions)data, vecRot.f_82479_, vecRot.f_82480_, vecRot.f_82481_, (double)((float)(-vecMag.f_82479_)), (double)((float)(-vecMag.f_82480_)), (double)((float)(-vecMag.f_82481_)));
                vecTip = vecTip.m_82549_(vecMag);
            }
        }
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, LuminizerBlockEntity self) {
        BlockPos endpoint;
        ++self.ticksElapsed;
        BlockPos nextDest = self.getNextDestination();
        if (nextDest != null && nextDest.m_123342_() != Integer.MIN_VALUE && self.isValidBinding() && (endpoint = self.getEndpoint()) != null) {
            AABB aabb = state.m_60808_((BlockGetter)level, worldPosition).m_83215_().m_82338_(worldPosition);
            float range = 0.6f;
            List enderPearls = level.m_45976_(ThrownEnderpearl.class, aabb.m_82400_((double)range));
            for (ThrownEnderpearl pearl : enderPearls) {
                pearl.m_6021_((double)endpoint.m_123341_() + pearl.m_20185_() - (double)worldPosition.m_123341_(), (double)endpoint.m_123342_() + pearl.m_20186_() - (double)worldPosition.m_123342_(), (double)endpoint.m_123343_() + pearl.m_20189_() - (double)worldPosition.m_123343_());
            }
        }
    }

    private boolean isValidBinding() {
        BlockPos nextDest = this.getNextDestination();
        if (nextDest == null) {
            return false;
        }
        Block block = this.f_58857_.m_8055_(nextDest).m_60734_();
        return block instanceof LuminizerBlock;
    }

    private BlockPos getEndpoint() {
        ArrayList<LuminizerBlockEntity> pointsPassed = new ArrayList<LuminizerBlockEntity>();
        LuminizerBlockEntity relay = this;
        BlockPos lastCoords = null;
        boolean run = true;
        while (run) {
            LuminizerBlockEntity tileRelay;
            if (pointsPassed.contains(relay)) {
                return null;
            }
            pointsPassed.add(relay);
            BlockPos coords = relay.getNextDestination();
            if (coords == null) {
                return lastCoords;
            }
            BlockEntity tile = this.f_58857_.m_7702_(coords);
            if (tile == null || !(tile instanceof LuminizerBlockEntity)) {
                return lastCoords;
            }
            relay = tileRelay = (LuminizerBlockEntity)tile;
            lastCoords = coords;
        }
        return null;
    }

    public void setNoParticle() {
        this.noParticle = true;
    }

    public boolean isNoParticle() {
        return this.noParticle;
    }

    public Vec3 getMovementVector() {
        BlockPos dest = this.getNextDestination();
        if (dest == null) {
            return null;
        }
        return new Vec3((double)(dest.m_123341_() - this.f_58858_.m_123341_()), (double)(dest.m_123342_() - this.f_58858_.m_123342_()), (double)(dest.m_123343_() - this.f_58858_.m_123343_()));
    }

    @Override
    public BlockPos getBinding() {
        return this.bindPos;
    }

    public BlockPos getNextDestination() {
        BlockState state = this.m_58900_();
        if (state.m_60713_(BotaniaBlocks.lightRelayToggle) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
            return null;
        }
        if (state.m_60713_(BotaniaBlocks.lightRelayFork)) {
            BlockPos torchPos = null;
            for (int i = -2; i < 3; ++i) {
                BlockPos testPos = this.f_58858_.m_7918_(0, i, 0);
                BlockState testState = this.f_58857_.m_8055_(testPos);
                if (!testState.m_60713_(BotaniaBlocks.animatedTorch)) continue;
                torchPos = testPos;
                break;
            }
            if (torchPos != null) {
                AnimatedTorchBlockEntity torch = (AnimatedTorchBlockEntity)this.f_58857_.m_7702_(torchPos);
                Direction side = AnimatedTorchBlockEntity.SIDES[torch.side].m_122424_();
                for (int i = 1; i < 20; ++i) {
                    BlockPos testPos = this.f_58858_.m_5484_(side, i);
                    BlockState testState = this.f_58857_.m_8055_(testPos);
                    if (!(testState.m_60734_() instanceof LuminizerBlock)) continue;
                    return testPos;
                }
            }
        }
        return this.getBinding();
    }

    @Override
    public boolean canSelect(Player player, ItemStack wand, BlockPos pos, Direction side) {
        return true;
    }

    @Override
    public boolean bindTo(Player player, ItemStack wand, BlockPos pos, Direction side) {
        if (!(player.f_19853_.m_8055_(pos).m_60734_() instanceof LuminizerBlock) || pos.m_123331_((Vec3i)this.m_58899_()) > 400.0) {
            return false;
        }
        this.bindPos = pos;
        this.m_6596_();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        return true;
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.bindPos = new BlockPos(cmp.m_128451_(TAG_BIND_X), cmp.m_128451_(TAG_BIND_Y), cmp.m_128451_(TAG_BIND_Z));
        this.noParticle = cmp.m_128471_(TAG_NO_PARTICLE);
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_BIND_X, this.bindPos.m_123341_());
        cmp.m_128405_(TAG_BIND_Y, this.bindPos.m_123342_());
        cmp.m_128405_(TAG_BIND_Z, this.bindPos.m_123343_());
        cmp.m_128379_(TAG_NO_PARTICLE, this.noParticle);
    }

    public static class PlayerMoverEntity
    extends Entity {
        private static final String TAG_EXIT_X = "exitX";
        private static final String TAG_EXIT_Y = "exitY";
        private static final String TAG_EXIT_Z = "exitZ";
        private static final EntityDataAccessor<BlockPos> EXIT_POS = SynchedEntityData.m_135353_(PlayerMoverEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

        public PlayerMoverEntity(EntityType<PlayerMoverEntity> type, Level world) {
            super(type, world);
            this.f_19794_ = true;
        }

        public PlayerMoverEntity(Level world, BlockPos pos, BlockPos exitPos) {
            this(BotaniaEntities.PLAYER_MOVER, world);
            this.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            this.setExit(exitPos);
        }

        protected void m_8097_() {
            this.f_19804_.m_135372_(EXIT_POS, (Object)BlockPos.f_121853_);
        }

        public void m_8119_() {
            super.m_8119_();
            if (this.m_20197_().isEmpty() && !this.f_19853_.f_46443_) {
                this.m_146870_();
                return;
            }
            boolean isItem = this.m_20202_() instanceof ItemEntity;
            if (!isItem && this.f_19797_ % 30 == 0) {
                this.m_5496_(BotaniaSounds.lightRelay, 0.25f, (float)Math.random() * 0.3f + 0.7f);
            }
            BlockPos pos = this.m_20183_();
            BlockPos exitPos = this.getExitPos();
            if (!this.f_19853_.f_46443_ && pos.equals((Object)exitPos)) {
                boolean done = true;
                BlockEntity tile = this.f_19853_.m_7702_(pos);
                if (tile instanceof LuminizerBlockEntity) {
                    BlockPos bind;
                    LuminizerBlockEntity relay = (LuminizerBlockEntity)tile;
                    BlockState state = this.f_19853_.m_8055_(pos);
                    if (state.m_60713_(BotaniaBlocks.lightRelayDetector)) {
                        this.f_19853_.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)));
                        this.f_19853_.m_186460_(pos, state.m_60734_(), 2);
                    }
                    if ((bind = relay.getNextDestination()) != null && relay.isValidBinding()) {
                        this.setExit(bind);
                        done = false;
                    }
                }
                if (done) {
                    for (Entity e : this.m_20197_()) {
                        e.m_8127_();
                    }
                    this.m_146870_();
                    return;
                }
            }
            Vec3 thisVec = this.m_20182_();
            Vec3 motVec = thisVec.m_82548_().m_82520_((double)exitPos.m_123341_() + 0.5, (double)exitPos.m_123342_() + 0.5, (double)exitPos.m_123343_() + 0.5).m_82541_().m_82490_(0.5);
            int count = 4;
            for (int i = 0; i < count; ++i) {
                int color = Mth.m_14169_((float)((float)this.f_19797_ / 36.0f + 1.0f / (float)count * (float)i), (float)1.0f, (float)1.0f);
                double rad = Math.PI * 2 / (double)count * (double)i + (double)this.f_19797_ / Math.PI;
                double cos = Math.cos(rad);
                double sin = Math.sin(rad);
                double s = 0.4;
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                SparkleParticleData data = SparkleParticleData.sparkle(1.2f, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 10);
                this.f_19853_.m_7106_((ParticleOptions)data, this.m_20185_() + cos * s, this.m_20186_() - 0.5, this.m_20189_() + sin * s, 0.0, 0.0, 0.0);
            }
            this.m_6034_(this.m_20185_() + motVec.f_82479_, this.m_20186_() + motVec.f_82480_, this.m_20189_() + motVec.f_82481_);
        }

        public boolean shouldRiderSit() {
            return false;
        }

        public boolean m_6469_(@NotNull DamageSource source, float damage) {
            return false;
        }

        protected void m_7378_(@NotNull CompoundTag cmp) {
            this.setExit(new BlockPos(cmp.m_128451_(TAG_EXIT_X), cmp.m_128451_(TAG_EXIT_Y), cmp.m_128451_(TAG_EXIT_Z)));
        }

        protected void m_7380_(@NotNull CompoundTag cmp) {
            BlockPos exit = this.getExitPos();
            cmp.m_128405_(TAG_EXIT_X, exit.m_123341_());
            cmp.m_128405_(TAG_EXIT_Y, exit.m_123342_());
            cmp.m_128405_(TAG_EXIT_Z, exit.m_123343_());
        }

        public Vec3 m_7688_(LivingEntity living) {
            Direction direction = living.m_6350_();
            int[][] aint = DismountHelper.m_38467_((Direction)direction);
            BlockPos blockpos = this.m_20183_();
            BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
            for (Pose pose : living.m_7431_()) {
                AABB axisalignedbb = living.m_21270_(pose);
                for (int[] aint1 : aint) {
                    Vec3 vector3d;
                    blockpos$mutable.m_122178_(blockpos.m_123341_() + aint1[0], blockpos.m_123342_(), blockpos.m_123343_() + aint1[1]);
                    double d0 = this.f_19853_.m_45573_((BlockPos)blockpos$mutable);
                    if (!DismountHelper.m_38439_((double)d0) || !DismountHelper.m_38456_((CollisionGetter)this.f_19853_, (LivingEntity)living, (AABB)axisalignedbb.m_82383_(vector3d = Vec3.m_82514_((Vec3i)blockpos$mutable, (double)d0)))) continue;
                    living.m_20124_(pose);
                    return vector3d;
                }
            }
            return super.m_7688_(living);
        }

        @NotNull
        public Packet<?> m_5654_() {
            return new ClientboundAddEntityPacket((Entity)this);
        }

        public BlockPos getExitPos() {
            return (BlockPos)this.f_19804_.m_135370_(EXIT_POS);
        }

        public void setExit(BlockPos pos) {
            this.f_19804_.m_135381_(EXIT_POS, (Object)pos);
        }
    }
}

