/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.xplat.BotaniaConfig;

public class BotaniaFlowerBlock
extends FlowerBlock
implements BonemealableBlock {
    public final DyeColor color;

    protected BotaniaFlowerBlock(DyeColor color, BlockBehaviour.Properties builder) {
        super(BotaniaFlowerBlock.effectForFlower(color), 4, builder);
        this.color = color;
    }

    private static MobEffect effectForFlower(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> MobEffects.f_19596_;
            case DyeColor.ORANGE -> MobEffects.f_19607_;
            case DyeColor.MAGENTA -> MobEffects.f_19599_;
            case DyeColor.LIGHT_BLUE -> MobEffects.f_19603_;
            case DyeColor.YELLOW -> MobEffects.f_19617_;
            case DyeColor.LIME -> MobEffects.f_19614_;
            case DyeColor.PINK -> MobEffects.f_19605_;
            case DyeColor.GRAY -> MobEffects.f_19606_;
            case DyeColor.LIGHT_GRAY -> MobEffects.f_19613_;
            case DyeColor.CYAN -> MobEffects.f_19608_;
            case DyeColor.PURPLE -> MobEffects.f_19604_;
            case DyeColor.BLUE -> MobEffects.f_19611_;
            case DyeColor.BROWN -> MobEffects.f_19615_;
            case DyeColor.GREEN -> MobEffects.f_19612_;
            case DyeColor.RED -> MobEffects.f_19600_;
            case DyeColor.BLACK -> MobEffects.f_19610_;
        };
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        int hex = ColorHelper.getColorValue(this.color);
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        Vec3 offset = state.m_60824_((BlockGetter)world, pos);
        double x = (double)pos.m_123341_() + offset.f_82479_;
        double y = (double)pos.m_123342_() + offset.f_82480_;
        double z = (double)pos.m_123343_() + offset.f_82481_;
        if (rand.m_188500_() < BotaniaConfig.client().flowerParticleFrequency()) {
            SparkleParticleData data = SparkleParticleData.sparkle(rand.m_188501_(), (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 5);
            world.m_7106_((ParticleOptions)data, x + 0.3 + (double)rand.m_188501_() * 0.5, y + 0.5 + (double)rand.m_188501_() * 0.5, z + 0.3 + (double)rand.m_188501_() * 0.5, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_7370_(@NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull BlockState state, boolean fuckifiknow) {
        return world.m_8055_(pos.m_7494_()).m_60795_();
    }

    public boolean m_214167_(@NotNull Level world, @NotNull RandomSource rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        return this.m_7370_((BlockGetter)world, pos, state, false);
    }

    public void m_214148_(@NotNull ServerLevel world, @NotNull RandomSource rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        Block block = BotaniaBlocks.getDoubleFlower(this.color);
        if (block instanceof DoublePlantBlock) {
            DoublePlantBlock.m_153173_((LevelAccessor)world, (BlockState)block.m_49966_(), (BlockPos)pos, (int)3);
        }
    }
}

