/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class GoldToolsHaveFortuneModule
extends QuarkModule {
    private static final Tier[] TIERS = new Tier[]{Tiers.WOOD, Tiers.STONE, Tiers.IRON, Tiers.DIAMOND, Tiers.NETHERITE};
    @Config
    @Config.Min(value=0.0)
    public static int fortuneLevel = 2;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=4.0)
    public static int harvestLevel = 2;
    private static boolean staticEnabled;

    @Override
    public void configChanged() {
        staticEnabled = this.enabled;
    }

    @SubscribeEvent
    public void onLootingCheck(LootingLevelEvent event) {
        int level;
        int target;
        LivingEntity le;
        ItemStack stack;
        Entity entity;
        DamageSource source = event.getDamageSource();
        if (source != null && source.m_7639_() != null && (entity = source.m_7639_()) instanceof LivingEntity && (stack = (le = (LivingEntity)entity).m_21205_()).m_41720_() instanceof SwordItem && (target = GoldToolsHaveFortuneModule.getEffectiveLevel(stack, level = event.getLootingLevel())) > level) {
            event.setLootingLevel(target);
        }
    }

    private static int getEffectiveLevel(ItemStack stack, int prevLvl) {
        TieredItem ti;
        Tier tier;
        Item item = stack.m_41720_();
        if (item instanceof TieredItem && (tier = (ti = (TieredItem)item).m_43314_()) == Tiers.GOLD) {
            return fortuneLevel;
        }
        return prevLvl;
    }

    public static int getFortuneLevel(Enchantment enchant, ItemStack stack, int prev) {
        if (!staticEnabled || prev >= fortuneLevel || enchant != Enchantments.f_44987_ || !(stack.m_41720_() instanceof DiggerItem)) {
            return prev;
        }
        return GoldToolsHaveFortuneModule.getEffectiveLevel(stack, prev);
    }

    public static Tier getEffectiveTier(Item item, Tier realTier) {
        if (!staticEnabled || realTier != Tiers.GOLD) {
            return realTier;
        }
        return TIERS[harvestLevel];
    }
}

