/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.management.module;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.client.handler.ModKeybindHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.ChangeHotbarMessage;

@LoadModule(category=ModuleCategory.MANAGEMENT, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class HotbarChangerModule
extends QuarkModule {
    @OnlyIn(value=Dist.CLIENT)
    private static KeyMapping changeHotbarKey;
    private static final ResourceLocation WIDGETS;
    private static final int ANIMATION_TIME = 10;
    private static final int MAX_HEIGHT = 90;
    private static final int ANIM_PER_TICK = 9;
    public static int height;
    public static int currentHeldItem;
    public static boolean animating;
    public static boolean keyDown;
    public static boolean hotbarChangeOpen;
    public static boolean shifting;

    @Override
    public void registerKeybinds(RegisterKeyMappingsEvent event) {
        changeHotbarKey = ModKeybindHandler.init(event, "change_hotbar", "z", "quark.gui.keygroup.misc");
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onMouseInput(InputEvent.MouseButton event) {
        this.acceptInput();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyInput(InputEvent.Key event) {
        this.acceptInput();
    }

    private void acceptInput() {
        Minecraft mc = Minecraft.m_91087_();
        boolean down = changeHotbarKey.m_90857_();
        boolean wasDown = keyDown;
        keyDown = down;
        if (mc.m_91302_()) {
            if (down && !wasDown) {
                hotbarChangeOpen = !hotbarChangeOpen;
            } else if (hotbarChangeOpen) {
                for (int i = 0; i < 3; ++i) {
                    if (!mc.f_91066_.f_92056_[i].m_90857_()) continue;
                    QuarkNetwork.sendToServer(new ChangeHotbarMessage(i + 1));
                    hotbarChangeOpen = false;
                    currentHeldItem = mc.f_91074_.m_150109_().f_35977_;
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void hudPre(RenderGuiOverlayEvent.Pre event) {
        float shift = -this.getRealHeight(event.getPartialTick()) + 22.0f;
        if (shift < 0.0f) {
            NamedGuiOverlay overlay = event.getOverlay();
            if (overlay == VanillaGuiOverlay.PLAYER_HEALTH.type()) {
                event.getPoseStack().m_85837_(0.0, (double)shift, 0.0);
                shifting = true;
            } else if (shifting && (overlay == VanillaGuiOverlay.DEBUG_TEXT.type() || overlay == VanillaGuiOverlay.POTION_ICONS.type())) {
                event.getPoseStack().m_85837_(0.0, (double)(-shift), 0.0);
                shifting = false;
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void hudPost(RenderGuiOverlayEvent.Post event) {
        if (height <= 0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        PoseStack matrix = event.getPoseStack();
        if (event.getOverlay() == VanillaGuiOverlay.HOTBAR.type()) {
            int i;
            Window res = event.getWindow();
            float realHeight = this.getRealHeight(event.getPartialTick());
            float xStart = (float)res.m_85445_() / 2.0f - 91.0f;
            float yStart = (float)res.m_85446_() - realHeight;
            ItemRenderer render = mc.m_91291_();
            RenderSystem.m_69478_();
            RenderSystem.m_69405_((int)770, (int)771);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS);
            for (i = 0; i < 3; ++i) {
                matrix.m_85836_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
                matrix.m_85837_((double)xStart, (double)(yStart + (float)(i * 21)), 0.0);
                mc.f_91065_.m_93228_(matrix, 0, 0, 0, 0, 182, 22);
                matrix.m_85849_();
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (i = 0; i < 3; ++i) {
                mc.f_91062_.m_92750_(matrix, ChatFormatting.BOLD + Integer.toString(i + 1), xStart - 9.0f, yStart + (float)(i * 21) + 7.0f, 0xFFFFFF);
            }
            for (i = 0; i < 27; ++i) {
                ItemStack invStack = player.m_150109_().m_8020_(i + 9);
                int x = (int)(xStart + (float)(i % 9 * 20) + 3.0f);
                int y = (int)(yStart + (float)(i / 9 * 21) + 3.0f);
                render.m_115203_(invStack, x, y);
                render.m_115169_(mc.f_91062_, invStack, x, y);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onTick(TickEvent.ClientTickEvent event) {
        LocalPlayer player;
        if (event.phase == TickEvent.Phase.END && (player = Minecraft.m_91087_().f_91074_) != null) {
            Inventory inventory = player.m_150109_();
            if (currentHeldItem != -1 && inventory.f_35977_ != currentHeldItem) {
                inventory.f_35977_ = currentHeldItem;
                currentHeldItem = -1;
            }
        }
        if (hotbarChangeOpen && height < 90) {
            height += 9;
            animating = true;
        } else if (!hotbarChangeOpen && height > 0) {
            height -= 9;
            animating = true;
        } else {
            animating = false;
        }
    }

    private float getRealHeight(float part) {
        if (!animating) {
            return height;
        }
        return (float)height + part * 9.0f * (float)(hotbarChangeOpen ? 1 : -1);
    }

    static {
        WIDGETS = new ResourceLocation("textures/gui/widgets.png");
        height = 0;
        currentHeldItem = -1;
    }
}

