/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import vazkii.quark.content.client.module.ImprovedTooltipsModule;

public class FoodTooltips {
    private static boolean isPoison(FoodProperties food) {
        for (Pair effect : food.m_38749_()) {
            if (effect.getFirst() == null || ((MobEffectInstance)effect.getFirst()).m_19544_() == null || ((MobEffectInstance)effect.getFirst()).m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void makeTooltip(RenderTooltipEvent.GatherComponents event, boolean showFood, boolean showSaturation) {
        FoodProperties food;
        ItemStack stack = event.getItemStack();
        if (stack.m_41614_() && (food = stack.m_41720_().m_41473_()) != null) {
            int pips = food.m_38744_();
            if (pips == 0) {
                return;
            }
            int len = (int)Math.ceil((double)pips / (double)ImprovedTooltipsModule.foodDivisor);
            int saturationSimplified = 0;
            float saturation = Math.min(20.0f, food.m_38745_() * (float)food.m_38744_() * 2.0f);
            if (saturation >= 19.0f) {
                saturationSimplified = 5;
            } else if (saturation < 10.0f) {
                saturationSimplified = saturation >= 8.0f ? 1 : (saturation >= 6.0f ? 2 : (saturation >= 2.0f ? 3 : 4));
            }
            String prefix = FoodTooltips.isPoison(food) ? "quark.misc.bad_saturation" : "quark.misc.saturation";
            MutableComponent saturationText = Component.m_237115_((String)(prefix + saturationSimplified)).m_130940_(ChatFormatting.GRAY);
            List tooltip = event.getTooltipElements();
            if (tooltip.isEmpty()) {
                if (showFood) {
                    tooltip.add(Either.right((Object)new FoodComponent(stack, len, 10)));
                }
                if (showSaturation) {
                    tooltip.add(Either.left((Object)saturationText));
                }
            } else {
                int i = 1;
                if (showFood) {
                    tooltip.add(i, Either.right((Object)new FoodComponent(stack, len, 10)));
                    ++i;
                }
                if (showSaturation) {
                    tooltip.add(i, Either.left((Object)saturationText));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record FoodComponent(ItemStack stack, int width, int height) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void m_183452_(@Nonnull Font font, int tooltipX, int tooltipY, @Nonnull PoseStack pose, @Nonnull ItemRenderer itemRenderer, int something) {
            FoodProperties food;
            if (this.stack.m_41614_() && (food = this.stack.m_41720_().m_41473_()) != null) {
                boolean compress;
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft mc = Minecraft.m_91087_();
                int pips = food.m_38744_();
                if (pips == 0) {
                    return;
                }
                boolean poison = FoodTooltips.isPoison(food);
                int count = (int)Math.ceil((double)pips / (double)ImprovedTooltipsModule.foodDivisor);
                boolean fract = pips % 2 != 0;
                int renderCount = count;
                int y = tooltipY - 1;
                boolean bl = compress = count > ImprovedTooltipsModule.foodCompressionThreshold;
                if (compress) {
                    renderCount = 1;
                    if (fract) {
                        --count;
                    }
                }
                pose.m_85836_();
                pose.m_85837_(0.0, 0.0, 500.0);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)ForgeGui.f_93098_);
                for (int i = 0; i < renderCount; ++i) {
                    int x = tooltipX + i * 9 - 1;
                    int u = 16;
                    if (poison) {
                        u += 117;
                    }
                    int v = 27;
                    GuiComponent.m_93133_((PoseStack)pose, (int)x, (int)y, (float)u, (float)v, (int)9, (int)9, (int)256, (int)256);
                    u = 52;
                    if (fract && i == 0) {
                        u += 9;
                    }
                    if (poison) {
                        u += 36;
                    }
                    GuiComponent.m_93133_((PoseStack)pose, (int)x, (int)y, (float)u, (float)v, (int)9, (int)9, (int)256, (int)256);
                }
                if (compress) {
                    mc.f_91062_.m_92750_(pose, "x" + count + (fract ? ".5" : ""), (float)(tooltipX + 10), (float)(y + 1), -10066330);
                }
                pose.m_85849_();
            }
        }

        public int m_142103_() {
            return this.height;
        }

        public int m_142069_(@Nonnull Font font) {
            return this.width;
        }
    }
}

