/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.block;

import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import vazkii.arl.block.BasicBlock;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.client.handler.RequiredModTooltipHandler;
import vazkii.quark.base.module.QuarkModule;

public class QuarkBlock
extends BasicBlock
implements IQuarkBlock {
    private final QuarkModule module;
    private BooleanSupplier enabledSupplier = () -> true;

    public QuarkBlock(String regname, QuarkModule module, CreativeModeTab creativeTab, BlockBehaviour.Properties properties) {
        super(regname, properties);
        this.module = module;
        if (creativeTab != null) {
            RegistryHelper.setCreativeTab((Block)this, (CreativeModeTab)creativeTab);
        }
        if (module.category.isAddon()) {
            RequiredModTooltipHandler.map((Block)this, module.category.requiredMod);
        }
    }

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_49811_(group, items);
        }
    }

    @Override
    public QuarkBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Override
    @Nullable
    public QuarkModule getModule() {
        return this.module;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> thisType, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == thisType ? ticker : null;
    }

    public static interface Constructor<T extends Block> {
        public T make(String var1, QuarkModule var2, CreativeModeTab var3, BlockBehaviour.Properties var4);
    }
}

