/*
 * Decompiled with CFR 0.152.
 */
package com.mcwdoors.kikoz.objects;

import com.mcwdoors.kikoz.init.SoundsInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GarageDoor
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<GaragePart> PART = EnumProperty.m_61587_((String)"part", GaragePart.class);
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final VoxelShape EAST = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);

    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case WEST: {
                return NORTH;
            }
            case EAST: {
                return NORTH;
            }
            case NORTH: {
                return EAST;
            }
            case SOUTH: {
                return EAST;
            }
        }
        return null;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return Shapes.m_83040_();
        }
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case WEST: {
                return NORTH;
            }
            case EAST: {
                return NORTH;
            }
            case NORTH: {
                return EAST;
            }
            case SOUTH: {
                return EAST;
            }
        }
        return null;
    }

    public GarageDoor() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60999_().m_60913_(3.0f, 5.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)((Object)GaragePart.BOTTOM)));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            FluidState topFluidState = world.m_6425_(pos.m_6630_(1));
            Block block = world.m_8055_(pos).m_60734_();
            Block upper = world.m_8055_(pos.m_6630_(1)).m_60734_();
            Block lower = world.m_8055_(pos.m_6625_(1)).m_60734_();
            if (block == this && upper != block) {
                world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.m_76152_() == Fluids.f_76193_)));
            } else {
                world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.BOTTOM))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.m_76152_() == Fluids.f_76193_)));
            }
            if (block == this && upper != block && lower != block) {
                world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.m_76152_() == Fluids.f_76193_)));
            }
            if (block == this && lower == block && upper != block) {
                world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.m_76152_() == Fluids.f_76193_)));
                world.m_46597_(pos.m_6625_(1), (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.BOTTOM))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.m_76152_() == Fluids.f_76193_)));
            }
            if (block == this && lower == block && upper == block) {
                world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.BOTTOM))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.m_76152_() == Fluids.f_76193_)));
                world.m_46597_(pos.m_6625_(1), (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.BOTTOM))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.m_76152_() == Fluids.f_76193_)));
            }
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos postwo, boolean bool) {
        boolean flag;
        boolean bl = world.m_46753_(pos) || world.m_46753_(pos.m_121945_(state.m_61143_(PART) == GaragePart.BOTTOM ? Direction.UP : Direction.DOWN)) || world.m_46753_(pos.m_121945_(state.m_61143_(PART) == GaragePart.TOP ? Direction.UP : Direction.DOWN)) ? true : (flag = false);
        if (!this.m_49966_().m_60713_(block) && flag != (Boolean)state.m_61143_((Property)POWERED)) {
            if (flag != (Boolean)state.m_61143_((Property)OPEN)) {
                world.m_5594_(null, pos, (SoundEvent)SoundsInit.GARAGE.get(), SoundSource.BLOCKS, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.8f);
                this.garageDoor(world, pos, (Boolean)state.m_61143_((Property)OPEN) == false, (Direction)state.m_61143_((Property)FACING), 1000);
            }
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, FACING, POWERED, WATERLOGGED, OPEN});
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.m_61143_((Property)OPEN);
    }

    public void openDoor(Level worldIn, BlockState state, BlockPos pos, boolean open) {
        if (state.m_60713_((Block)this) && (Boolean)state.m_61143_((Property)OPEN) != open) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        Item item = itemstack.m_41720_();
        if (item == this.m_5456_()) {
            return InteractionResult.PASS;
        }
        this.garageDoor(worldIn, pos, (Boolean)state.m_61143_((Property)OPEN) == false, (Direction)state.m_61143_((Property)FACING), 1000);
        worldIn.m_5594_(null, pos, (SoundEvent)SoundsInit.GARAGE.get(), SoundSource.BLOCKS, 0.5f, worldIn.f_46441_.m_188501_() * 0.1f + 0.8f);
        state = (BlockState)state.m_61122_((Property)OPEN);
        worldIn.m_7731_(pos, state, 10);
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        boolean flag = level.m_46753_(blockpos) || level.m_46753_(blockpos.m_7494_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122427_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, Level worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_183324_().m_183582_(currentPos, (Object)Fluids.f_76193_);
        }
        return super.m_7417_(stateIn, facing, facingState, (LevelAccessor)worldIn, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76145_() : super.m_5888_(state);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        FluidState topFluidState = world.m_6425_(pos.m_6630_(1));
        Block block = world.m_8055_(pos).m_60734_();
        Block upper = world.m_8055_(pos.m_6630_(1)).m_60734_();
        Block lower = world.m_8055_(pos.m_6625_(1)).m_60734_();
        if (upper == block && lower == block) {
            world.m_46597_(pos.m_6625_(1), (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.m_76152_() == Fluids.f_76193_)));
        }
        if (lower == block) {
            world.m_46597_(pos.m_6625_(1), (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.m_76152_() == Fluids.f_76193_)));
        }
        world.m_5594_(null, pos, SoundEvents.f_12062_, SoundSource.BLOCKS, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.8f);
        this.m_142387_(world, player, pos, state);
    }

    private void garageDoor(Level world, BlockPos pos, boolean targetOpen, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == this) {
            boolean open = (Boolean)state.m_61143_((Property)OPEN);
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            if (open != targetOpen && direction.equals((Object)targetDirection)) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(targetOpen)));
                switch (targetDirection) {
                    case NORTH: 
                    case SOUTH: {
                        this.garageDoor(world, pos.m_122020_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_122013_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6625_(1).m_122020_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6625_(1).m_122013_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6625_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6625_(2).m_122020_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6625_(2).m_122013_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6625_(2), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6630_(1).m_122020_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6630_(1).m_122013_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6630_(1), targetOpen, targetDirection, depth - 2);
                    }
                    case WEST: 
                    case EAST: {
                        this.garageDoor(world, pos.m_122030_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_122025_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6625_(1).m_122030_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6625_(1).m_122025_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6625_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6625_(2).m_122030_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6625_(2).m_122025_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6625_(2), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6630_(1).m_122030_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6630_(1).m_122025_(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.m_6630_(1), targetOpen, targetDirection, depth - 2);
                    }
                }
                return;
            }
        }
    }

    public static enum GaragePart implements StringRepresentable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private GaragePart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

