/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.AbstractActionGenericRemoveRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.ActionAddRecipeCustomOutput;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker.api.util.Many;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/Refinery")
@ZenCodeType.Name(value="mods.immersiveengineering.Refinery")
public class RefineryRecipeManager
implements IRecipeManager<RefineryRecipe> {
    public RecipeType<RefineryRecipe> getRecipeType() {
        return IERecipeTypes.REFINERY.get();
    }

    public void remove(IIngredient output) {
        throw new UnsupportedOperationException("Cannot remove a refinery recipe by item output, since it only has a fluid output");
    }

    @ZenCodeType.Method
    public void removeRecipe(final IFluidStack fluidStack) {
        CraftTweakerAPI.apply((IAction)new AbstractActionGenericRemoveRecipe<RefineryRecipe>((IRecipeManager)this, (CommandStringDisplayable)fluidStack){

            @Override
            public boolean shouldRemove(RefineryRecipe recipe) {
                return recipe.output.isFluidStackIdentical(fluidStack.getInternal());
            }
        });
    }

    @ZenCodeType.Method
    public void removeRecipe(final Fluid fluid) {
        CraftTweakerAPI.apply((IAction)new AbstractActionGenericRemoveRecipe<RefineryRecipe>((IRecipeManager)this, fluid){

            @Override
            public boolean shouldRemove(RefineryRecipe recipe) {
                return fluid.m_6212_(recipe.output.getFluid());
            }
        });
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, Many<MCTag> fluidInput1, Many<MCTag> fluidInput2, IIngredient catalyst, int energy, IFluidStack output) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        FluidStack outputStack = output.getInternal();
        FluidTagInput tagInput1 = CrTIngredientUtil.getFluidTagInput(fluidInput1);
        FluidTagInput tagInput2 = CrTIngredientUtil.getFluidTagInput(fluidInput2);
        RefineryRecipe recipe = new RefineryRecipe(resourceLocation, outputStack, tagInput1, tagInput2, catalyst.asVanillaIngredient(), energy);
        CraftTweakerAPI.apply(new ActionAddRecipeCustomOutput<RefineryRecipe>(this, recipe, (CommandStringDisplayable)output));
    }
}

