/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.blocks.wooden.ItemBatcherBlockEntity;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ItemBatcherMenu
extends IEContainerMenu {
    public final GetterAndSetter<Integer> batchMode;
    public final List<GetterAndSetter<Integer>> colors;

    public static ItemBatcherMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, ItemBatcherBlockEntity be) {
        List<GetterAndSetter<Integer>> colors = IntStream.range(0, 9).mapToObj(i -> new GetterAndSetter<Integer>(() -> ((DyeColor)be.redstoneColors.get(i)).m_41060_(), c -> be.redstoneColors.set(i, (Object)DyeColor.m_41053_((int)c)))).toList();
        return new ItemBatcherMenu(ItemBatcherMenu.blockCtx(type, id, be), invPlayer, (IItemHandler)new ItemStackHandler(be.getInventory()), (IItemHandler)new ItemStackHandler(be.getFilters()), new GetterAndSetter<Integer>(() -> be.batchMode.ordinal(), b -> {
            be.batchMode = ItemBatcherBlockEntity.BatchMode.values()[b];
        }), colors);
    }

    public static ItemBatcherMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        List<GetterAndSetter<Integer>> colors = IntStream.range(0, 9).mapToObj($ -> GetterAndSetter.standalone(0)).toList();
        return new ItemBatcherMenu(ItemBatcherMenu.clientCtx(type, id), invPlayer, (IItemHandler)new ItemStackHandler(9), (IItemHandler)new ItemStackHandler(9), GetterAndSetter.standalone(0), colors);
    }

    public ItemBatcherMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, IItemHandler filters, IItemHandler buffers, GetterAndSetter<Integer> batchMode, List<GetterAndSetter<Integer>> colors) {
        super(ctx);
        int i;
        this.batchMode = batchMode;
        this.colors = colors;
        for (i = 0; i < 9; ++i) {
            this.m_38897_((Slot)new IESlot.ItemHandlerGhost(filters, i, 8 + i * 18, 30));
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(buffers, i, 8 + i * 18, 59));
        }
        this.ownSlotCount = 18;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 118 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 176));
        }
        this.addGenericData(new GenericContainerData<Integer>(GenericDataSerializers.INT32, batchMode));
        for (GetterAndSetter<Integer> color : colors) {
            this.addGenericData(new GenericContainerData<Integer>(GenericDataSerializers.INT32, color));
        }
    }

    @Override
    @Nonnull
    public ItemStack m_7648_(Player player, int slot) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slotObject = (Slot)this.f_38839_.get(slot);
        if (slotObject != null && slotObject.m_6657_()) {
            ItemStack itemstack1 = slotObject.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slot < this.ownSlotCount ? !this.m_38903_(itemstack1, this.ownSlotCount, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 9, this.ownSlotCount, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slotObject.m_5852_(ItemStack.f_41583_);
            } else {
                slotObject.m_6654_();
            }
        }
        return itemstack;
    }

    @Override
    public void receiveMessageFromScreen(CompoundTag nbt) {
        super.receiveMessageFromScreen(nbt);
        if (nbt.m_128425_("batchMode", 1)) {
            this.batchMode.set(Integer.valueOf(nbt.m_128445_("batchMode")));
        }
        if (nbt.m_128425_("redstoneColor_slot", 3)) {
            int slot = nbt.m_128451_("redstoneColor_slot");
            int newValue = nbt.m_128451_("redstoneColor_val");
            this.colors.get(slot).set(newValue);
        }
    }
}

