/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;

public class CokeOvenRecipeSerializer
extends IERecipeSerializer<CokeOvenRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.Multiblocks.COKE_OVEN);
    }

    @Override
    public CokeOvenRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        Lazy<ItemStack> output = CokeOvenRecipeSerializer.readOutput(json.get("result"));
        IngredientWithSize input = IngredientWithSize.deserialize(json.get("input"));
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        int oil = GsonHelper.m_13927_((JsonObject)json, (String)"creosote");
        return new CokeOvenRecipe(recipeId, output, input, time, oil);
    }

    @Nullable
    public CokeOvenRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Lazy<ItemStack> output = CokeOvenRecipeSerializer.readLazyStack(buffer);
        IngredientWithSize input = IngredientWithSize.read(buffer);
        int time = buffer.readInt();
        int oil = buffer.readInt();
        return new CokeOvenRecipe(recipeId, output, input, time, oil);
    }

    public void toNetwork(FriendlyByteBuf buffer, CokeOvenRecipe recipe) {
        CokeOvenRecipeSerializer.writeLazyStack(buffer, recipe.output);
        recipe.input.write(buffer);
        buffer.writeInt(recipe.time);
        buffer.writeInt(recipe.creosoteOutput);
    }
}

