/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.gui.CrateMenu;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;

public class WoodenCrateBlockEntity
extends RandomizableContainerBlockEntity
implements IIEInventory,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IComparatorOverride {
    public static final int CONTAINER_SIZE = 27;
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private ListTag enchantments;

    public WoodenCrateBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.WOODEN_CRATE.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.loadIEData(nbt);
    }

    private void loadIEData(CompoundTag nbt) {
        if (nbt.m_128425_("enchantments", 9)) {
            this.enchantments = nbt.m_128437_("enchantments", 10);
        }
        if (nbt.m_128425_("lootTable", 8) && !nbt.m_128441_("LootTable")) {
            nbt.m_128359_("LootTable", nbt.m_128461_("lootTable"));
        }
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.enchantments != null && this.enchantments.size() > 0) {
            nbt.m_128365_("enchantments", (Tag)this.enchantments);
        }
        if (!this.m_59634_(nbt)) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }
    }

    protected Component m_6820_() {
        Block b = this.m_58900_().m_60734_();
        if (b == IEBlocks.WoodenDevices.REINFORCED_CRATE.get()) {
            return Component.m_237115_((String)"block.immersiveengineering.reinforced_crate");
        }
        return Component.m_237115_((String)"block.immersiveengineering.crate");
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.inventory;
    }

    protected void m_6520_(NonNullList<ItemStack> pItemStacks) {
        this.inventory = pItemStacks;
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return new CrateMenu((MenuType)IEMenuTypes.WOODEN_CRATE.get(), pContainerId, pInventory, (Container)this);
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return IEApi.isAllowedInCrate(stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
    }

    @Override
    public List<ItemStack> getBlockEntityDrop(LootContext context) {
        Component customName;
        ItemStack stack = new ItemStack((ItemLike)this.m_58900_().m_60734_(), 1);
        CompoundTag tag = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)tag, this.inventory, (boolean)false);
        if (!tag.m_128456_()) {
            stack.m_41751_(tag);
        }
        if ((customName = this.m_7770_()) != null) {
            stack.m_41714_(customName);
        }
        if (this.enchantments != null && this.enchantments.size() > 0) {
            stack.m_41784_().m_128365_("ench", (Tag)this.enchantments);
        }
        return ImmutableList.of((Object)stack);
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        if (stack.m_41782_()) {
            this.loadIEData(stack.m_41784_());
            if (stack.m_41788_()) {
                this.m_58638_(stack.m_41786_());
            }
            this.enchantments = stack.m_41785_();
        }
    }

    @Override
    public int getComparatorInputOverride() {
        return Utils.calcRedstoneFromInventory(this);
    }

    public int m_6643_() {
        return 27;
    }
}

