/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorBelt;
import blusunrize.immersiveengineering.api.utils.EntityCollisionTracker;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBeltBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class ConveyorBase
implements IConveyorBelt {
    public static ResourceLocation texture_on = new ResourceLocation("immersiveengineering:block/conveyor/conveyor");
    public static ResourceLocation texture_off = new ResourceLocation("immersiveengineering:block/conveyor/off");
    private Block cover = Blocks.f_50016_;
    ConveyorHandler.ConveyorDirection direction = ConveyorHandler.ConveyorDirection.HORIZONTAL;
    @Nullable
    DyeColor dyeColour = null;
    private final BlockEntity tile;
    protected final EntityCollisionTracker collisionTracker = new EntityCollisionTracker(10);
    private static final AABB topBox = new AABB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
    private static final CachedVoxelShapes<ShapeKey> SHAPES = new CachedVoxelShapes<ShapeKey>(ConveyorBase::getBoxes);
    public static ArrayList<Predicate<Block>> validCoveyorCovers = new ArrayList();

    public ConveyorBase(BlockEntity tile) {
        this.tile = tile;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this.tile;
    }

    @Override
    public ConveyorHandler.ConveyorDirection getConveyorDirection() {
        return this.direction;
    }

    @Override
    public boolean changeConveyorDirection() {
        if (!this.tile.m_58904_().f_46443_) {
            this.direction = this.direction == ConveyorHandler.ConveyorDirection.HORIZONTAL ? ConveyorHandler.ConveyorDirection.UP : (this.direction == ConveyorHandler.ConveyorDirection.UP ? ConveyorHandler.ConveyorDirection.DOWN : ConveyorHandler.ConveyorDirection.HORIZONTAL);
        }
        return true;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        this.direction = dir;
        return true;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void onEntityCollision(@Nonnull Entity entity) {
        this.collisionTracker.onEntityCollided(entity);
        IConveyorBelt.super.onEntityCollision(entity);
        if (this.isCovered() && entity instanceof ItemEntity) {
            ((ItemEntity)entity).m_32010_(10);
        }
    }

    @Override
    public boolean isBlocked() {
        return this.collisionTracker.getCollidedInRange(this.getBlockEntity().m_58904_().m_46467_()) > 2;
    }

    @Override
    public void onItemDeployed(ItemEntity entity) {
        IConveyorBelt.super.onItemDeployed(entity);
        if (this.isCovered()) {
            entity.m_32010_(10);
        }
    }

    @Override
    public boolean playerInteraction(Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, Direction side) {
        return this.handleCoverInteraction(player, hand, heldItem);
    }

    @Override
    public CompoundTag writeConveyorNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("direction", this.direction.ordinal());
        if (this.dyeColour != null) {
            nbt.m_128405_("dyeColour", this.dyeColour.m_41060_());
        }
        if (this.cover != Blocks.f_50016_) {
            nbt.m_128359_("cover", ForgeRegistries.BLOCKS.getKey((Object)this.cover).toString());
        }
        return nbt;
    }

    @Override
    public void readConveyorNBT(CompoundTag nbt) {
        this.direction = ConveyorHandler.ConveyorDirection.values()[nbt.m_128451_("direction")];
        this.dyeColour = nbt.m_128425_("dyeColour", 3) ? DyeColor.m_41053_((int)nbt.m_128451_("dyeColour")) : null;
        if (nbt.m_128425_("cover", 8)) {
            this.cover = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("cover")));
        }
    }

    @Override
    public boolean setDyeColour(DyeColor colour) {
        if (colour == this.dyeColour) {
            return false;
        }
        this.dyeColour = colour;
        return true;
    }

    @Override
    public DyeColor getDyeColour() {
        return this.dyeColour;
    }

    @Override
    public VoxelShape getCollisionShape() {
        VoxelShape baseShape = IConveyorBelt.super.getCollisionShape();
        if (this.isCovered()) {
            return SHAPES.get(new ShapeKey(this, true, baseShape));
        }
        return baseShape;
    }

    @Override
    public VoxelShape getSelectionShape() {
        if (this.isCovered()) {
            return SHAPES.get(new ShapeKey(this, false, null));
        }
        return IConveyorBelt.super.getSelectionShape();
    }

    protected final boolean isCovered() {
        return IConveyorBelt.isCovered(this, Blocks.f_50016_);
    }

    private static List<AABB> getBoxes(ShapeKey key) {
        ArrayList<AABB> ret = new ArrayList<AABB>();
        if (key.superShape != null) {
            ret.addAll(key.superShape.m_83299_());
        }
        if (key.direction == ConveyorHandler.ConveyorDirection.HORIZONTAL) {
            if (!key.collision) {
                return ImmutableList.of((Object)FULL_BLOCK.m_83215_());
            }
            ret.add(topBox);
        } else {
            boolean up = key.direction == ConveyorHandler.ConveyorDirection.UP;
            boolean collision = key.collision;
            Direction facing = key.facing;
            ret.add(new AABB(facing == Direction.WEST && !up || facing == Direction.EAST && up ? 0.5 : 0.0, collision ? 1.75 : 0.5, facing == Direction.NORTH && !up || facing == Direction.SOUTH && up ? 0.5 : 0.0, facing == Direction.WEST && up || facing == Direction.EAST && !up ? 0.5 : 1.0, 2.0, facing == Direction.NORTH && up || facing == Direction.SOUTH && !up ? 0.5 : 1.0));
            ret.add(new AABB(facing == Direction.WEST && up || facing == Direction.EAST && !up ? 0.5 : 0.0, collision ? 1.25 : 0.0, facing == Direction.NORTH && up || facing == Direction.SOUTH && !up ? 0.5 : 0.0, facing == Direction.WEST && !up || facing == Direction.EAST && up ? 0.5 : 1.0, 1.5, facing == Direction.NORTH && !up || facing == Direction.SOUTH && up ? 0.5 : 1.0));
        }
        return ret;
    }

    public void dropCover(Player player) {
        ItemEntity entityitem;
        if (this.tile != null && !this.tile.m_58904_().f_46443_ && this.cover != Blocks.f_50016_ && this.tile.m_58904_().m_46469_().m_46207_(GameRules.f_46136_) && (entityitem = player.m_36176_(new ItemStack((ItemLike)this.cover), false)) != null) {
            entityitem.m_32061_();
        }
    }

    protected boolean handleCoverInteraction(Player player, InteractionHand hand, ItemStack heldItem) {
        Block heldBlock;
        if (heldItem.m_41619_() && player.m_6144_() && this.cover != Blocks.f_50016_) {
            this.dropCover(player);
            this.cover = Blocks.f_50016_;
            return true;
        }
        if (!heldItem.m_41619_() && !player.m_6144_() && (heldBlock = Block.m_49814_((Item)heldItem.m_41720_())) != Blocks.f_50016_) {
            for (Predicate<Block> func : validCoveyorCovers) {
                if (!func.test(heldBlock) || heldBlock == this.cover) continue;
                this.dropCover(player);
                this.cover = heldBlock;
                heldItem.m_41774_(1);
                if (heldItem.m_41613_() <= 0) {
                    player.m_21008_(hand, heldItem);
                }
                return true;
            }
        }
        return false;
    }

    protected final boolean isPowered() {
        BlockEntity te = this.getBlockEntity();
        if (te instanceof ConveyorBeltBlockEntity) {
            ConveyorBeltBlockEntity conveBE = (ConveyorBeltBlockEntity)te;
            return conveBE.isRSPowered();
        }
        return te.m_58904_().m_46755_(te.m_58899_()) > 0;
    }

    @Override
    public Direction getFacing() {
        BlockEntity te = this.getBlockEntity();
        if (te instanceof IEBlockInterfaces.IDirectionalBE) {
            return ((IEBlockInterfaces.IDirectionalBE)te).getFacing();
        }
        return Direction.NORTH;
    }

    @Override
    public Block getCover() {
        return this.cover;
    }

    @Override
    public void setCover(Block cover) {
        this.cover = cover;
    }

    static {
        validCoveyorCovers.add(b -> b.m_49966_().m_204336_(IETags.scaffoldingAlu));
        validCoveyorCovers.add(b -> b.m_49966_().m_204336_(IETags.scaffoldingSteel));
        validCoveyorCovers.add(input -> input == IEBlocks.WoodenDecoration.TREATED_SCAFFOLDING.get());
        validCoveyorCovers.add(b -> b.m_49966_().m_204336_(Tags.Blocks.GLASS));
    }

    private static class ShapeKey {
        private final ConveyorHandler.ConveyorDirection direction;
        private final boolean collision;
        private final Direction facing;
        @Nullable
        private final VoxelShape superShape;

        public ShapeKey(ConveyorBase conveyor, boolean collision, @Nullable VoxelShape superShape) {
            this.direction = conveyor.getConveyorDirection();
            this.collision = collision;
            this.facing = conveyor.getFacing();
            this.superShape = superShape;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShapeKey shapeKey = (ShapeKey)o;
            return this.collision == shapeKey.collision && this.direction == shapeKey.direction && this.facing == shapeKey.facing && Objects.equals(this.superShape, shapeKey.superShape);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.direction, this.collision, this.facing, this.superShape});
        }
    }
}

