/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class FurnaceHeaterBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHammerInteraction {
    public MutableEnergyStorage energyStorage;
    private final ResettableCapability<IEnergyStorage> energyCap;
    private final Collection<CapabilityReference<ExternalHeaterHandler.IExternalHeatable>> heatables;

    public FurnaceHeaterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.FURNACE_HEATER.get(), pos, state);
        this.energyStorage = new MutableEnergyStorage(32000, Math.max(256, Math.max((Integer)IEServerConfig.MACHINES.heater_consumption.get(), (Integer)IEServerConfig.MACHINES.heater_speedupConsumption.get())));
        this.energyCap = this.registerEnergyInput(this.energyStorage);
        this.heatables = CapabilityReference.forAllNeighbors(this, ExternalHeaterHandler.CAPABILITY).values();
    }

    @Override
    public void tickServer() {
        boolean activeBeforeTick = this.getIsActive();
        boolean redstonePower = this.isRSPowered();
        boolean newActive = activeBeforeTick;
        if (activeBeforeTick && !redstonePower) {
            newActive = false;
        }
        if (this.energyStorage.getEnergyStored() > 3200 || activeBeforeTick) {
            for (CapabilityReference<ExternalHeaterHandler.IExternalHeatable> capRef : this.heatables) {
                int consumed;
                ExternalHeaterHandler.IExternalHeatable heatable = capRef.getNullable();
                if (heatable == null || (consumed = heatable.doHeatTick(this.energyStorage.getEnergyStored(), redstonePower)) <= 0) continue;
                this.energyStorage.extractEnergy(consumed, false);
                newActive = true;
            }
        }
        if (newActive != activeBeforeTick) {
            this.setActive(newActive);
            this.m_6596_();
        }
    }

    @Override
    public boolean m_7531_(int id, int arg) {
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        EnergyHelper.deserializeFrom(this.energyStorage, nbt);
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        EnergyHelper.serializeTo(this.energyStorage, nbt);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && (side == null || side == this.getFacing())) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.PISTON_LIKE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return placer.m_6144_();
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        this.setFacing(side);
        return true;
    }
}

