/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.common.blocks.IEEntityBlock;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorBlockEntity;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.RegistryObject;

public abstract class ConnectorBlock<T extends BlockEntity>
extends IEEntityBlock<T> {
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60913_(3.0f, 15.0f).m_60955_();
    public static final EnumProperty<Direction> DEFAULT_FACING_PROP = IEProperties.FACING_ALL;

    public ConnectorBlock(BlockBehaviour.Properties props, RegistryObject<BlockEntityType<T>> entityType) {
        super(entityType, props);
        this.lightOpacity = 0;
        this.setMobility(PushReaction.BLOCK);
    }

    public ConnectorBlock(BlockBehaviour.Properties props, BiFunction<BlockPos, BlockState, T> entityType) {
        super(entityType, props);
        this.lightOpacity = 0;
        this.setMobility(PushReaction.BLOCK);
    }

    @Override
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        EnergyConnectorBlockEntity connector;
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof EnergyConnectorBlockEntity && world.m_46859_(pos.m_121945_((connector = (EnergyConnectorBlockEntity)te).getFacing()))) {
            ConnectorBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this));
            connector.getLevelNonnull().m_7471_(pos, false);
        }
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult targetIn, BlockGetter world, BlockPos pos, Player player) {
        if (player != null && player.m_6144_() && world instanceof Level && targetIn instanceof BlockHitResult) {
            BlockHitResult target = (BlockHitResult)targetIn;
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof IImmersiveConnectable) {
                ConnectionPoint cp;
                TargetingInfo subTarget = new TargetingInfo(target.m_82434_(), (float)target.m_82450_().f_82479_ - (float)pos.m_123341_(), (float)target.m_82450_().f_82480_ - (float)pos.m_123342_(), (float)target.m_82450_().f_82481_ - (float)pos.m_123343_());
                BlockPos masterPos = ((IImmersiveConnectable)te).getConnectionMaster(null, subTarget);
                if (masterPos != pos) {
                    te = world.m_7702_(masterPos);
                }
                if (te instanceof IImmersiveConnectable && (cp = ((IImmersiveConnectable)te).getTargetedPoint(subTarget, (Vec3i)masterPos.m_121996_((Vec3i)pos))) != null) {
                    for (Connection c : GlobalWireNetwork.getNetwork((Level)world).getLocalNet(cp).getConnections(cp)) {
                        if (c.isInternal()) continue;
                        return c.type.getWireCoil(c);
                    }
                }
            }
        }
        return super.getCloneItemStack(state, targetIn, world, pos, player);
    }
}

