/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.client.IVertexBufferHolder;
import blusunrize.immersiveengineering.api.utils.client.ModelDataUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.IEOBJCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.BucketWheelCallbacks;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.common.blocks.metal.BucketWheelBlockEntity;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.NonNullSupplier;

public class BucketWheelRenderer
extends IEBlockEntityRenderer<BucketWheelBlockEntity> {
    public static final String NAME = "bucket_wheel";
    public static DynamicModel WHEEL;
    private static final Cache<BucketWheelCallbacks.Key, IVertexBufferHolder> CACHED_BUFFERS;

    public void render(BucketWheelBlockEntity tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.formed || !tile.getLevelNonnull().m_46805_(tile.m_58899_()) || tile.isDummy()) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 90.0f, true));
        BERenderUtils.mirror(tile, matrixStack);
        float dir = tile.getFacing() == Direction.SOUTH ? 0.0f : (tile.getFacing() == Direction.NORTH ? 180.0f : (tile.getFacing() == Direction.EAST ? 90.0f : -90.0f));
        matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), dir, true));
        float rot = tile.rotation + (float)(tile.active ? (Double)IEServerConfig.MACHINES.excavator_speed.get() * (double)partialTicks : 0.0);
        matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), rot, true));
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        try {
            BucketWheelCallbacks.Key key = BucketWheelCallbacks.INSTANCE.extractKey((BlockAndTintGetter)tile.getLevelNonnull(), tile.m_58899_(), tile.getState(), tile);
            ModelData extraData = ModelDataUtils.single(IEOBJCallbacks.getModelProperty(BucketWheelCallbacks.INSTANCE), key);
            ((IVertexBufferHolder)CACHED_BUFFERS.get((Object)key, () -> IVertexBufferHolder.create((NonNullSupplier<List<BakedQuad>>)((NonNullSupplier)() -> WHEEL.get().getQuads(null, null, ApiUtils.RANDOM_SOURCE, extraData, RenderType.m_110451_()))))).render(RenderType.m_110451_(), combinedLightIn, combinedOverlayIn, bufferIn, matrixStack, tile.getIsMirrored());
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        matrixStack.m_85849_();
    }

    public static void reset() {
        CACHED_BUFFERS.invalidateAll();
    }

    static {
        CACHED_BUFFERS = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(1L, TimeUnit.MINUTES).removalListener(rem -> ((IVertexBufferHolder)rem.getValue()).reset()).build();
    }
}

