/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.block;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.block.BlockCallback;
import blusunrize.immersiveengineering.common.blocks.generic.PostBlock;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PostCallbacks
implements BlockCallback<Key> {
    public static final PostCallbacks INSTANCE = new PostCallbacks();

    @Override
    public Key extractKey(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, BlockEntity blockEntity) {
        int height = (Integer)state.m_61143_((Property)PostBlock.POST_SLAVE);
        BlockPos centerPos = pos.m_121996_(((PostBlock.HorizontalOffset)((Object)state.m_61143_(PostBlock.HORIZONTAL_OFFSET))).getOffset());
        BlockState centerState = level.m_8055_(centerPos);
        EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
        EnumSet<Direction> downArms = EnumSet.noneOf(Direction.class);
        if (centerState.m_60734_() == state.m_60734_()) {
            for (Direction f : DirectionUtils.BY_HORIZONTAL_INDEX) {
                BlockPos armPos;
                if (!PostBlock.hasConnection(centerState, f, (BlockGetter)level, centerPos)) continue;
                connections.add(f);
                if (height != 3 || !PostBlock.hasConnection(level.m_8055_(armPos = centerPos.m_121945_(f)), Direction.DOWN, (BlockGetter)level, armPos)) continue;
                downArms.add(f);
            }
        }
        return new Key(state, connections, downArms);
    }

    @Override
    public Key getDefaultKey() {
        return new Key(IEBlocks.WoodenDecoration.TREATED_POST.defaultBlockState(), EnumSet.noneOf(Direction.class), EnumSet.noneOf(Direction.class));
    }

    @Override
    public IEProperties.IEObjState getIEOBJState(Key key) {
        ArrayList<String> visible = new ArrayList<String>();
        visible.add("base");
        int height = (Integer)key.state().m_61143_((Property)PostBlock.POST_SLAVE);
        for (Direction f : key.connections()) {
            String name = f.m_122424_().m_7912_();
            if (height == 3) {
                if (key.downArms().contains(f)) {
                    visible.add("arm_" + name + "_down");
                    continue;
                }
                visible.add("arm_" + name + "_up");
                continue;
            }
            visible.add("con_" + (height - 1) + "_" + name);
        }
        return new IEProperties.IEObjState(IEProperties.VisibilityList.show(visible));
    }

    public record Key(BlockState state, EnumSet<Direction> connections, EnumSet<Direction> downArms) {
    }
}

