/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.block;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.block.BlockCallback;
import blusunrize.immersiveengineering.common.blocks.metal.FloodlightBlockEntity;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FloodlightCallbacks
implements BlockCallback<Key> {
    public static final FloodlightCallbacks INSTANCE = new FloodlightCallbacks();
    private static final Key INVALID = new Key(Direction.NORTH, Direction.DOWN, 0.0f, 0.0f);

    @Override
    public Key extractKey(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, BlockEntity blockEntity) {
        if (!(blockEntity instanceof FloodlightBlockEntity)) {
            return this.getDefaultKey();
        }
        FloodlightBlockEntity floodlight = (FloodlightBlockEntity)blockEntity;
        return new Key(floodlight.facing, floodlight.getFacing(), floodlight.rotX, floodlight.rotY);
    }

    @Override
    public Key getDefaultKey() {
        return INVALID;
    }

    @Override
    public boolean dependsOnLayer() {
        return true;
    }

    @Override
    public boolean shouldRenderGroup(Key object, String group, RenderType layer) {
        if ("glass".equals(group)) {
            return layer == RenderType.m_110466_();
        }
        return layer == RenderType.m_110451_();
    }

    @Override
    public Transformation applyTransformations(Key object, String group, Transformation transform) {
        Vector3f transl = new Vector3f(0.5f, 0.5f, 0.5f);
        double yaw = 0.0;
        double pitch = 0.0;
        double roll = 0.0;
        Direction side = object.side();
        Direction facing = object.facing();
        float rotX = object.rotX();
        float rotY = object.rotY();
        if (side.m_122434_() == Direction.Axis.Y) {
            double d = facing == Direction.SOUTH ? 180.0 : (facing == Direction.WEST ? 90.0 : (yaw = facing == Direction.EAST ? -90.0 : 0.0));
            if (side == Direction.DOWN) {
                roll = 180.0;
            }
        } else {
            if (side == Direction.NORTH) {
                pitch = 90.0;
                yaw = 180.0;
            }
            if (side == Direction.SOUTH) {
                pitch = 90.0;
            }
            if (side == Direction.WEST) {
                pitch = 90.0;
                yaw = -90.0;
            }
            if (side == Direction.EAST) {
                pitch = 90.0;
                yaw = 90.0;
            }
            if (facing == Direction.DOWN) {
                roll += 180.0;
            } else if (side.m_122434_() == Direction.Axis.X && facing.m_122434_() == Direction.Axis.Z) {
                roll += (double)(90 * facing.m_122421_().m_122540_() * side.m_122421_().m_122540_());
            } else if (side.m_122434_() == Direction.Axis.Z && facing.m_122434_() == Direction.Axis.X) {
                roll += (double)(-90 * facing.m_122421_().m_122540_() * side.m_122421_().m_122540_());
            }
        }
        transl.m_122253_(new Vector3f((float)side.m_122429_() * 0.125f, (float)side.m_122430_() * 0.125f, (float)side.m_122431_() * 0.125f));
        if ("axis".equals(group) || "light".equals(group) || "off".equals(group) || "glass".equals(group)) {
            if (side.m_122434_() == Direction.Axis.Y) {
                yaw += (double)rotY;
            } else {
                roll += (double)rotY;
            }
            if ("light".equals(group) || "off".equals(group) || "glass".equals(group)) {
                pitch += (double)rotX;
            }
        }
        return new Transformation(transl, ClientUtils.degreeToQuaterion(pitch, yaw, roll), null, null).blockCornerToCenter();
    }

    public record Key(Direction facing, Direction side, float rotX, float rotY) {
    }
}

